/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import com.huawei.ism.tool.base.osplatform.OsEnumn;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.XmlEnums;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.dom4j.io.SAXReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlUtils {
    private static final Logger log = LoggerFactory.getLogger(XmlUtils.class);
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
    public static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = XmlUtils.getDocumentBuilderFactory();
    public static final String ENTER = System.lineSeparator();
    private static DocumentBuilder documentBuilder = null;
    private static final XPath XPATH = XPathFactory.newInstance().newXPath();

    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature(XmlEnums.SECURE_PROCESSING.getResourceValue(), true);
            factory.setFeature(XmlEnums.DISALLOW_DOCTYPE_DECL.getResourceValue(), true);
            factory.setFeature(XmlEnums.EXTERNAL_GENERAL_ENTITY.getResourceValue(), false);
            factory.setFeature(XmlEnums.EXTERNAL_PARAMETER_ENTITY.getResourceValue(), false);
            factory.setFeature(XmlEnums.LOAD_EXTERNAL_DTD.getResourceValue(), false);
        }
        catch (ParserConfigurationException e) {
            log.error("Initialize document builder factory error.", (Throwable)e);
        }
        return factory;
    }

    public static DocumentBuilderFactory getIgnoreWhitespaceDocBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory = XmlUtils.getDocumentBuilderFactory();
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        return documentBuilderFactory;
    }

    public static DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        return DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
    }

    public static SAXReader getSaxReader() throws SAXException {
        SAXReader saxReader = new SAXReader();
        saxReader.setFeature(XmlEnums.DISALLOW_DOCTYPE_DECL.getResourceValue(), true);
        saxReader.setFeature(XmlEnums.EXTERNAL_GENERAL_ENTITY.getResourceValue(), false);
        saxReader.setFeature(XmlEnums.EXTERNAL_PARAMETER_ENTITY.getResourceValue(), false);
        saxReader.setFeature(XmlEnums.LOAD_EXTERNAL_DTD.getResourceValue(), false);
        saxReader.setFeature(XmlEnums.SECURE_PROCESSING.getResourceValue(), true);
        return saxReader;
    }

    public static Transformer newTransformer() throws TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        return transformerFactory.newTransformer();
    }

    public static DocumentBuilder getSecureDocumentBuilder() throws ParserConfigurationException {
        return DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
    }

    @Nullable
    public static synchronized Document parseDocument(@NotNull InputStream input) {
        Document document = null;
        try {
            document = documentBuilder.parse(input);
            document.normalize();
        }
        catch (Exception e) {
            log.error("parse xml document error.", (Throwable)e);
        }
        return document;
    }

    @Nullable
    public static synchronized Document parseDocument(@NotNull InputStream input, @NotNull String charset) {
        Document document = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(input, charset));){
            InputSource in = new InputSource(br);
            document = documentBuilder.parse(in);
            document.normalize();
        }
        catch (Exception e) {
            log.error("parse xml document with charset {} error.", (Object)charset, (Object)e);
        }
        return document;
    }

    private XmlUtils() {
    }

    public static String getTextContentOfChild(Element parent, String childTagName) {
        String result = null;
        Node node = parent.getFirstChild();
        while (null != node) {
            if (!(node instanceof Element)) {
                node = node.getNextSibling();
                continue;
            }
            Element element = (Element)node;
            String tagName = element.getTagName();
            String content = element.getTextContent();
            if (childTagName.equals(tagName)) {
                result = content.trim();
                break;
            }
            node = node.getNextSibling();
        }
        return result;
    }

    public static String getAttribute(Element element, String attriName, String defaultValue) {
        String attribute = element.getAttribute(attriName);
        if (StringUtils.isNULLStr(attribute)) {
            attribute = defaultValue;
        }
        return attribute.trim();
    }

    public static Collection<Element> getChildren(Element parent, String childTagName) {
        ArrayList<Element> children = new ArrayList<Element>();
        if (null == parent) {
            return children;
        }
        for (Node child = parent.getFirstChild(); null != child; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element element = (Element)child;
            String tagName = element.getTagName();
            if (null != childTagName && !childTagName.equals(tagName)) continue;
            children.add(element);
        }
        return children;
    }

    public static Element getChild(Element parent, String childTagName) {
        Element result = null;
        for (Node child = parent.getFirstChild(); null != child; child = child.getNextSibling()) {
            Element element;
            String tagName;
            if (!(child instanceof Element) || !(tagName = (element = (Element)child).getTagName()).equals(childTagName)) continue;
            result = element;
            break;
        }
        return result;
    }

    public static Collection<Element> getChildren(Element parent) {
        return XmlUtils.getChildren(parent, null);
    }

    public static String getAttribute(Element element, String attribute) {
        String result = element.getAttribute(attribute);
        if (StringUtils.isNULLStr(result)) {
            return null;
        }
        return result.trim();
    }

    public static String getLocaleAttribute(Element element, String attribute, boolean isEnglishEnv) {
        String result = element.getAttribute(attribute);
        if (StringUtils.isNULLStr(result)) {
            return null;
        }
        if ((result = result.trim()).indexOf("##") == -1) {
            return result;
        }
        String[] sp = result.split("##");
        if (isEnglishEnv) {
            return sp[1];
        }
        return sp[0];
    }

    public static NodeList searchNodeByExp(Document doc, String xql) {
        NodeList nodeList = null;
        try {
            Object result = XPATH.evaluate(xql, doc, XPathConstants.NODESET);
            nodeList = (NodeList)result;
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(XmlUtils.class).error("eval error," + xql, (Throwable)e);
        }
        return nodeList;
    }

    public static Collection<Element> searchByExp2Ele(Node node, String xql) {
        ArrayList<Element> eles = new ArrayList<Element>();
        NodeList nodeList = null;
        try {
            Object result = XPATH.evaluate(xql, node, XPathConstants.NODESET);
            nodeList = (NodeList)result;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node n = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                eles.add((Element)n);
            }
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(XmlUtils.class).error("eval error," + xql, (Throwable)e);
        }
        return eles;
    }

    public static NodeList searchNodeByExp(Element element, String xql) {
        NodeList nodeList = null;
        try {
            Object result = XPATH.evaluate(xql, element, XPathConstants.NODESET);
            nodeList = (NodeList)result;
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(XmlUtils.class).error("eval error," + xql, (Throwable)e);
        }
        return nodeList;
    }

    public static Document createDomByXmlString(String str, String tagName) throws ToolException {
        if (StringUtils.isNULLStr(str)) {
            return null;
        }
        int beginIndex = str.indexOf("<" + tagName + ">");
        int endIndex = str.indexOf("</" + tagName + ">");
        if (-1 == beginIndex || -1 == endIndex) {
            throw new ToolException("The result xml \"" + str + "\" parse error:");
        }
        String returnXml = str.substring(beginIndex, endIndex + ("</" + tagName + ">").length());
        if (!str.contains("<?xml")) {
            returnXml = XML_HEADER + ENTER + returnXml;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(returnXml.getBytes(Charset.forName("UTF-8")));
        return XmlUtils.parseDocument(is);
    }

    public static Map getItemNodesEachWithAnOnlyId(Element root, String tagName, String idPropertyName, List<String> propertyNamesBesidesId, String ... subTagNames) {
        Collection<Element> itemNodes = XmlUtils.getChildren(root, tagName);
        HashMap itemNodesMap = new HashMap();
        itemNodes.forEach(itemNode -> {
            HashMap subLabelBlock = new HashMap();
            propertyNamesBesidesId.forEach(propertyName -> subLabelBlock.put(propertyName, XmlUtils.getTextContentOfChild(itemNode, propertyName)));
            Arrays.stream(subTagNames).forEach(subTagName -> subLabelBlock.put(subTagName, XmlUtils.getAttribute(itemNode, subTagName)));
            itemNodesMap.put(idPropertyName, subLabelBlock);
        });
        return itemNodesMap;
    }

    public static Set<OsEnumn> parseSupportOs(Element xmlTag) {
        HashSet<OsEnumn> supportOs = new HashSet<OsEnumn>();
        supportOs.add(OsEnumn.WINDOWS);
        String attribute = XmlUtils.getAttribute(xmlTag, "extend-os");
        if (!StringUtils.isNULLStr(attribute)) {
            Arrays.stream(attribute.split(",")).map(OsEnumn::of).forEach(supportOs::add);
        }
        return supportOs;
    }

    static {
        try {
            documentBuilder = XmlUtils.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.error("Build documentBuilder failed.", (Throwable)e);
        }
    }
}

