/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils.crypto;

import com.huawei.ism.tool.base.context.SmartKitClassLoader;
import com.huawei.ism.tool.base.context.StartParamContext;
import com.huawei.ism.tool.base.utils.crypto.AesCrypterManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmeEncryptManager
implements AesCrypterManager {
    private static final Logger log = LoggerFactory.getLogger(DmeEncryptManager.class);
    private static boolean isInitSuccess = false;
    private static Class<?> cipherUtilClass;
    private static Method encryptMethod;
    private static Method decryptMethod;
    private static final String DEFAULT_FAIL_VALUE = "";

    private static void initDmeEncryptManager() {
        try {
            if (StartParamContext.getNeedJar().isEmpty()) {
                log.info("need jar is empty, not need init Dme encrypt manager");
                return;
            }
            log.info("init Dme encrypt manager start");
            cipherUtilClass = new SmartKitClassLoader(StartParamContext.getNeedJar(), null).loadClass("com.huawei.dj.sdk.util.CipherUtil");
            DmeEncryptManager.initNeedMethod(cipherUtilClass);
            log.info("init Dme encrypt manager success");
            isInitSuccess = true;
        }
        catch (ClassNotFoundException e) {
            log.error("can't find class when init Dme encrypt manager", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.error("can't find method when init Dme encrypt manager", (Throwable)e);
        }
    }

    private static void initNeedMethod(Class<?> cipherUtilClass) throws NoSuchMethodException {
        encryptMethod = cipherUtilClass.getMethod("encrypt", String.class);
        decryptMethod = cipherUtilClass.getMethod("decrypt", String.class);
    }

    @Override
    public boolean isInitSuccess() {
        return isInitSuccess;
    }

    @Override
    public String performEncrypt(String content) {
        if (!isInitSuccess) {
            log.error("Dme encrypt init fail");
            return DEFAULT_FAIL_VALUE;
        }
        try {
            return (String)encryptMethod.invoke(cipherUtilClass, content);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("use Dme encrypt error", (Throwable)e);
            return DEFAULT_FAIL_VALUE;
        }
    }

    @Override
    public String performDecrypt(String content) {
        if (!isInitSuccess) {
            log.error("Dme encrypt init fail");
            return DEFAULT_FAIL_VALUE;
        }
        try {
            return (String)decryptMethod.invoke(cipherUtilClass, content);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("use Dme decrypt error", (Throwable)e);
            return DEFAULT_FAIL_VALUE;
        }
    }

    public static DmeEncryptManager getInstance() {
        return DmeEncryptManagerHolder.INSTANCE;
    }

    private DmeEncryptManager() {
    }

    static {
        DmeEncryptManager.initDmeEncryptManager();
    }

    private static class DmeEncryptManagerHolder {
        private static final DmeEncryptManager INSTANCE = new DmeEncryptManager();

        private DmeEncryptManagerHolder() {
        }
    }
}

