/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils.reflection;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.PlatformAppContext;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ReflectionUtils {
    public static boolean setMethodAccessable(Method method) {
        return AccessController.doPrivileged(new MyMethodPrivilegedAction(method));
    }

    private ReflectionUtils() {
    }

    public static Object refInvoke(Object obj, String methodName, Object ... args) {
        if (null == obj || null == methodName || null == args) {
            return null;
        }
        try {
            Method m = ReflectionUtils.getMethodFromObj(obj.getClass(), methodName, ReflectionUtils.getTypes(args));
            if (null != m) {
                return m.invoke(obj, args);
            }
            return null;
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(ReflectionUtils.class).error("refInvoke error", (Throwable)e);
            return null;
        }
    }

    public static Object getRefInvoke(Object obj, String methodName, Object ... args) throws InvocationTargetException {
        if (null == obj || null == methodName || null == args) {
            return null;
        }
        try {
            Method m = ReflectionUtils.getMethodFromObj(obj.getClass(), methodName, ReflectionUtils.getTypes(args));
            if (null != m) {
                return m.invoke(obj, args);
            }
            return null;
        }
        catch (InvocationTargetException ite) {
            ToolLoggerFactory.getLogger(ReflectionUtils.class).error("refInvoke error", (Throwable)ite);
            throw ite;
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(ReflectionUtils.class).error("refInvoke error", (Throwable)e);
            return null;
        }
    }

    public static Method getMethodFromObj(Class<?> cls, String methodName, Class<?>[] paramTypes) throws NoSuchMethodException {
        Method m = null;
        try {
            Method[] mds;
            for (Method md : mds = cls.getDeclaredMethods()) {
                if (!methodName.equals(md.getName())) continue;
                m = md;
                break;
            }
        }
        catch (SecurityException e) {
            return null;
        }
        if (null == m) {
            Class<?> superCls = cls.getSuperclass();
            if (null == superCls) {
                throw new NoSuchMethodException("can't find method name:" + methodName);
            }
            m = ReflectionUtils.getMethodFromObj(superCls, methodName, paramTypes);
        }
        return m;
    }

    private static Class<?>[] getTypes(Object ... objs) {
        Class[] cls = new Class[objs.length];
        for (int i = 0; i < cls.length; ++i) {
            cls[i] = objs[i].getClass();
        }
        return cls;
    }

    public static Object newInstance(String clazzName) {
        if (null == clazzName) {
            return null;
        }
        Class<?> cls = PlatformAppContext.getInstance().getRuntime().loadClass(clazzName);
        try {
            if (null != cls) {
                return cls.newInstance();
            }
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(ReflectionUtils.class).error("new instance error.", (Throwable)e);
        }
        return null;
    }

    public static boolean isFieldNull(Field field, Object obj) {
        if (null == obj) {
            return true;
        }
        return AccessController.doPrivileged(new MyPrivilegedAction(field, obj));
    }

    public static List<Field> getFieldOfClassAndParent(Object object) {
        if (object == null) {
            return new ArrayList<Field>();
        }
        Field[] fields = object.getClass().getDeclaredFields();
        ArrayList<Field> fieldList = new ArrayList<Field>(Arrays.asList(fields));
        Class<?> clazz = object.getClass().getSuperclass();
        if (clazz != null) {
            Field[] parFields = clazz.getDeclaredFields();
            fieldList.addAll(Arrays.asList(parFields));
        }
        return fieldList;
    }

    public static List<Field> getFieldOfClass(Class<?> clazz) {
        if (clazz == null) {
            return new ArrayList<Field>();
        }
        Field[] fields = clazz.getDeclaredFields();
        return new ArrayList<Field>(Arrays.asList(fields));
    }

    public static void syncObjectAttr(Object src, Object dest) {
        if (src == null || dest == null) {
            return;
        }
        try {
            HashMap<String, Field> fieldsSrcMap = new HashMap<String, Field>();
            HashMap<String, Field> fieldsDestMap = new HashMap<String, Field>();
            ReflectionUtils.getObjectAllFields(src, fieldsSrcMap);
            ReflectionUtils.getObjectAllFields(dest, fieldsDestMap);
            for (Map.Entry entry : fieldsDestMap.entrySet()) {
                String fieldName = (String)entry.getKey();
                Field srcField = (Field)fieldsSrcMap.get(fieldName);
                if (srcField == null) continue;
                Field destField = (Field)entry.getValue();
                if (destField.getType().equals(String.class) && srcField.getType().equals(String.class)) {
                    ReflectionUtils.setAccessable(srcField, true);
                    ReflectionUtils.setAccessable(destField, true);
                    ReflectionUtils.syncStringValue(src, dest, srcField, destField);
                    continue;
                }
                if (!destField.getType().equals(srcField.getType()) || ReflectionUtils.isNotSupportType(srcField)) continue;
                ReflectionUtils.setAccessable(srcField, true);
                ReflectionUtils.setAccessable(destField, true);
                ReflectionUtils.syncOtherValue(src, dest, srcField, destField);
            }
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(ReflectionUtils.class).error("sync attr error", (Throwable)e);
        }
    }

    private static boolean isNotSupportType(Field srcField) {
        return List.class.equals(srcField.getType()) || Map.class.equals(srcField.getType()) || Set.class.equals(srcField.getType());
    }

    public static void syncOtherValue(Object src, Object dest, Field srcField, Field destField) {
        try {
            Object valueSrc = srcField.get(src);
            if (Modifier.isFinal(srcField.getModifiers())) {
                return;
            }
            if (valueSrc != null) {
                destField.set(dest, valueSrc);
            }
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(ReflectionUtils.class).error("set field value error.", (Throwable)e);
        }
    }

    public static void syncStringValue(Object src, Object dest, Field srcField, Field destField) {
        try {
            Object valueSrc = srcField.get(src);
            Object valueDest = destField.get(dest);
            if ((valueDest == null || StringUtils.isNULLStr(valueDest.toString())) && valueSrc != null && !StringUtils.isNULLStr(valueSrc.toString())) {
                destField.set(dest, valueSrc);
            }
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(ReflectionUtils.class).error("set field value error.", (Throwable)e);
        }
    }

    public static void getObjectAllFields(Object src, Map<String, Field> fieldsMap) {
        for (Class<?> tempClass = src.getClass(); tempClass != null; tempClass = tempClass.getSuperclass()) {
            Field[] fields;
            Field[] dFields;
            for (Field field : dFields = tempClass.getFields()) {
                fieldsMap.put(field.getName(), field);
            }
            for (Field field : fields = tempClass.getDeclaredFields()) {
                fieldsMap.put(field.getName(), field);
            }
        }
    }

    public static void setAccessable(AccessibleObject ob, boolean flag) {
        if (ob != null) {
            AccessController.doPrivileged(new MySetAccessablePrivilegedAction(ob, flag));
        }
    }

    private static final class MySetAccessablePrivilegedAction
    implements PrivilegedAction<Boolean> {
        private final AccessibleObject ob;
        private final boolean flag;

        private MySetAccessablePrivilegedAction(AccessibleObject ob, boolean flag) {
            this.ob = ob;
            this.flag = flag;
        }

        @Override
        public Boolean run() {
            this.ob.setAccessible(this.flag);
            return true;
        }
    }

    private static final class MyMethodPrivilegedAction
    implements PrivilegedAction<Boolean> {
        private final Method method;

        private MyMethodPrivilegedAction(Method method) {
            this.method = method;
        }

        @Override
        public Boolean run() {
            ReflectionUtils.setAccessable(this.method, true);
            return true;
        }
    }

    private static final class MyPrivilegedAction
    implements PrivilegedAction<Boolean> {
        private final Field field;
        private final Object obj;

        private MyPrivilegedAction(Field field, Object obj) {
            this.field = field;
            this.obj = obj;
        }

        @Override
        public Boolean run() {
            ReflectionUtils.setAccessable(this.field, true);
            try {
                return null == this.field.get(this.obj);
            }
            catch (IllegalArgumentException e) {
                ToolLoggerFactory.getLogger(ReflectionUtils.class).error("new instance error.", (Throwable)e);
                return true;
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(ReflectionUtils.class).error("new instance error.", (Throwable)e);
                return true;
            }
        }
    }
}

