/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.platform;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.common.tool.AbstractTool;
import com.huawei.ism.tool.framework.platform.common.toolbox.AbstractFeature;
import com.huawei.ism.tool.framework.platform.common.toolbox.AbstractFunction;
import com.huawei.ism.tool.framework.platform.common.toolbox.AbstractSetting;
import com.huawei.ism.tool.framework.platform.common.toolbox.AbstractToolBox;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.plugin.PluginManager;
import com.huawei.ism.tool.framework.platform.pubservice.IServiceCenter;
import com.huawei.ism.tool.framework.platform.runtime.AbstractRuntime;
import com.huawei.ism.tool.framework.platform.task.IBackgroundTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PlatformAppContext {
    private static PlatformAppContext singleton = null;
    private static AbstractRuntime paramRuntime = null;
    private AbstractRuntime runtime = null;
    private IServiceCenter serviceCenter = null;
    private IServiceCenter uiCenter = null;
    private Map<String, String> authTypeConfig = new HashMap<String, String>();
    private PluginManager pluginMng = PluginManager.getInstance();
    private AbstractToolBox toolBox = null;
    private AbstractSetting setting = null;
    private List<String> tools = new ArrayList<String>();
    private List<String> features = new ArrayList<String>();
    private Map<String, List<String>> functionsMap = new HashMap<String, List<String>>();
    private Map<String, AbstractTool> toolIdMap = new HashMap<String, AbstractTool>();
    private Map<String, AbstractFeature> featureIdMap = new HashMap<String, AbstractFeature>();
    private Map<String, AbstractFunction> functionIdMap = new HashMap<String, AbstractFunction>();
    private List<IBackgroundTask> taskList = new LinkedList<IBackgroundTask>();
    private Map<String, String> functionCfgs = new HashMap<String, String>();

    public static void setParamRuntime(AbstractRuntime runtime) {
        paramRuntime = runtime;
    }

    public static PlatformAppContext getInstance() {
        if (null == singleton) {
            singleton = new PlatformAppContext(paramRuntime);
            ToolLoggerFactory.getLogger(PlatformAppContext.class).info("Platform inited successfully.");
        }
        return singleton;
    }

    public synchronized void addTool(AbstractTool tool) {
        if (null != tool) {
            this.tools.add(tool.getId());
            this.toolIdMap.put(tool.getId(), tool);
            this.pluginMng.savePlugin(tool);
        }
    }

    public synchronized List<AbstractTool> getTools() {
        ArrayList<AbstractTool> toolsList = new ArrayList<AbstractTool>(this.tools.size());
        for (String toolId : this.tools) {
            toolsList.add(this.toolIdMap.get(toolId));
        }
        return toolsList;
    }

    public synchronized void addToolBox(AbstractToolBox abToolBox) {
        if (null != abToolBox) {
            this.toolBox = abToolBox;
            this.pluginMng.savePlugin(abToolBox);
        }
    }

    public synchronized AbstractToolBox getToolBox() {
        return this.toolBox;
    }

    public synchronized void addFeature(AbstractFeature feature) {
        if (null != feature) {
            this.features.add(feature.getId());
            this.featureIdMap.put(feature.getId(), feature);
            this.pluginMng.savePlugin(feature);
        }
    }

    public synchronized List<AbstractFeature> getFeatures() {
        ArrayList<AbstractFeature> featureList = new ArrayList<AbstractFeature>(this.features.size());
        for (String featureId : this.features) {
            featureList.add(this.featureIdMap.get(featureId));
        }
        return featureList;
    }

    public synchronized AbstractFeature getFeature(String id) {
        return this.featureIdMap.get(id);
    }

    public synchronized void addFunction(AbstractFunction function) {
        if (null != function) {
            List<String> funList = this.functionsMap.get(function.getFeatureId());
            if (null == funList) {
                funList = new ArrayList<String>();
                this.functionsMap.put(function.getFeatureId(), funList);
            }
            funList.add(function.getId());
            this.functionIdMap.put(function.getId(), function);
            this.pluginMng.savePlugin(function);
        }
    }

    public synchronized List<AbstractFunction> getFunctions(String featureId) {
        ArrayList<AbstractFunction> functionList = new ArrayList<AbstractFunction>();
        List<String> funIdList = this.functionsMap.get(featureId);
        if (null != funIdList) {
            for (String funId : funIdList) {
                functionList.add(this.functionIdMap.get(funId));
            }
        }
        return functionList;
    }

    public synchronized void addBackgroundTask(IBackgroundTask task) {
        this.taskList.add(task);
    }

    public synchronized void removeBackgroundTask(IBackgroundTask task) {
        this.taskList.remove(task);
    }

    public synchronized List<IBackgroundTask> getBackgroundTasks() {
        return new ArrayList<IBackgroundTask>(this.taskList);
    }

    public void setServiceCenter(IServiceCenter serviceCenter) {
        this.serviceCenter = serviceCenter;
    }

    public IServiceCenter getServiceCenter() {
        return this.serviceCenter;
    }

    public void setUiCenter(IServiceCenter uiCenter) {
        this.uiCenter = uiCenter;
    }

    public IServiceCenter getUiCenter() {
        return this.uiCenter;
    }

    public AbstractRuntime getRuntime() {
        return this.runtime;
    }

    private PlatformAppContext(AbstractRuntime runtime) {
        this.runtime = runtime;
    }

    public Map<String, String> getAuthTypeConfig() {
        return this.authTypeConfig;
    }

    public void setPublicKeyConfig(boolean needPublicKey, String publicKeyTips) {
        this.authTypeConfig.put("needPublicKey", String.valueOf(needPublicKey));
        this.authTypeConfig.put("publicKeyTips", publicKeyTips);
    }

    public AbstractSetting getSetting() {
        return this.setting;
    }

    public void setSetting(AbstractSetting setting) {
        this.setting = setting;
    }

    public Map<String, String> getFunctionCfgs() {
        return this.functionCfgs;
    }

    public void setFunctionCfgs(Map<String, String> functionCfgs) {
        this.functionCfgs = functionCfgs;
    }

    public String getFunctionByKey(String key) {
        if (this.functionCfgs.isEmpty()) {
            return null;
        }
        String value = this.functionCfgs.get(key);
        return value;
    }

    public boolean getFunctionBooleanByKey(String key) {
        if (this.functionCfgs.isEmpty()) {
            return true;
        }
        String value = this.functionCfgs.get(key);
        if (StringUtils.isNULLStr(value)) {
            return true;
        }
        return Boolean.valueOf(value);
    }

    public void addFunctionCfgs(String key, String value) {
        this.functionCfgs.put(key, value);
    }
}

