/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.qrcodeprovide;

import com.google.zxing.common.BitMatrix;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;

public class MatrixToImageWriter {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(MatrixToImageWriter.class);
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;

    public static BufferedImage toBufferedImage(BitMatrix matrix) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, matrix.get(x, y) ? -16777216 : -1);
            }
        }
        return image;
    }

    public static void writeToFile(BitMatrix matrix, String format, File file, boolean coverage) throws IOException {
        BufferedImage image = MatrixToImageWriter.toBufferedImage(matrix);
        if (!ImageIO.write((RenderedImage)image, format, file)) {
            LOGGER.error("Could not write an image of format " + format + " to " + file);
            throw new IOException("Could not write an image of format " + format + " to " + file);
        }
    }
}

