/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.factory;

import com.huawei.ism.common.bean.User;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.connection.ConnectionManager;
import com.huawei.ism.connection.IConnection;
import com.huawei.ism.connection.TLVConnection;
import com.huawei.ism.connection.TLVConnectionImpl;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.common.IConnectionManage;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.exception.ConnectionException;
import java.util.Properties;
import org.slf4j.Logger;

public class TLVConnectionSVPImpl
implements IConnectionManage {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(TLVConnectionSVPImpl.class);
    private static final String SVP_IP = "127.0.0.1";
    private static final String SVP_PORT = "19002";
    private static final String SVP_SESSION = "123456";
    private static final String SVP = "svp";

    public TLVConnectionSVPImpl() {
        ResourceManager.init();
        ConnectionManager.getInstance().registerConnectionClass(SVP, TLVConnectionImpl.class);
    }

    public void closeTLVConnetcion(Object connObj) {
        if (null == connObj || !(connObj instanceof IConnection)) {
            return;
        }
        IConnection conn = (IConnection)connObj;
        try {
            IConnection.ConnectionState state = conn.getConnectionState();
            if (IConnection.ConnectionState.Connected.equals((Object)state)) {
                conn.close();
            }
        }
        catch (Exception e) {
            LOGGER.error("Not close connection for SVP_TLV because connection is not connected.");
        }
    }

    public Object getTLVConnWithoutSn(DevNode node) throws ConnectionException {
        return null;
    }

    public Object getTLVConnection(DevNode node) throws ConnectionException {
        TLVConnection conn = (TLVConnection)ConnectionManager.getInstance().getConnection(node.getDeviceSerialNumber());
        if (null != conn && IConnection.ConnectionState.Connected.equals((Object)conn.getConnectionState())) {
            return conn;
        }
        return this.tlvLogin(node);
    }

    public Object getTLVConnection(DevNode node, String svpIp, String svpPort, String svpSession) throws ConnectionException {
        TLVConnection conn = (TLVConnection)ConnectionManager.getInstance().getConnection(node.getDeviceSerialNumber());
        if (null != conn && IConnection.ConnectionState.Connected.equals((Object)conn.getConnectionState())) {
            LOGGER.info("sssss null != conn");
            return conn;
        }
        LOGGER.info("null == conn");
        return this.tlvLogin(node, svpIp, svpPort, svpSession);
    }

    public Object tlvLogin(DevNode node) throws ConnectionException {
        String userScop = String.valueOf(User.USER_SCOPE.LOCAL.getValue());
        String useSSL = String.valueOf(0);
        Properties properties = new Properties();
        properties.setProperty("USER_NAME", "");
        properties.setProperty("USER_WORD", "");
        properties.setProperty("USERSCOPE", userScop);
        properties.setProperty("IP_OR_NAME", SVP_IP);
        properties.setProperty("PORT", SVP_PORT);
        properties.setProperty("CONN_PROTOCOL", useSSL);
        TLVConnection conn = (TLVConnection)ConnectionManager.getInstance().buildConnection(node.getDeviceType().toString(), properties);
        conn.setSessionKey(SVP_SESSION);
        conn.setDeviceID(node.getDeviceSerialNumber());
        ConnectionManager.getInstance().setConnection(node.getDeviceSerialNumber(), (IConnection)conn);
        return conn;
    }

    public Object tlvLogin(DevNode node, String svpIp, String svpPort, String svpSession) throws ConnectionException {
        String userScop = String.valueOf(User.USER_SCOPE.LOCAL.getValue());
        String useSSL = String.valueOf(0);
        Properties properties = new Properties();
        properties.setProperty("USER_NAME", "");
        properties.setProperty("USER_WORD", "");
        properties.setProperty("USERSCOPE", userScop);
        properties.setProperty("IP_OR_NAME", svpIp);
        properties.setProperty("PORT", svpPort);
        properties.setProperty("CONN_PROTOCOL", useSSL);
        TLVConnection conn = (TLVConnection)ConnectionManager.getInstance().buildConnection(node.getDeviceType().toString(), properties);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("buildConnection succ.sn=" + node.getDeviceSerialNumber());
        }
        conn.setSessionKey(svpSession);
        conn.setDeviceID(node.getDeviceSerialNumber());
        ConnectionManager.getInstance().setConnection(node.getDeviceSerialNumber(), (IConnection)conn);
        return conn;
    }

    public String getUserIdByDeviceId(String deviceId) {
        return "";
    }
}

