/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.rest;

import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.RequestInfo;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hc.core5.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DpaRestConnection
extends RestConnection {
    private static final Logger log = LoggerFactory.getLogger(DpaRestConnection.class);
    public static final int DPA_PORT = 9088;
    private static final String HTTPS_PREFIX = "https://";
    private static final String SESSION_URI = ":9088/oauths/access_token";
    private static final String QUERY_DEV_TYPE_INFO_URI = "/oauths/initializer";
    private static final String QUERY_DPA_RELATIONSHIP_HOST = "/clusters/nodes?count=15&index=0";
    private static final List<String> NEED_RE_LOGIN_ERROR_CODE = Collections.unmodifiableList(Arrays.asList("04040183", "805962734"));

    public DpaRestConnection(DevNode devNode) {
        super(devNode);
        this.uri = HTTPS_PREFIX + devNode.getIp() + SESSION_URI;
    }

    @Override
    public String getBaseUrl() {
        return HTTPS_PREFIX + this.devNode.getIp() + ":" + String.valueOf(9088);
    }

    public String getQueryDevTypeInfoUrl() {
        return this.getBaseUrl() + QUERY_DEV_TYPE_INFO_URI;
    }

    public String getQueryDpaRelationshipHost() {
        return this.getBaseUrl() + QUERY_DPA_RELATIONSHIP_HOST;
    }

    public String getLoginUrl() {
        return HTTPS_PREFIX + this.devNode.getIp() + SESSION_URI;
    }

    @Override
    public void logOut() {
    }

    @Override
    public void closeSession() {
        super.closeSession();
        RestConnectionManager.releaseFceConnection(this.devNode);
    }

    @Override
    protected void setLoginParam(RequestInfo req) {
        req.addParam("userName", this.devNode.getLoginUser().getUserName());
        req.addParam("userPass", this.devNode.getLoginUser().getPassword());
        req.setHeader("Content-Type", "application/json");
        req.setHeader("Referer", this.getBaseUrl());
    }

    @Override
    protected void createHeader(RequestInfo req, Map headerParam) {
        req.setHeader("accessToken", this.session.getToken());
        req.setHeader("Content-Type", "application/json");
        req.setHeader("Referer", this.getBaseUrl());
    }

    @Override
    protected boolean checkLoginResult(ResponseInfo resp) throws ToolException {
        if (resp == null) {
            return false;
        }
        log.info("check dpa login result.");
        String content = resp.getContent();
        if (StringUtils.isNULLStr(content)) {
            return false;
        }
        JSONObject json = new JSONObject(content);
        String errorCode = this.getJsonValue("status", json);
        String token = "";
        for (Header head : resp.getHeaders()) {
            if (StringUtils.isNULLStr(head.getName()) || !"Set-Cookie".equals(head.getName()) || !head.getValue().contains("accessToken=")) continue;
            token = head.getValue().split("accessToken=")[1].split(";")[0];
            break;
        }
        if (!StringUtils.isNULLStr(errorCode) && !errorCode.equals("success") || StringUtils.isNULLStr(token)) {
            log.error("login dpa failed,resp={}", (Object)content);
            return false;
        }
        this.session.setToken(token);
        return true;
    }

    @Override
    public boolean isNeedReLogin(ResponseInfo resp) {
        String content = resp.getContent();
        if (!StringUtils.isNULLStr(content)) {
            JSONObject json = new JSONObject(content);
            try {
                JSONObject error = json.getJSONObject("error");
                return error != null && NEED_RE_LOGIN_ERROR_CODE.contains(error.getStringOrDefault("errId", ""));
            }
            catch (JSONException e) {
                log.error("dpa json parse error");
            }
        }
        return false;
    }
}

