/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.rest;

import com.huawei.ism.tool.obase.connection.ProxySOCKS5;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.Socks5Proxy;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.util.CommonUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.slf4j.Logger;

public class MyCustSSLSocketFactory
extends SSLConnectionSocketFactory {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(MyCustSSLSocketFactory.class);
    private Socks5Proxy socks5Proxy = null;
    private SSLContext sslContext;
    private String[] supportedProtocols = new String[0];
    private String[] supportedCipherSuites = new String[0];
    private DevNode devNode;

    public MyCustSSLSocketFactory(SSLContext sslContext) {
        super(sslContext);
    }

    public MyCustSSLSocketFactory(SSLContext sslContext, DevNode devNode) {
        super(sslContext, (HostnameVerifier)new AllAcceptVerifier());
        this.sslContext = sslContext;
        this.devNode = devNode;
        this.socks5Proxy = devNode == null ? null : devNode.getSocks5Proxy();
    }

    public Socket createSocket(HttpContext context) throws IOException {
        if (this.socks5Proxy != null) {
            ProxySOCKS5 proxySOCKS5 = new ProxySOCKS5(this.socks5Proxy.getServerIp(), Integer.valueOf(this.socks5Proxy.getPort()));
            if (this.socks5Proxy.isAuthentic()) {
                String pass = this.socks5Proxy.getPass();
                proxySOCKS5.setUserPasswd(this.socks5Proxy.getUser(), pass);
            }
            proxySOCKS5.setDest(this.devNode.getIp(), 8088);
            return proxySOCKS5.connect();
        }
        Socket sock = this.sslContext.getSocketFactory().createSocket();
        SSLSocket sslSock = (SSLSocket)CommonUtil.convertObject((Object)sock, SSLSocket.class);
        this.internalPrepareSocket(sslSock);
        return sslSock;
    }

    public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        Socket sock;
        Args.notNull((Object)host, (String)"HTTP host");
        Args.notNull((Object)remoteAddress, (String)"Remote address");
        Socket socket2 = sock = socket != null ? socket : this.createSocket(context);
        if (localAddress != null) {
            sock.bind(localAddress);
        }
        try {
            if (null != this.socks5Proxy) {
                Socket tempSock = this.sslContext.getSocketFactory().createSocket(sock, this.devNode.getIp(), 8088, false);
                sock = (Socket)CommonUtil.convertObject((Object)tempSock, SSLSocket.class);
            } else {
                sock.connect(remoteAddress, connectTimeout);
            }
        }
        catch (IOException ex) {
            try {
                sock.close();
            }
            catch (IOException ignore) {
                LOGGER.error("in connect sockect5proxy Connection error!");
            }
            throw ex;
        }
        if (sock instanceof SSLSocket) {
            SSLSocket sslsock = (SSLSocket)sock;
            sslsock.startHandshake();
            return sock;
        }
        return this.createLayeredSocket(sock, host.getHostName(), remoteAddress.getPort(), context);
    }

    public Socket connectSocket(TimeValue connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        return this.connectSocket(connectTimeout.toMillisecondsIntBound(), socket, host, remoteAddress, localAddress, context);
    }

    private void internalPrepareSocket(SSLSocket socket) throws IOException {
        if (this.supportedProtocols != null && this.supportedProtocols.length > 0) {
            socket.setEnabledProtocols(this.supportedProtocols);
        }
        if (this.supportedCipherSuites != null && this.supportedCipherSuites.length > 0) {
            socket.setEnabledCipherSuites(this.supportedCipherSuites);
        }
        this.prepareSocket(socket);
    }

    private static class AllAcceptVerifier
    implements HostnameVerifier {
        private AllAcceptVerifier() {
        }

        @Override
        public boolean verify(String arg0, SSLSession arg1) {
            return true;
        }
    }
}

