/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.rest;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.rest.A3000Connection;
import com.huawei.ism.tool.protocol.rest.ContainerRestConnection;
import com.huawei.ism.tool.protocol.rest.CyberEngineRestConnection;
import com.huawei.ism.tool.protocol.rest.DmeRestConnection;
import com.huawei.ism.tool.protocol.rest.DpaRestConnection;
import com.huawei.ism.tool.protocol.rest.FceRestConnection;
import com.huawei.ism.tool.protocol.rest.FusionCubeConnection;
import com.huawei.ism.tool.protocol.rest.MetaVisionRestConnect;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.StateLessRestCallback;
import com.huawei.ism.tool.protocol.rest.entity.RequestInfo;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.slf4j.Logger;

public class RestConnFactory {
    private static final String LOCAL = "127.0.0.1";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(RestConnFactory.class);

    public static RestConnection getRestConn(String url, DevNode devNode) throws ToolException {
        if (devNode == null) {
            return null;
        }
        return new RestConnection(url, devNode);
    }

    public static RestConnection getRestConn(DevNode devNode, boolean isDstorage) throws ToolException {
        if (devNode == null) {
            return null;
        }
        if (devNode instanceof AiDevNode) {
            return new DmeRestConnection(devNode, null, isDstorage);
        }
        return new RestConnection(devNode, isDstorage);
    }

    public static RestConnection getRestConn(DevNode devNode) throws ToolException {
        return RestConnFactory.getRestConn(devNode, null);
    }

    public static RestConnection getRestConn(DevNode devNode, HttpResponseInterceptor processor) throws ToolException {
        if (devNode == null) {
            return null;
        }
        if (devNode instanceof AiDevNode) {
            return new DmeRestConnection(devNode, processor, false);
        }
        return new RestConnection(devNode, processor, devNode.isDsStorage());
    }

    public static RestConnection getContainerRestConn(DevNode devNode) {
        if (devNode == null) {
            return null;
        }
        return new ContainerRestConnection(devNode);
    }

    public static CyberEngineRestConnection getCyberEngineRestConnection(DevNode devNode) throws ToolException {
        if (devNode == null) {
            throw new ToolException("DevNode is null.");
        }
        return new CyberEngineRestConnection(devNode);
    }

    public static FceRestConnection getFcvRestConn(DevNode devNode) throws ToolException {
        if (devNode == null) {
            throw new ToolException("DevNode is null.");
        }
        return new FceRestConnection(devNode);
    }

    public static FusionCubeConnection getFusionCubeConnection(DevNode devNode) throws ToolException {
        if (devNode == null) {
            throw new ToolException("DevNode is null.");
        }
        return new FusionCubeConnection(devNode);
    }

    public static A3000Connection getA3000Connection(DevNode devNode) throws ToolException {
        if (devNode == null) {
            throw new ToolException("DevNode is null.");
        }
        return new A3000Connection(devNode);
    }

    public static DpaRestConnection getDpaRestConn(DevNode devNode) throws ToolException {
        if (devNode == null) {
            throw new ToolException("DevNode is null.");
        }
        return new DpaRestConnection(devNode);
    }

    public static RestConnection getRestConn(DevNode key, RequestInfo loginInfo, StateLessRestCallback callback1) throws ToolException {
        if (key == null) {
            return null;
        }
        return new RestConnection(key, loginInfo, callback1);
    }

    public static MetaVisionRestConnect getMetaVisionRestConn(DevNode devNode) throws ToolException {
        if (devNode == null) {
            throw new ToolException("Meta Vision DevNode is null.");
        }
        return new MetaVisionRestConnect(devNode);
    }
}

