/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.rest;

import com.huawei.ism.tool.framework.platform.pwdSecurityResMgr.PwdSecurityUserScene;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ConnPoolUtils;
import com.huawei.ism.tool.protocol.exception.UserPrivilegeException;
import com.huawei.ism.tool.protocol.exception.UserStatusException;
import com.huawei.ism.tool.protocol.rest.A3000Connection;
import com.huawei.ism.tool.protocol.rest.CyberEngineRestConnection;
import com.huawei.ism.tool.protocol.rest.DpaRestConnection;
import com.huawei.ism.tool.protocol.rest.FceRestConnection;
import com.huawei.ism.tool.protocol.rest.FusionCubeConnection;
import com.huawei.ism.tool.protocol.rest.IRestBuildService;
import com.huawei.ism.tool.protocol.rest.MetaVisionRestConnect;
import com.huawei.ism.tool.protocol.rest.RestConnFactory;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.StateLessRestCallback;
import com.huawei.ism.tool.protocol.rest.entity.Constants;
import com.huawei.ism.tool.protocol.rest.entity.RequestInfo;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.json.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RestConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestConnectionManager.class);
    private static ConcurrentHashMap<String, RestConnection> connectionPool = new ConcurrentHashMap();
    private static final Object LOCK = new Object();
    private static List<String> needToReleasePath = new ArrayList<String>();

    private RestConnectionManager() {
        LOGGER.info("RestConnectionManager has been initialized.");
    }

    public static List<String> getNeedToReleasePath() {
        return needToReleasePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheRestConnection(DevNode devNode, RestConnection restCon) throws ToolException {
        String key = ConnPoolUtils.getKey(devNode);
        Object object = LOCK;
        synchronized (object) {
            if (restCon != null) {
                connectionPool.put(key, restCon);
            }
        }
    }

    public static RestConnection getRestConnection(DevNode devNode) throws ToolException {
        return RestConnectionManager.getRestConnection(devNode, null);
    }

    public static RestConnection getRestConnection(DevNode devNode, HttpResponseInterceptor processor) throws ToolException {
        if (devNode == null) {
            return null;
        }
        String key = ConnPoolUtils.getKey(devNode);
        if (ItDeviceType.DPA.equals((Object)devNode.getItDeviceType())) {
            DpaRestConnection restCon;
            DpaRestConnection dpaRestConnection = restCon = connectionPool.get(key) instanceof DpaRestConnection ? (DpaRestConnection)connectionPool.get(key) : null;
            if (restCon == null) {
                restCon = RestConnFactory.getDpaRestConn(devNode);
                if (!RestConnectionManager.isRightLogin(key, restCon)) {
                    return null;
                }
            } else if (!restCon.isLogin()) {
                restCon.reLogin();
            }
            return restCon;
        }
        if (ItDeviceType.OCEAN_CYBER.equals((Object)devNode.getItDeviceType())) {
            CyberEngineRestConnection restCon;
            CyberEngineRestConnection cyberEngineRestConnection = restCon = connectionPool.get(key) instanceof CyberEngineRestConnection ? (CyberEngineRestConnection)connectionPool.get(key) : null;
            if (restCon == null) {
                restCon = RestConnFactory.getCyberEngineRestConnection(devNode);
                if (!RestConnectionManager.isRightLogin(key, restCon)) {
                    return null;
                }
            } else if (!restCon.isLogin()) {
                restCon.reLogin();
            }
            return restCon;
        }
        return RestConnectionManager.getRestConnectionWithReBuild(devNode, processor);
    }

    public static RestConnection getRestConnectionWithReBuild(DevNode devNode, HttpResponseInterceptor processor) throws ToolException {
        if (devNode == null) {
            return null;
        }
        String key = ConnPoolUtils.getKey(devNode);
        ToolException[] toolExceptions = new ToolException[1];
        RestConnection restConnection = connectionPool.compute(key, (devNodeKey, oldConnection) -> RestConnectionManager.getRestConnection(devNode, processor, toolExceptions, oldConnection));
        if (Objects.nonNull(toolExceptions[0])) {
            throw toolExceptions[0];
        }
        return restConnection;
    }

    private static RestConnection getRestConnection(DevNode devNode, HttpResponseInterceptor processor, ToolException[] toolExceptions, RestConnection oldConnection) {
        if (oldConnection != null && oldConnection.isLogin()) {
            return oldConnection;
        }
        if (oldConnection != null) {
            try {
                oldConnection.close();
            }
            catch (Exception e) {
                LOGGER.info("device:[{}] close session failed", (Object)devNode.getIp(), (Object)e);
            }
            LOGGER.info("device:[{}] close session success", (Object)devNode.getIp());
        }
        try {
            RestConnection connection = RestConnFactory.getRestConn(devNode, processor);
            connection.login();
            return connection;
        }
        catch (ToolException e) {
            LOGGER.error("build rest connection fail", (Throwable)e);
            if (e.getErrorId().equals("No trusted certificate found")) {
                toolExceptions[0] = e;
            }
            return null;
        }
    }

    public static RestConnection getRestConnectionWithBuildService(@NotNull DevNode devNode, @NotNull IRestBuildService service) {
        String key = ConnPoolUtils.getKey(devNode);
        return connectionPool.compute(key, (devNodeKey, oldConnection) -> {
            if (oldConnection != null && oldConnection.isLogin()) {
                return oldConnection;
            }
            if (oldConnection != null) {
                try {
                    oldConnection.close();
                }
                catch (Exception e) {
                    LOGGER.info("device:[{}] close session failed", (Object)devNode.getIp(), (Object)e);
                }
                LOGGER.info("device:[{}] close session success", (Object)devNode.getIp());
            }
            try {
                RestConnection connection = service.buildConnection(devNode);
                connection.login();
                return connection;
            }
            catch (ToolException e) {
                LOGGER.error("build rest connection fail", (Throwable)e);
                return null;
            }
        });
    }

    private static boolean isRightLogin(String key, RestConnection restCon) throws ToolException {
        restCon.login();
        if (restCon.isLogin()) {
            connectionPool.putIfAbsent(key, restCon);
            return true;
        }
        return false;
    }

    public static RestConnection getContainerRestConnection(DevNode devNode) throws ToolException {
        if (devNode == null) {
            return null;
        }
        String key = ConnPoolUtils.getKey(devNode, "_container");
        RestConnection restCon = connectionPool.get(key);
        if (restCon == null) {
            restCon = RestConnFactory.getContainerRestConn(devNode);
            if (!RestConnectionManager.isRightLogin(key, restCon)) {
                return null;
            }
        } else if (!restCon.isLogin()) {
            restCon.reLogin();
        }
        return restCon;
    }

    public static FceRestConnection getFceRestConnection(DevNode devNode) throws ToolException {
        FceRestConnection restCon;
        if (devNode == null) {
            return null;
        }
        String key = ConnPoolUtils.getKey(devNode, "_fcv");
        FceRestConnection fceRestConnection = restCon = connectionPool.get(key) instanceof FceRestConnection ? (FceRestConnection)connectionPool.get(key) : null;
        if (restCon == null) {
            restCon = RestConnFactory.getFcvRestConn(devNode);
            if (!RestConnectionManager.isRightLogin(key, restCon)) {
                return null;
            }
        } else if (!restCon.isLogin()) {
            restCon.reLogin();
        }
        return restCon;
    }

    public static FusionCubeConnection getFusionCubeRestConnection(DevNode devNode) throws ToolException {
        FusionCubeConnection restCon;
        if (devNode == null) {
            return null;
        }
        String key = ConnPoolUtils.getKey(devNode, "_fusion_cube");
        FusionCubeConnection fusionCubeConnection = restCon = connectionPool.get(key) instanceof FusionCubeConnection ? (FusionCubeConnection)connectionPool.get(key) : null;
        if (restCon == null) {
            restCon = RestConnFactory.getFusionCubeConnection(devNode);
            if (!RestConnectionManager.isRightLogin(key, restCon)) {
                return null;
            }
        } else if (!restCon.isLogin()) {
            restCon.reLogin();
        }
        return restCon;
    }

    public static A3000Connection getA3000RestConnection(DevNode devNode) throws ToolException {
        A3000Connection restCon;
        if (devNode == null) {
            return null;
        }
        String key = ConnPoolUtils.getKey(devNode, "_a3000");
        A3000Connection a3000Connection = restCon = connectionPool.get(key) instanceof A3000Connection ? (A3000Connection)connectionPool.get(key) : null;
        if (restCon == null) {
            restCon = RestConnFactory.getA3000Connection(devNode);
            if (!RestConnectionManager.isRightLogin(key, restCon)) {
                return null;
            }
        } else if (!restCon.isLogin()) {
            restCon.reLogin();
        }
        return restCon;
    }

    public static void releaseDpaConnection(DevNode devNode) {
        if (devNode == null) {
            return;
        }
        String key = ConnPoolUtils.getKey(devNode, "_dpa");
        RestConnection con = connectionPool.get(key);
        if (con == null) {
            return;
        }
        con.logOut();
        connectionPool.remove(key);
    }

    public static void releaseFusionCubeConnection(DevNode devNode) {
        if (devNode == null) {
            return;
        }
        String key = ConnPoolUtils.getKey(devNode, "_fusion_cube");
        RestConnection con = connectionPool.get(key);
        if (con == null) {
            return;
        }
        con.logOut();
        connectionPool.remove(key);
    }

    public static void releaseA3000Connection(DevNode devNode) {
        if (devNode == null) {
            return;
        }
        String key = ConnPoolUtils.getKey(devNode, "_a3000");
        RestConnection con = connectionPool.get(key);
        if (con == null) {
            return;
        }
        con.logOut();
        connectionPool.remove(key);
    }

    public static void releaseFceConnection(DevNode devNode) {
        if (devNode == null) {
            return;
        }
        String key = ConnPoolUtils.getKey(devNode, "_fcv");
        RestConnection con = connectionPool.get(key);
        if (con == null) {
            return;
        }
        con.logOut();
        connectionPool.remove(key);
    }

    public static void releaseContainerRestConnection(DevNode devNode) {
        if (devNode == null) {
            return;
        }
        String key = ConnPoolUtils.getKey(devNode, "_container");
        RestConnection con = connectionPool.get(key);
        if (null == con) {
            return;
        }
        con.logOut();
        connectionPool.remove(key);
    }

    public static RestConnection getDstorageLoginRestConnection(DevNode devNode) throws ToolException {
        ResponseInfo responseInfo;
        RestConnection restCon = RestConnFactory.getRestConn(devNode, true);
        if (null != restCon && !restCon.isLogin()) {
            responseInfo = restCon.login();
            if (!restCon.isLogin()) {
                throw new ToolException("Rest conn login failed.");
            }
        } else {
            throw new ToolException("Rest conn is null.");
        }
        devNode.setItDeviceType(ItDeviceType.DStorage);
        String key = ConnPoolUtils.getKey(devNode);
        LOGGER.info("Got rest connection success.");
        connectionPool.putIfAbsent(key, restCon);
        RestConnectionManager.checkPasswordStatus(responseInfo, devNode.getIp());
        RestConnectionManager.checkUserPrivilege(restCon, devNode.getIp());
        return restCon;
    }

    private static void checkPasswordStatus(ResponseInfo responseInfo, String devNodeIp) {
        String content = responseInfo.getContent();
        JSONObject json = new JSONObject(content);
        JSONObject jsonData = json.getJSONObject("data");
        if (jsonData.has("password_status")) {
            int passwordStatus = (Integer)jsonData.get("password_status");
            if (passwordStatus == Constants.UserStateE.PWD_EXPIRING.getValue()) {
                LOGGER.error("device:{}: The login password will soon expire.", (Object)devNodeIp);
                throw new UserStatusException("conn.userdatus.pwd.expiring", PwdSecurityUserScene.DeviceMgr);
            }
            if (passwordStatus == Constants.UserStateE.PWD_INITIAL.getValue()) {
                LOGGER.error("device:{}: The login password not initial.", (Object)devNodeIp);
                throw new UserStatusException("conn.userdatus.pwd.initial", PwdSecurityUserScene.DeviceMgr);
            }
            if (passwordStatus == Constants.UserStateE.PWD_EXPIRED.getValue()) {
                LOGGER.error("device:{}: The login password is expired.", (Object)devNodeIp);
                throw new UserStatusException("conn.userdatus.pwd.expired", PwdSecurityUserScene.DeviceMgr);
            }
        }
    }

    private static void checkUserPrivilege(RestConnection conn, String devNodeIp) {
        int userRoleId = conn.getRoleId();
        if (userRoleId != Constants.UserRole.SUPER_ADMIN.getValue()) {
            LOGGER.error("device:{}: The user is not super admin.", (Object)devNodeIp);
            throw new UserPrivilegeException("conn.user.is.not.supper.admin");
        }
    }

    public static RestConnection getRestConnectionThrowLoginError(DevNode devNode) throws ToolException {
        String key = ConnPoolUtils.getKey(devNode);
        RestConnection restCon = connectionPool.get(key);
        if (restCon == null) {
            restCon = RestConnFactory.getRestConn(devNode);
            restCon.loginThrowErrorCode();
            if (restCon.isLogin()) {
                connectionPool.putIfAbsent(key, restCon);
            } else {
                return null;
            }
        }
        if (!restCon.isLogin()) {
            restCon.loginThrowErrorCode();
        }
        return restCon;
    }

    public static RestConnection getRestConnectionBySession(DevNode devNode, String sessionID, String token, int level, List<Map<String, String>> cookieInfoList) throws ToolException {
        String key = ConnPoolUtils.getKey(devNode);
        RestConnection restCon = connectionPool.get(key);
        if (restCon == null) {
            restCon = RestConnFactory.getRestConn(devNode);
            restCon.longTermConnectionInit(sessionID, token, level, cookieInfoList);
            connectionPool.putIfAbsent(key, restCon);
        } else if (!restCon.isLogin()) {
            restCon.loginThrowErrorCode();
        }
        return restCon;
    }

    public static RestConnection getRestConnectionNoException(DevNode devNode) {
        try {
            return RestConnectionManager.getRestConnection(devNode);
        }
        catch (ToolException te) {
            LOGGER.error("Get rest connection failed:", (Throwable)te);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseConn(DevNode devNode) {
        if (devNode == null) {
            return;
        }
        String key = ConnPoolUtils.getKey(devNode);
        RestConnection con = connectionPool.get(key);
        if (null == con) {
            return;
        }
        try {
            con.execDelete(RestUtil.getloginUri(devNode));
        }
        catch (ToolException e) {
            LOGGER.warn("Logout device by rest exception:" + e);
        }
        finally {
            connectionPool.remove(key);
        }
    }

    public static RestConnection getRestConnection(DevNode devNode, RequestInfo loginInfo, StateLessRestCallback callback1) throws ToolException {
        if (null == devNode || null == devNode.getLoginUser() || null == devNode.getItDeviceType()) {
            throw new ToolException("unpacking devnode with error!", false);
        }
        String key = ConnPoolUtils.getKey(devNode);
        RestConnection restCon = connectionPool.get(key);
        if (restCon == null) {
            restCon = RestConnFactory.getRestConn(devNode, loginInfo, callback1);
            connectionPool.putIfAbsent(key, restCon);
        }
        return restCon;
    }

    public static RestConnection getRestConnectionWithoutCheck(DevNode devNode) {
        return connectionPool.get(ConnPoolUtils.getKey(devNode));
    }

    public static Optional<MetaVisionRestConnect> getMetaVisionConnection(DevNode devNode) throws ToolException {
        MetaVisionRestConnect restCon;
        if (devNode == null) {
            return Optional.empty();
        }
        String key = "MetaVision" + devNode.getIp();
        MetaVisionRestConnect metaVisionRestConnect = restCon = connectionPool.get(key) instanceof MetaVisionRestConnect ? (MetaVisionRestConnect)connectionPool.get(key) : null;
        if (restCon == null) {
            restCon = RestConnFactory.getMetaVisionRestConn(devNode);
            if (!RestConnectionManager.isRightLogin(key, restCon)) {
                return Optional.empty();
            }
        } else if (!restCon.isLogin()) {
            restCon.reLogin();
        }
        return Optional.of(restCon);
    }

    public static void releaseMetaVisionConnection(DevNode devNode) {
        if (devNode == null) {
            return;
        }
        RestConnection restConnection = connectionPool.get("MetaVision" + devNode.getIp());
        if (restConnection instanceof MetaVisionRestConnect) {
            restConnection.logOut();
        }
    }

    public static boolean isPoolExistConnection(String key) {
        return connectionPool.containsKey(key);
    }

    public static void releaseFusionComputeConnection(DevNode devNode) {
        if (Objects.isNull(devNode)) {
            return;
        }
        try {
            String key = ConnPoolUtils.getKey(devNode);
            RestConnection con = connectionPool.get(key);
            if (null == con) {
                return;
            }
            con.closeSession();
        }
        finally {
            connectionPool.remove(ConnPoolUtils.getKey(devNode));
        }
    }

    public static RestConnection getRestConnectionWithCheck(DevNode devNode) throws ToolException {
        RestConnection restConnection = RestConnectionManager.getRestConnection(devNode);
        if (restConnection == null || !restConnection.isLogin()) {
            throw new ToolException("conn.fail.msg");
        }
        return restConnection;
    }
}

