/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.tlv.impl;

import com.huawei.ism.tlv.TLVMOMsg;
import com.huawei.ism.tlv.TLVUtils;
import com.huawei.ism.tlv.bean.Param;
import com.huawei.ism.tlv.bean.Record;
import com.huawei.ism.tlv.lang.IsmInteger;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.protocol.tlv.ITLVConnection;
import com.huawei.ism.tool.protocol.tlv.TLVConnectionImpl;
import com.huawei.ism.tool.protocol.tlv.TlvConnectionManager;
import com.huawei.ism.tool.protocol.tlv.exception.TLVException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public abstract class AbstractConnection
implements ITLVConnection {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(AbstractConnection.class);
    private TLVConnectionImpl omConn = null;
    private int retryTimes = 0;
    private int retryInterval = 5000;

    public int getRetryTimes() {
        return this.retryTimes == 0 ? TlvConnectionManager.getCmdRetryTimes() : this.retryTimes;
    }

    public int getRetryInterval() {
        int globalInterval = TlvConnectionManager.getGlobalRetryInterval();
        return globalInterval != 0 ? globalInterval : this.retryInterval;
    }

    public void setRetryInterval(int cmdRetryInterval) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Thread name :" + Thread.currentThread().getName() + " id : " + Thread.currentThread().getId() + "set retryInterval times to:" + cmdRetryInterval);
        }
        this.retryInterval = cmdRetryInterval;
    }

    public void setRetryTimes(int cmdRetryTimes) {
        Thread curThread = Thread.currentThread();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Thread name :" + curThread.getName() + " id : " + curThread.getId() + "set retryTimes times to:" + cmdRetryTimes + " URL :" + this.omConn);
        }
        this.retryTimes = cmdRetryTimes;
    }

    public void resetCmdRetryTimes() {
        this.retryTimes = 0;
    }

    public boolean isNeedRetry() {
        return this.retryTimes > 0 || TlvConnectionManager.getCmdRetryTimes() > 0;
    }

    @Override
    public Record invoke(long cmdWord, List<Param> tlvParams, int timeout) throws TLVException {
        int currSetTimes = this.getRetryTimes();
        if (!this.isNeedRetry(currSetTimes)) {
            return this.omConn.invoke(cmdWord, tlvParams, timeout);
        }
        return this.invoke(cmdWord, tlvParams, timeout, currSetTimes);
    }

    private boolean isNeedRetry(int currSet) {
        return currSet > 0;
    }

    @Override
    public Record invoke(long cmdWord, List<Param> tlvParams, int timeout, int currSetTimes) throws TLVException {
        TLVException re = new TLVException("tlv exec cmd error");
        int curtimes = 0;
        int sleepTime = this.getRetryInterval();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("exec retry on fail method invoke retry times:" + currSetTimes + " inerval :" + sleepTime);
        }
        int iterCurrSetTimes = currSetTimes;
        while (iterCurrSetTimes >= 0) {
            try {
                --iterCurrSetTimes;
                return this.omConn.invoke(cmdWord, tlvParams, timeout);
            }
            catch (TLVException e) {
                LOGGER.error("exec cmd error and retry the " + ++curtimes + "th times", (Throwable)e);
                re = e;
                if (this.needRetry(e)) {
                    this.sleepSomeTime(sleepTime);
                    this.reBuildConn();
                    continue;
                }
                throw e;
            }
            catch (NullPointerException e) {
                LOGGER.error("exec cmd error and retry the " + ++curtimes + "th times", (Throwable)e);
                this.sleepSomeTime(sleepTime);
                this.reBuildConn();
            }
        }
        throw re;
    }

    private void sleepSomeTime(int sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            LOGGER.error("error!", (Throwable)e);
        }
    }

    private void reBuildConn() {
        try {
            this.close();
            this.connect();
        }
        catch (RuntimeException e) {
            LOGGER.error("rebuild conn exception", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("rebuild conn exception", (Throwable)e);
        }
    }

    private boolean needRetry(TLVException tlvException) {
        if (tlvException == null || tlvException.getCause() == null) {
            return true;
        }
        return NullPointerException.class.isAssignableFrom(tlvException.getCause().getClass()) || IOException.class.isAssignableFrom(tlvException.getCause().getClass());
    }

    @Override
    public List<Record> getBatch(long cmdWord, List<Param> tlvParams, int timeout) throws TLVException {
        int currSetTimes = this.getRetryTimes();
        if (!this.isNeedRetry(currSetTimes)) {
            return this.omConn.getBatch(cmdWord, tlvParams, timeout);
        }
        return this.getBatch(cmdWord, tlvParams, timeout, currSetTimes);
    }

    @Override
    public List<Record> getNext(long cmdWord, Param param, int timeout) throws TLVException {
        int currSetTimes = this.getRetryTimes();
        if (!this.isNeedRetry(currSetTimes)) {
            return this.omConn.getNext(cmdWord, param, timeout);
        }
        return this.getNext(cmdWord, param, timeout, currSetTimes);
    }

    public List<Record> getNext(long cmdWord, Param param, int timeout, int currSetTimes) throws TLVException {
        TLVException re = new TLVException("tlv exec cmd error");
        int curtimes = 0;
        int sleepTime = this.getRetryInterval();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("exec retry on fail method getNext retry times:" + currSetTimes);
        }
        int iterCurrSetTimes = currSetTimes;
        while (iterCurrSetTimes >= 0) {
            try {
                --iterCurrSetTimes;
                return this.omConn.getNext(cmdWord, param, timeout);
            }
            catch (TLVException te) {
                LOGGER.error("exec cmd error and retry the " + ++curtimes + "th times", (Throwable)te);
                re = te;
                if (this.needRetry(te)) {
                    this.sleepSomeTime(sleepTime);
                    this.reBuildConn();
                    continue;
                }
                throw te;
            }
            catch (NullPointerException e) {
                LOGGER.error("exec cmd error and retry the " + ++curtimes + "th times", (Throwable)e);
                this.sleepSomeTime(sleepTime);
                this.reBuildConn();
            }
        }
        throw re;
    }

    public String toString() {
        String url = null != this.omConn ? this.omConn.getURL() : "";
        return "tlv connection to:" + url;
    }

    public TLVConnectionImpl getOmConn() {
        return this.omConn;
    }

    public void setOmConn(TLVConnectionImpl omConn) {
        this.omConn = omConn;
    }

    @Override
    public List<Record> getBatch(long cmdWord, List<Param> tlvParams, int timeout, int retryTime) throws TLVException {
        TLVException re = new TLVException("tlv exec cmd error");
        int curtimes = 0;
        int sleepTime = this.getRetryInterval();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("exec retry on fail method getBatch retry times:" + retryTime);
        }
        int iterRetryTime = retryTime;
        while (iterRetryTime >= 0) {
            try {
                --iterRetryTime;
                return this.omConn.getBatch(cmdWord, tlvParams, timeout, (short)-3);
            }
            catch (TLVException e) {
                LOGGER.error("exec cmd with TLVException and retry the " + ++curtimes + "th times", (Throwable)e);
                re = e;
                if (this.needRetry(e)) {
                    this.sleepSomeTime(sleepTime);
                    this.reBuildConn();
                    continue;
                }
                throw e;
            }
            catch (NullPointerException e) {
                LOGGER.error("exec cmd error and retry the " + ++curtimes + "th times", (Throwable)e);
                this.sleepSomeTime(sleepTime);
                this.reBuildConn();
            }
        }
        throw re;
    }

    public List<Record> bacthNext(long cmd, List<Param> tlvParams, int timeout, int retryTime) throws TLVException {
        ArrayList<Record> dataList = new ArrayList<Record>();
        List<Record> data = this.getBatch(cmd, tlvParams, timeout, retryTime);
        while (!data.isEmpty()) {
            for (int i = 0; i < data.size() - 1; ++i) {
                dataList.add(data.get(i));
            }
            Record lastRecord = data.get(data.size() - 1);
            if (TLVUtils.containTag((Record)lastRecord, (int)4095)) {
                long errorCode = ((IsmInteger)lastRecord.getParamValue(4095)).longValue();
                if (errorCode == 1L) break;
                throw new TLVException(errorCode);
            }
            dataList.add(lastRecord);
            Param moidParam = new Param(TLVMOMsg.ID.getParamIndex(), lastRecord.getParamStrValue(TLVMOMsg.ID.getParamIndex()));
            data = this.getBatch(cmd, TLVUtils.addParam(tlvParams, (Param[])new Param[]{moidParam}), timeout, retryTime);
        }
        return dataList;
    }

    public List<Record> bacthNext(long cmd, List<Param> tlvParams, int timeout) throws TLVException {
        return this.bacthNext(cmd, tlvParams, timeout, 1);
    }

    public List<Record> getBatchWithRetry(long cmdWord, List<Param> tlvParams, int timeout, int retryTimes, int interval) throws TLVException {
        List<Record> retRecord = null;
        LOGGER.info("exec retry on fail method getBatchWithRetry retry times:{} interval:{}", (Object)retryTimes, (Object)interval);
        int iterRetryTimes = retryTimes;
        while (iterRetryTimes >= 0) {
            try {
                --iterRetryTimes;
                retRecord = this.omConn.getBatch(cmdWord, tlvParams, timeout);
                return retRecord;
            }
            catch (Exception e) {
                LOGGER.error("exec cmd error and retry the " + iterRetryTimes + "th times", (Throwable)e);
                this.sleepSomeTime(interval);
                this.reBuildConn();
                if (iterRetryTimes != 0) continue;
                throw e;
            }
        }
        return retRecord;
    }
}

