/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.utils;

import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.NetUtil;
import com.huawei.ism.tool.protocol.rest.RestConnFactory;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestUtil {
    private static final Logger log = LoggerFactory.getLogger(RestUtil.class);
    private static final String SESSIONS = "xxxx/sessions";
    private static final String DS_STORAGE_SESSIONS = "/aa/sessions";
    private static final String DEVICE_MANAGER_REST = "/deviceManager/rest/";
    private static final String DS_STORAGE_COMMON = "/api/v2/common";
    private static final String DS_CLUSTER_URI = "/api/v2/cluster";
    private static final String DS_PRODUCT_URI = "/product";
    private static final String DS_SYSTEM_URI = "/system";
    private static final String DS_NODES_URI = "/servers";
    public static final String DS_STORAGE_BASE_RUI = "/api/v2";
    private static final String DS_STORAGE_INSPECTION_URI = "/cluster/inspection";
    public static final String DS_STORAGE_UPDATA_INSPECTION_PATCH = "/cluster/inspection/patch";
    private static final String DS_STORAGE_UPGRADE_NODE_VERSION = "/upgrade/compute_component";
    public static final String DS_STORAGE_UPDATE_COLLECTION_PATCH = "/cluster/collection/patch";
    private static final String DS_STORAGE_INFO_COLLECT_URI = "/cluster/collection";
    private static final String DS_STORAGE_INFO_COLLECT_TASKS = "/cluster/tasks";
    private static final String DS_STORAGE_INFO_SUB_COLLECT_TASK = "/cluster/sub_tasks";
    private static final String DS_STORAGE_INFO_SUB_TASK_FILES = "/cluster/sub_task_files";
    private static final String DS_STORAGE_GET_RESOURCE_URI = "/cluster/resource_files";
    private static final String DS_PERFORMANCE_COLLECT = "/pms/performance_file";
    private static final String DS_QUERY_BMC_INFO = "/api/v2/cluster/servers/bmc_info";
    private static final String DS_QUERY_DIRECT_PLANES = "/api/v2/hwm/direct_planes";
    private static final String SYSTEM_UTC_TIME = "/deviceManager/rest/%s/system_utc_time";
    private static final String QUERY_FUSION_STORAGE_MANAGER_INFO = "/dsware/service/pmi/queryFusionStorageManagerInfo";
    private static final String QUERY_FSM_NODE_INFO = "/dsware/service/upgrade/getFsmNodeInfo";
    private static final String QUERY_CONTROL_CLUSTER = "/dsware/service/cluster/queryManageCluster";
    private static final String QUERY_NODE_DISKS = "/dsware/service/resource/queryDiskInfo";
    private static final String SCAN_SYSTEM_INFO = "/dsware/service/vsan/scanServerSystemMedia";
    private static final String PORT_CONNECTOR = ":";
    private static final String HTTPS_PREFIX = "https://";
    public static final int REST_CONN_PORT = 8088;
    private static final int HTTP_CONNECT_TIMEOUT = 30;
    private static final int HTTP_CONNECTION_REQUEST_TIMEOUT = 30;

    public static String getDsUpgradeNodeVersionUri(DevNode devNode, String port) {
        return HTTPS_PREFIX + (devNode.getItDeviceType().equals((Object)ItDeviceType.DStorage) ? RestUtil.processIPByURL(devNode.getIp()) : devNode.getIp()) + PORT_CONNECTOR + port + DS_STORAGE_BASE_RUI + DS_STORAGE_UPGRADE_NODE_VERSION;
    }

    public static String getloginUri(DevNode devNode) {
        boolean isDStorage = devNode.isDsStorage();
        if (devNode instanceof AiDevNode) {
            return HTTPS_PREFIX + RestUtil.processIPByURL(devNode.getIp()) + PORT_CONNECTOR + devNode.getPort() + "/rest/plat/smapp/v1/sessions";
        }
        return HTTPS_PREFIX + RestUtil.processIPByURL(devNode.getIp()) + PORT_CONNECTOR + 8088 + (isDStorage ? DS_STORAGE_BASE_RUI : DEVICE_MANAGER_REST) + (isDStorage ? DS_STORAGE_SESSIONS : SESSIONS);
    }

    public static String getBaseUri(DevNode devNode) {
        if (devNode instanceof AiDevNode) {
            return HTTPS_PREFIX + RestUtil.processIPByURL(devNode.getIp()) + PORT_CONNECTOR + devNode.getPort();
        }
        String commonUri = devNode.getItDeviceType().equals((Object)ItDeviceType.DStorage) ? DS_STORAGE_BASE_RUI : DEVICE_MANAGER_REST + devNode.getDeviceSerialNumber();
        return HTTPS_PREFIX + RestUtil.processIPByURL(devNode.getIp()) + PORT_CONNECTOR + 8088 + commonUri;
    }

    public static String getDstorageloginUri(DevNode devNode) {
        return HTTPS_PREFIX + RestUtil.processIPByURL(devNode.getIp()) + PORT_CONNECTOR + (ItDeviceType.A800_OM.equals((Object)devNode.getItDeviceType()) ? devNode.getPort() : 8088) + DS_STORAGE_BASE_RUI + DS_STORAGE_SESSIONS;
    }

    public static String getClusterProductInfoUri(DevNode devNode) {
        return HTTPS_PREFIX + RestUtil.processIPByURL(devNode.getIp()) + PORT_CONNECTOR + 8088 + DS_CLUSTER_URI + DS_PRODUCT_URI;
    }

    public static String getClusterSystemInfoUri(DevNode devNode) {
        return HTTPS_PREFIX + RestUtil.processIPByURL(devNode.getIp()) + PORT_CONNECTOR + 8088 + DS_STORAGE_COMMON + DS_SYSTEM_URI;
    }

    public static String getDeviceSystemInfoUri(DevNode devNode) {
        return HTTPS_PREFIX + RestUtil.processIPByURL(devNode.getIp()) + PORT_CONNECTOR + 8088 + DEVICE_MANAGER_REST + devNode.getDeviceSerialNumber() + "/system/";
    }

    public static String getClusterNodesUri(DevNode devNode) {
        return HTTPS_PREFIX + RestUtil.processIPByURL(devNode.getIp()) + PORT_CONNECTOR + 8088 + DS_CLUSTER_URI + DS_NODES_URI;
    }

    public static String getHttpsPrefixWithAddress(DevNode devNode) {
        return HTTPS_PREFIX + RestUtil.processIPByURL(devNode.getIp()) + PORT_CONNECTOR + 8088;
    }

    public static String getHttpsPrefixWithNode(DevNode devNode) {
        return HTTPS_PREFIX + RestUtil.processIPByURL(devNode.getIp()) + PORT_CONNECTOR;
    }

    public static String getFusionStorManagerInfoUri(DevNode devNode) {
        return RestUtil.getHttpsPrefixWithAddress(devNode) + QUERY_FUSION_STORAGE_MANAGER_INFO;
    }

    public static String getFsmNodeInfoUri(DevNode devNode) {
        return RestUtil.getHttpsPrefixWithAddress(devNode) + QUERY_FSM_NODE_INFO;
    }

    public static String getControlClusterUri(DevNode devNode) {
        return RestUtil.getHttpsPrefixWithAddress(devNode) + QUERY_CONTROL_CLUSTER;
    }

    public static String getNodeDiskInfoUri(DevNode devNode) {
        return RestUtil.getHttpsPrefixWithAddress(devNode) + QUERY_NODE_DISKS;
    }

    public static String querySysDiskInfoUri(DevNode devNode) {
        return RestUtil.getHttpsPrefixWithAddress(devNode) + SCAN_SYSTEM_INFO;
    }

    public static String getResourceUri(DevNode devNode) {
        return HTTPS_PREFIX + RestUtil.processIPByURL(devNode.getIp()) + PORT_CONNECTOR + 8088 + DS_STORAGE_BASE_RUI + DS_STORAGE_GET_RESOURCE_URI;
    }

    public static String getInspectionUri(DevNode devNode) {
        return HTTPS_PREFIX + RestUtil.processIPByURL(devNode.getIp()) + PORT_CONNECTOR + 8088 + DS_STORAGE_BASE_RUI + DS_STORAGE_INSPECTION_URI;
    }

    public static String getInfoCollectUri(DevNode devNode) {
        return HTTPS_PREFIX + RestUtil.processIPByURL(devNode.getIp()) + PORT_CONNECTOR + 8088 + DS_STORAGE_BASE_RUI + DS_STORAGE_INFO_COLLECT_URI;
    }

    public static String getDstorageUrlHead(DevNode devNode) {
        return HTTPS_PREFIX + RestUtil.processIPByURL(devNode.getIp()) + PORT_CONNECTOR + 8088;
    }

    public static String getPerformanceCollectUri(DevNode devNode) {
        return HTTPS_PREFIX + RestUtil.processIPByURL(devNode.getIp()) + PORT_CONNECTOR + 8088 + DS_STORAGE_BASE_RUI + DS_PERFORMANCE_COLLECT;
    }

    public static String getInfoCollectModuleTaskUri(DevNode devNode, String taskId) {
        return HTTPS_PREFIX + RestUtil.processIPByURL(devNode.getIp()) + PORT_CONNECTOR + 8088 + DS_STORAGE_BASE_RUI + DS_STORAGE_INFO_COLLECT_TASKS + "/" + taskId;
    }

    public static String getInfoCollectSubTaskUri(DevNode devNode) {
        return HTTPS_PREFIX + RestUtil.processIPByURL(devNode.getIp()) + PORT_CONNECTOR + 8088 + DS_STORAGE_BASE_RUI + DS_STORAGE_INFO_SUB_COLLECT_TASK;
    }

    public static String getSubTaskResultFileUri(DevNode devNode) {
        return HTTPS_PREFIX + RestUtil.processIPByURL(devNode.getIp()) + PORT_CONNECTOR + 8088 + DS_STORAGE_BASE_RUI + DS_STORAGE_INFO_SUB_TASK_FILES;
    }

    public static String getInspectionTaskUri(DevNode devNode, String taskId) {
        return HTTPS_PREFIX + RestUtil.processIPByURL(devNode.getIp()) + PORT_CONNECTOR + 8088 + DS_STORAGE_BASE_RUI + DS_STORAGE_INSPECTION_URI + "/" + taskId;
    }

    public static String getInspectionUpdatePatchUri(DevNode devNode) {
        return HTTPS_PREFIX + RestUtil.processIPByURL(devNode.getIp()) + PORT_CONNECTOR + 8088 + DS_STORAGE_BASE_RUI + DS_STORAGE_UPDATA_INSPECTION_PATCH;
    }

    public static String getDstorageBaseUrl(DevNode devNode) {
        return HTTPS_PREFIX + RestUtil.processIPByURL(devNode.getIp()) + PORT_CONNECTOR + 8088 + DS_STORAGE_BASE_RUI;
    }

    public static String getloginUri(DevNode devNode, String devIp, int port) {
        return HTTPS_PREFIX + RestUtil.processIPByURL(devIp) + PORT_CONNECTOR + port + DEVICE_MANAGER_REST + SESSIONS;
    }

    public static String getSystemUtcTimeUrl(DevNode devNode) {
        return RestUtil.getDstorageBaseUrlNoV2(devNode) + String.format(Locale.ENGLISH, SYSTEM_UTC_TIME, devNode.getDeviceSerialNumber());
    }

    public static String getDstorageBaseUrlNoV2(DevNode devNode) {
        return HTTPS_PREFIX + RestUtil.processIPByURL(devNode.getIp()) + PORT_CONNECTOR + 8088;
    }

    public static String getDsQueryBmcInfo(DevNode devNode) {
        return RestUtil.getDstorageUrlHead(devNode) + DS_QUERY_BMC_INFO;
    }

    public static String getDirectPlanes(DevNode devNode) {
        return RestUtil.getDstorageUrlHead(devNode) + DS_QUERY_DIRECT_PLANES;
    }

    public static String processIPByURL(String ip) {
        if (NetUtil.isValidIPV6(ip)) {
            String ipNew = "[" + ip + "]";
            return ipNew;
        }
        return ip;
    }

    public static RequestConfig buildRequestConfig() {
        return RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofSeconds((long)30L)).setConnectTimeout(Timeout.ofSeconds((long)30L)).setResponseTimeout(Timeout.ofSeconds((long)300L)).build();
    }

    public static RequestConfig buildRequestConfig(int responseTimeout) {
        return RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofSeconds((long)30L)).setConnectTimeout(Timeout.ofSeconds((long)30L)).setResponseTimeout(Timeout.ofSeconds((long)responseTimeout)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSslFingerprint(DevNode node) {
        String[] fingerprintResult = new String[1];
        RestConnection restConnection = null;
        try {
            restConnection = RestConnFactory.getRestConn(node, (response, entity, context) -> RestUtil.formatFingerprint(context, fingerprintResult));
            restConnection.login();
            String string = fingerprintResult[0];
            return string;
        }
        catch (ToolException e) {
            log.error("get ssl fingerprint failed", (Throwable)e);
            String string = "";
            return string;
        }
        finally {
            if (restConnection != null) {
                restConnection.closeSession();
            }
        }
    }

    private static void formatFingerprint(HttpContext context, String[] fingerprintResult) throws SSLPeerUnverifiedException {
        byte[] fingerprint;
        Object sessionObj = context.getAttribute("http.ssl-session");
        if (!(sessionObj instanceof SSLSession)) {
            return;
        }
        Certificate[] certificates = ((SSLSession)sessionObj).getPeerCertificates();
        if (certificates.length == 0) {
            return;
        }
        Certificate certificate = certificates[0];
        if (!(certificate instanceof X509Certificate)) {
            return;
        }
        X509Certificate cert = (X509Certificate)certificate;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            fingerprint = digest.digest(cert.getEncoded());
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException e) {
            log.error("get ssl fingerprint failed", (Throwable)e);
            return;
        }
        StringBuilder hexString = new StringBuilder();
        for (byte b : fingerprint) {
            hexString.append(String.format("%02x", b));
        }
        fingerprintResult[0] = RestUtil.formatFingerprint(hexString.toString());
    }

    private static String formatFingerprint(String fingerprint) {
        return fingerprint.replaceAll("(.{2})(?=.)", "$1:").toUpperCase();
    }
}

