/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.crypto.EserviceKmcAesCrypterManager;
import com.huawei.ism.tool.devicepatch.remote.entity.TaskInfo;
import com.huawei.ism.tool.devicepatch.remote.service.RemotePatchService;
import com.huawei.ism.tool.devicepatch.remote.utils.ProgressUtil;
import com.huawei.ism.tool.framework.init.FrameworkInitiator;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.util.Arrays;
import org.slf4j.Logger;

public class DevicePatchProvicer4EService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DevicePatchProvicer4EService.class);
    private static final String TASKFILEPATH = "taskfile";
    private static final String ARGSPLITMARK = "=";
    private static FileOutputStream fos = null;
    private static FileLock locker = null;
    private static boolean singleRunning = true;

    public static void main(String[] args) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("user.dir : " + System.getProperty("user.dir"));
        }
        if (!DevicePatchProvicer4EService.paramCheck(Arrays.toString(args))) {
            System.exit(-1);
        }
        DevicePatchProvicer4EService.requestFileLock();
        try {
            DevicePatchProvicer4EService.buildPatchService(args);
            TaskInfo.REMOTE_TASK.setRemoteTask(true);
            RemotePatchService patchService = new RemotePatchService();
            FrameworkInitiator.init();
            EserviceKmcAesCrypterManager.setKmcConfigPath((String[])args);
            patchService.init();
            if (!singleRunning) {
                ProgressUtil.updateTotalProgress("100", ResourceUtil.getString((String)"patch.remote.start.remind"), "finished", "failed");
                return;
            }
            patchService.execute();
        }
        catch (Throwable t) {
            LOGGER.error("Execute remote path failed.", t);
            DevicePatchProvicer4EService.exitTask(-1);
        }
        DevicePatchProvicer4EService.exitTask(0);
    }

    private static void buildPatchService(String[] args) {
        for (String arg : args) {
            if (!arg.contains(TASKFILEPATH)) continue;
            TaskInfo.REMOTE_TASK.setTaskFilePath(arg.split(ARGSPLITMARK, 2)[1]);
        }
    }

    public static boolean paramCheck(String recvArgs) {
        String[] params;
        for (String param : params = new String[]{TASKFILEPATH}) {
            if (recvArgs.contains(param)) continue;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Param check not pass! recv param not contains " + param);
            }
            return false;
        }
        return true;
    }

    public static void exitTask(int status) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Exit task -> status : " + status);
        }
        DevicePatchProvicer4EService.release();
        Runtime.getRuntime().halt(status);
    }

    public static void release() {
        if (null != locker) {
            try {
                locker.release();
            }
            catch (IOException e) {
                LOGGER.error("Release file locker failed.", (Throwable)e);
            }
        }
        if (null != fos) {
            try {
                fos.close();
            }
            catch (IOException e) {
                LOGGER.error("Release stream failed.", (Throwable)e);
            }
        }
    }

    private static void requestFileLock() {
        try {
            fos = new FileOutputStream("runningFlag");
            locker = fos.getChannel().tryLock();
            if (null == locker) {
                singleRunning = false;
            }
        }
        catch (Exception e) {
            LOGGER.error("Get runningFalg lock failed.", (Throwable)e);
        }
    }
}

