/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch;

import com.huawei.ism.tool.base.ui.wizard.FlowWizardDialog;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.BizPackage;
import com.huawei.ism.tool.bizpack.PackProduct;
import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.entity.PatchInfo;
import com.huawei.ism.tool.devicepatch.entity.PatchUserOpData;
import com.huawei.ism.tool.devicepatch.entity.ProcessingInfo;
import com.huawei.ism.tool.devicepatch.remote.entity.TaskInfo;
import com.huawei.ism.tool.devicepatch.remote.utils.ProgressUtil;
import com.huawei.ism.tool.devicepatch.ui.main.DevicePatchMainDialog;
import com.huawei.ism.tool.devicepatch.utils.DevicePatchConstants;
import com.huawei.ism.tool.devicepatch.utils.PatchSceneUtil;
import com.huawei.ism.tool.framework.platform.context.AbstractContext;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.protocol.tlv.TlvConnectionManager;
import java.awt.Window;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.LoggerFactory;

public final class PatchDataContext
extends AbstractContext {
    private static PatchDataContext instance = null;
    private Window parent;
    private List<BizPackage> bizPackages = new ArrayList<BizPackage>();
    private List<DevPatch> devPatchs = new ArrayList<DevPatch>();
    private List<DevPatch> tmpDevPatchs = new ArrayList<DevPatch>();
    private List<DevPatch> tmpDevPatchsBranch = new ArrayList<DevPatch>();
    private List<DevNode> devNodes = new ArrayList<DevNode>();
    private Map<DevNode, ProcessingInfo> infoMap = new HashMap<DevNode, ProcessingInfo>();
    private Map<String, Object> contextMap = new HashMap<String, Object>();
    private Map<DevNode, PatchUserOpData> userOpDataMap = new ConcurrentHashMap<DevNode, PatchUserOpData>();
    private List<PatchUserOpData> userOpDataList = new LinkedList<PatchUserOpData>();
    private FlowWizardDialog wizDialog;
    private DevicePatchMainDialog mainDialog;
    private Map<String, String> zoneDataMap = new HashMap<String, String>();
    List<String> needOpenVersions = new ArrayList<String>();
    private static final String SHOW_USERNAME = "show user user_name=";
    private static final String SUPER_USER = "SUPER_ADMIN";
    private static final int INT_2 = 2;
    private static final String SPACE_REGEX = "[\\s]+";
    private static final String LINE_REGEX = "^\\s*-+(\\s+-+)*\\s*$";
    private boolean needLinkage = false;
    private String currentSubScene = "";
    private File reportDir = this.initReportDir();
    private boolean runEvaluing = false;

    private PatchDataContext() {
    }

    private File initReportDir() {
        String reportPath = System.getenv("jsonSceneResultPath");
        return StringUtils.isNULLStr((String)reportPath) ? FileUtils.getDefaultDirectory() : new File(reportPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PatchDataContext getInstance() {
        Class<PatchDataContext> clazz = PatchDataContext.class;
        synchronized (PatchDataContext.class) {
            if (instance == null) {
                instance = new PatchDataContext();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public List<DevPatch> getTmpDevPatchs() {
        return this.tmpDevPatchs;
    }

    public void setTmpDevPatchs(List<DevPatch> tmpDevPatchs) {
        this.tmpDevPatchs = tmpDevPatchs;
    }

    public BizPackage getBizPackage(DevNode devNode) {
        BizPackage bizPackage = null;
        for (BizPackage current : this.bizPackages) {
            if (!current.containDevNode(devNode) || bizPackage != null && bizPackage.getPublishDate().getTime() >= current.getPublishDate().getTime()) continue;
            bizPackage = current;
        }
        return bizPackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Class<PatchDataContext> clazz = PatchDataContext.class;
        synchronized (PatchDataContext.class) {
            this.clearConnection();
            this.bizPackages.clear();
            this.devPatchs.clear();
            this.devNodes.clear();
            this.infoMap.clear();
            this.mainDialog.dispose();
            this.mainDialog = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void clearConnection() {
        for (DevNode node : this.devNodes) {
            PatchDataContext.releaseSshConnection(node);
            try {
                TlvConnectionManager.releaseConnection((DevNode)node);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(PatchDataContext.class).error("Close tlv connetion failed.", (Throwable)e);
            }
        }
    }

    public PatchInfo getPatchInfo(DevNode devNode) {
        for (DevPatch patch : this.devPatchs) {
            if (!patch.getDevNode().contains(devNode)) continue;
            return patch.getBatchInfo();
        }
        return null;
    }

    public void setDevPatchs(DevPatch devPatch) {
        if (this.devPatchs.isEmpty()) {
            this.devPatchs.add(devPatch);
            return;
        }
        this.checkPatchInfo(devPatch);
    }

    private void checkPatchInfo(DevPatch dp) {
        for (DevPatch dpp : this.devPatchs) {
            if (PatchSceneUtil.isPatchEvalu()) {
                if (!dp.getBatchInfo().getVersion().equals(dpp.getBatchInfo().getVersion())) continue;
                this.checkNodes(dp, dpp);
                return;
            }
            if (!dp.getBatchInfo().getPatchPath().equals(dpp.getBatchInfo().getPatchPath())) continue;
            if (!StringUtils.isNULLStr((String)dp.getBatchInfo().getPatchPath())) {
                dpp.setBatchInfo(dp.getBatchInfo());
            }
            this.checkNodes(dp, dpp);
            return;
        }
        this.devPatchs.add(dp);
    }

    private void checkNodes(DevPatch dp, DevPatch dpp) {
        List<DevNode> devs = dp.getDevNode();
        for (DevNode dev : devs) {
            if (dpp.getDevNode().contains(dev)) continue;
            dpp.getDevNode().add(dev);
        }
    }

    public boolean isSupportDev(DevNode dev) {
        for (BizPackage bp : this.bizPackages) {
            List pplist = bp.getPackProducts();
            for (PackProduct pp : pplist) {
                if (!pp.containDevNode(dev)) continue;
                return true;
            }
        }
        return false;
    }

    public void addProcessingInfo(DevNode node, ProcessingInfo info) {
        this.infoMap.put(node, info);
    }

    public ProcessingInfo getProcessingInfo(DevNode node) {
        ProcessingInfo info = this.infoMap.get(node);
        if (info == null) {
            info = new ProcessingInfo();
            this.addProcessingInfo(node, info);
        }
        return this.infoMap.get(node);
    }

    public boolean hasNodeExecuted(DevNode devNode) {
        return this.infoMap.containsKey(devNode);
    }

    public void removeNodeInfo(DevNode node) {
        for (DevPatch patch : this.devPatchs) {
            if (patch.getDevNode().contains(node)) {
                patch.getDevNode().remove(node);
            }
            if (!patch.getDevNode().isEmpty()) continue;
            this.devPatchs.remove(patch);
            break;
        }
        this.infoMap.remove(node);
        this.devNodes.remove(node);
    }

    public void removeProcessingInfo(DevNode node) {
        if (this.infoMap.containsKey(node)) {
            this.infoMap.remove(node);
        }
    }

    public void uiCallBack(DevNode node) {
        if (TaskInfo.REMOTE_TASK.isRemoteTask()) {
            ProgressUtil.updateDevProgress(node);
        } else {
            this.mainDialog.resultCallBack(node);
        }
    }

    public List<DevPatch> getDevPatchs() {
        return this.devPatchs;
    }

    public List<BizPackage> getBizPackages() {
        return this.bizPackages;
    }

    public void setBizPackages(List<BizPackage> bizPackages) {
        if (PatchSceneUtil.isPatchEvalu()) {
            bizPackages.removeIf(item -> !item.getType().contains("evalu"));
        }
        this.bizPackages = bizPackages;
    }

    public FlowWizardDialog getWizDialog() {
        return this.wizDialog;
    }

    public void setWizDialog(FlowWizardDialog wizDialog) {
        this.wizDialog = wizDialog;
    }

    public DevicePatchMainDialog getMainDialog() {
        return this.mainDialog;
    }

    public void setMainDialog(DevicePatchMainDialog mainDialog) {
        this.mainDialog = mainDialog;
        DevicePatchConstants.PROCESSING_IMAGE.setImageObserver(mainDialog);
    }

    public List<DevNode> getDevNodes() {
        return this.devNodes;
    }

    public void setDevNodes(List<DevNode> devNodes) {
        this.devNodes = devNodes;
    }

    public Window getParent() {
        return this.parent;
    }

    public void setParent(Window parent) {
        this.parent = parent;
    }

    public void setTmpDevPatchsBranch(List<DevPatch> tmpDevPatchsBranch) {
        this.tmpDevPatchsBranch = tmpDevPatchsBranch;
    }

    public List<DevPatch> getTmpDevPatchsBranch() {
        return this.tmpDevPatchsBranch;
    }

    public Map<String, Object> getContextMap() {
        return this.contextMap;
    }

    public List<String> getNeedOpenVersions() {
        return this.needOpenVersions;
    }

    public void setNeedOpenVersions(List<String> needOpenVersions) {
        this.needOpenVersions = needOpenVersions;
    }

    public static boolean isNeedOpenOrCloseTlv(DevNode devNode) {
        String productVersion = devNode.getProductVersion().trim();
        List<String> list = PatchDataContext.getInstance().getNeedOpenVersions();
        for (String str : list) {
            if (null == str || 0 != productVersion.indexOf(str.trim())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void openTlv(DevNode devNode) {
        ICliConnection con = null;
        String changeModeResult = null;
        try {
            con = SshConnectionManager.getSshConnection(devNode, null, true, false);
            changeModeResult = con.execCmd("change user_mode current_mode user_mode=developer");
            ToolLoggerFactory.getLogger(PatchDataContext.class).info(devNode.getIp() + "developer open " + changeModeResult);
            String tlv = con.execCmd("change system external_tlv_channel enabled=yes");
            ToolLoggerFactory.getLogger(PatchDataContext.class).info(devNode.getIp() + "  tlv open  " + tlv);
            con.execCmd("y");
            con.execCmd("y");
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(PatchDataContext.class).error("open tlv failed", (Throwable)e);
        }
        finally {
            if (!StringUtils.isNULLStr((String)changeModeResult) && changeModeResult.indexOf("developer:/>") != -1 && null != con) {
                try {
                    changeModeResult = con.execCmd("exit");
                    if (changeModeResult.indexOf("y/n") != -1) {
                        con.execCmd("n");
                    }
                }
                catch (Exception e) {
                    ToolLoggerFactory.getLogger(PatchDataContext.class).error("exit developer mode fail", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeTlv(DevNode devNode) {
        ICliConnection con = null;
        try {
            con = SshConnectionManager.getSshConnection(devNode, null, true, false);
            String changeModeResult = con.execCmd("change user_mode current_mode user_mode=developer");
            ToolLoggerFactory.getLogger(PatchDataContext.class).info(devNode.getIp() + " change mode  " + changeModeResult);
            String changeTlvResult = con.execCmd("change system external_tlv_channel enabled=no");
            ToolLoggerFactory.getLogger(PatchDataContext.class).info(devNode.getIp() + "  tlv began to  close   " + changeTlvResult);
            con.execCmd("y");
            con.execCmd("y");
        }
        catch (Exception e) {
            try {
                ToolLoggerFactory.getLogger(PatchDataContext.class).error("exits closed tlv failure", (Throwable)e);
            }
            catch (Throwable throwable) {
                PatchDataContext.releaseSshConnection(con);
                throw throwable;
            }
            PatchDataContext.releaseSshConnection(con);
        }
        PatchDataContext.releaseSshConnection(con);
    }

    public static void releaseSshConnection(ICliConnection sshConn) {
        if (sshConn == null || !sshConn.isConnected()) {
            return;
        }
        try {
            SshConnectionManager.releaseConnection(sshConn);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(PatchDataContext.class).warn("release ssh failed: " + e.getMessage());
        }
    }

    public static void releaseSshConnection(DevNode devNode) {
        if (devNode == null) {
            return;
        }
        try {
            SshConnectionManager.releaseConnection(devNode);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(PatchDataContext.class).warn("release ssh failed: " + e.getMessage());
        }
    }

    public boolean isNeedLinkage() {
        return this.needLinkage;
    }

    public void setNeedLinkage(boolean needLinkage) {
        this.needLinkage = needLinkage;
    }

    public Map<DevNode, PatchUserOpData> getUserOpDataMap() {
        return this.userOpDataMap;
    }

    public List<PatchUserOpData> getUserOpDataList() {
        return this.userOpDataList;
    }

    public void setUserOpDataMap(Map<DevNode, PatchUserOpData> userOpData) {
        this.userOpDataMap = userOpData;
    }

    public void addUserOpInfoToList(PatchUserOpData userop) {
        this.userOpDataList.add(userop);
    }

    public String getCurrentSubScene() {
        return this.currentSubScene;
    }

    public void setCurrentSubScene() {
        this.currentSubScene = SceneUtils.getCurrentSubScene();
    }

    public File getReportDir() {
        return this.reportDir;
    }

    public void setReportDir(File reportDir) {
        this.reportDir = reportDir;
    }

    public String getReportHtml() {
        return Paths.get(ApplicationContext.getInstance().getTmpPath(), "report", "index.html").toString();
    }

    public boolean isRunEvaluing() {
        return this.runEvaluing;
    }

    public void setRunEvaluing(boolean runEvaluing) {
        this.runEvaluing = runEvaluing;
    }

    public Map<String, String> getZoneDataMap() {
        return this.zoneDataMap;
    }

    public void setZoneDataMap(Map<String, String> zoneDataMap) {
        this.zoneDataMap = zoneDataMap;
    }
}

