/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.entity;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.NodeResult;
import com.huawei.ism.tool.devicepatch.ui.main.entity.enums.ZoneRunningStatus;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.IniResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import utils.Products;

public class ExecuteResult {
    private NodeResult result = null;
    private String description = "";
    private boolean success = true;
    private DevNode devNode = null;
    private int process = 0;
    private int curProgress = 0;
    private String remainTime;
    private Date time = null;
    private boolean processing = true;
    private String detail = "";
    private boolean isCheckItem = true;
    private String itemType = "";
    private String itemId = "";
    private String originInfo = "";
    private List<ExecuteResult> subResults;
    private ZoneRunningStatus status;

    public ExecuteResult(NodeResult result) {
        this.result = result;
        this.time = new Date();
    }

    public NodeResult getResult() {
        return this.result;
    }

    public void setResult(NodeResult result) {
        this.result = result;
    }

    public int getProcess() {
        return this.process;
    }

    public DevNode getDevNode() {
        return this.devNode;
    }

    public void setDevNode(DevNode devNode) {
        this.devNode = devNode;
    }

    public void setProcess(int process) {
        this.process = process;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSuccess(boolean isSuccess) {
        this.success = isSuccess;
    }

    public void setStartDate(Date startTime) {
        this.time = startTime;
    }

    public String getStartDateString() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.time);
    }

    public String getDescription() {
        return this.result == null ? this.description : ResourceUtil.getString((String)this.result.getDescription());
    }

    public boolean isSuccess() {
        return this.result == null ? this.success : this.result.isSuccess();
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public void setProcessing(boolean processing) {
        this.processing = processing;
    }

    public String getDetail() {
        if (!StringUtils.isNULLStr(this.detail)) {
            return this.detail;
        }
        if (ZoneRunningStatus.UPD_UPGRADING.equals((Object)this.status) || ZoneRunningStatus.UPD_UPD_SUCCESS.equals((Object)this.status)) {
            return this.detail;
        }
        if (this.result == null || this.result.isSuccess()) {
            return ResourceUtil.getString((String)"patch.main.detail.info");
        }
        if (StringUtils.isNULLStr(this.result.getDetail())) {
            return ResourceUtil.getString((String)"patch.main.detail.failed.common.info");
        }
        return this.result.getDetail();
    }

    public void setDeatail(String detail) {
        this.detail = detail;
    }

    public String getRemainTime() {
        return this.remainTime;
    }

    public void setRemainTime(String remainTime) {
        this.remainTime = remainTime;
    }

    public int getCurProgress() {
        return this.curProgress;
    }

    public void setCurProgress(int curProgress) {
        this.curProgress = curProgress;
    }

    public boolean isCheckItem() {
        return this.isCheckItem;
    }

    public void setCheckItem(boolean checkItem) {
        this.isCheckItem = checkItem;
    }

    public String getOriginInfo() {
        return this.originInfo;
    }

    public void setOriginInfo(String originInfo) {
        this.originInfo = originInfo;
    }

    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public String getItemId() {
        return this.result == null ? this.itemId : this.result.getNodeID();
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getCheckMethod() {
        return this.getString(this.getItemId() + ".method");
    }

    public String getCheckCriterion() {
        return this.getString(this.getItemId() + ".criterion");
    }

    public String getCheckSuggestion() {
        return this.getString(this.getItemId() + ".suggestion");
    }

    public String getString(String key) {
        if ("innercheck".equals(this.getItemType())) {
            String val;
            if (Products.isDoradoV6SeriseDev(this.devNode.getDeviceType().toString()) && !"--".equals(val = IniResourceUtil.getString("cbb/res/upgrade", "resource_dorado", key))) {
                return val;
            }
            val = IniResourceUtil.getString(key);
            val = "--".equals(val) ? key : val;
            return val;
        }
        String val = IniResourceUtil.getString("cbb/res/patch", "resource", key);
        return "--".equals(val) ? key : val;
    }

    public List<ExecuteResult> getSubResults() {
        return this.subResults;
    }

    public void setSubResults(List<ExecuteResult> subResults) {
        this.subResults = subResults;
    }

    public ZoneRunningStatus getStatus() {
        return this.status;
    }

    public void setStatus(ZoneRunningStatus status) {
        this.status = status;
    }
}

