/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.entity;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.entity.ExecuteResult;
import com.huawei.ism.tool.devicepatch.remote.entity.TaskInfo;
import com.huawei.ism.tool.devicepatch.utils.PatchSceneUtil;
import java.util.ArrayList;
import java.util.List;

public class ProcessingInfo {
    private List<ExecuteResult> results = new ArrayList<ExecuteResult>();
    private DevPatch.DevPatchStatus status = DevPatch.DevPatchStatus.ASSOCIATED;
    private String currentVer = "";
    private boolean taskRunning = false;

    public String getCurrentVer() {
        return this.currentVer;
    }

    public void setCurrentVer(String currentVer) {
        this.currentVer = currentVer;
    }

    public void addResult(ExecuteResult result) {
        ExecuteResult lastResult = this.getLastExecuteResult();
        if (lastResult.isSuccess() && lastResult.isProcessing()) {
            lastResult.setProcessing(false);
        }
        this.results.add(result);
        if (!(PatchSceneUtil.isPatchEvalu() || result.isSuccess() && lastResult.isSuccess())) {
            this.status = DevPatch.DevPatchStatus.FAILED;
            if (TaskInfo.REMOTE_TASK.isRemoteTask()) {
                TaskInfo.REMOTE_TASK.appendErrMsg(lastResult.getDevNode(), lastResult.getDescription(), lastResult.getDetail());
            }
            return;
        }
        if (lastResult.getDescription().equals(result.getDescription())) {
            this.results.remove(lastResult);
        }
        if (!result.isProcessing() && result.getProcess() == 100) {
            if (DevPatch.DevPatchStatus.FAILED.equals((Object)this.status)) {
                lastResult.setProcessing(false);
            } else {
                this.status = DevPatch.DevPatchStatus.COMPLETED;
                lastResult.setProcessing(false);
            }
        }
    }

    public int getTotalProcess() {
        if (this.results.isEmpty()) {
            return 0;
        }
        for (int lastIndex = this.results.size() - 1; lastIndex >= 0; --lastIndex) {
            ExecuteResult lastResult = this.results.get(lastIndex);
            if (lastResult.isProcessing()) {
                continue;
            }
            return lastResult.getProcess();
        }
        return 0;
    }

    public DevPatch.DevPatchStatus getStatus() {
        return this.status;
    }

    public void setStatus(DevPatch.DevPatchStatus status) {
        this.status = status;
    }

    public List<ExecuteResult> getResults() {
        return this.results;
    }

    public void clear() {
        this.status = DevPatch.DevPatchStatus.ASSOCIATED;
        this.results.clear();
    }

    private ExecuteResult getLastExecuteResult() {
        if (this.results.isEmpty()) {
            ExecuteResult result = new ExecuteResult(null);
            result.setProcessing(false);
            result.setProcess(0);
            return result;
        }
        return this.results.get(this.results.size() - 1);
    }

    public void setLastStatus() {
        if (this.results == null || this.results.isEmpty()) {
            return;
        }
        for (ExecuteResult result : this.results) {
            if (!result.getDescription().equals(ResourceUtil.getString((String)"patch.flow.detail.upgrade")) || !result.isSuccess()) continue;
            this.status = DevPatch.DevPatchStatus.COMPLETED;
        }
    }

    public boolean isTaskRunning() {
        return this.taskRunning;
    }

    public void setTaskRunning(boolean taskRunning) {
        this.taskRunning = taskRunning;
    }
}

