/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.logic;

import cn.hutool.core.bean.BeanUtil;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.IProcessEnvCreator;
import com.huawei.ism.tool.bizpack.IProcessListener;
import com.huawei.ism.tool.bizpack.NodeItem;
import com.huawei.ism.tool.bizpack.ProcessInfo;
import com.huawei.ism.tool.bizpack.ProcessInstance;
import com.huawei.ism.tool.bizpack.ProcessInstanceBuilder;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.entity.ExecuteResult;
import com.huawei.ism.tool.devicepatch.entity.PatchInfo;
import com.huawei.ism.tool.devicepatch.entity.ProcessingInfo;
import com.huawei.ism.tool.devicepatch.logic.A800RetryPatchEnvCreator;
import com.huawei.ism.tool.devicepatch.logic.PatchEnvCreator;
import com.huawei.ism.tool.devicepatch.logic.PatchTask;
import com.huawei.ism.tool.devicepatch.logic.StartRetryPatchProcess;
import com.huawei.ism.tool.framework.platform.common.data.UserOpTaskResult;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.PwdException;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.exception.UserStatusException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class A800RetryPatchTask
extends PatchTask {
    private static final Logger log = LoggerFactory.getLogger(A800RetryPatchTask.class);
    private final List<String> retryZones;
    private final String itemId;

    public A800RetryPatchTask(DevNode node, List<String> retryZones, String itemId) {
        this(node, null, retryZones, itemId);
    }

    public A800RetryPatchTask(DevNode node, CountDownLatch countDownLatch, List<String> retryZones, String itemId) {
        super(node, countDownLatch);
        this.retryZones = retryZones;
        this.itemId = itemId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName("node-" + this.node.getIp() + "-retry-patch-thread");
        log.info("Start patch task : {}", (Object)this.node.getDeviceSerialNumber());
        ProcessingInfo info = PatchDataContext.getInstance().getProcessingInfo(this.node);
        info.setTaskRunning(true);
        info.setStatus(DevPatch.DevPatchStatus.RUNNING);
        this.updateUi();
        this.initRetryResult(info);
        PatchInfo patch = PatchDataContext.getInstance().getPatchInfo(this.node);
        if (patch == null) {
            log.error("device :{} has not set configuration for patch", (Object)this.node.getIp());
            info.setTaskRunning(false);
            this.updateUi();
            return;
        }
        this.initUserData(patch);
        PatchEnvCreator env = this.initEnv();
        try {
            this.buildRetryProcess(env).process();
            List<ExecuteResult> results = PatchDataContext.getInstance().getProcessingInfo(this.node).getResults();
            A800RetryPatchTask.updateCheckItemResult(results, info);
            boolean taskResult = info.getStatus() != DevPatch.DevPatchStatus.FAILED;
            this.userOpData.setTaskResult(taskResult ? UserOpTaskResult.SUCCESS : UserOpTaskResult.FAILED);
            log.info("Patch the  {} for {} device : {}", new Object[]{patch.getPatchPath(), this.node.getIp(), taskResult});
            this.updatePatchVersion(patch, taskResult);
        }
        catch (ToolException businessException) {
            log.error("prepare retry for node :{} failed", (Object)this.node.getIp(), (Object)businessException);
            info.getResults().stream().filter(this::isRetryItemResult).findFirst().ifPresent(result -> {
                result.setDeatail(businessException.getErrorLocaleDescription());
                result.setSuccess(false);
                result.setProcessing(false);
            });
        }
        catch (Exception e) {
            log.error("execute task error.", (Throwable)e);
        }
        finally {
            if (this.countDownLatch != null) {
                this.countDownLatch.countDown();
            }
            info.setTaskRunning(false);
            this.endTask(env);
        }
    }

    private static void updateCheckItemResult(List<ExecuteResult> results, ProcessingInfo info) {
        for (ExecuteResult resultItem : results) {
            if (resultItem.isSuccess()) continue;
            info.setStatus(DevPatch.DevPatchStatus.FAILED);
            break;
        }
    }

    private ProcessInstance buildRetryProcess(PatchEnvCreator env) throws ToolException {
        try {
            ProcessInstanceBuilder proIns = this.initProcessBuilder(env);
            ProcessInstance pInstance = proIns.construct(this.buildProcessInfo());
            pInstance.getExecutor().addJythonClassPath(this.buildClassPath());
            return pInstance;
        }
        catch (PwdException e2) {
            log.error("ssh pwd error.", (Throwable)e2);
            throw new ToolException(e2.getErrorMsg(), false);
        }
        catch (UserStatusException e) {
            log.error("tlv pwd error.", (Throwable)e);
            throw new ToolException(e.getDes(), false);
        }
        catch (Exception e1) {
            log.error("ssh connection error.", (Throwable)e1);
            ProcessingInfo info = PatchDataContext.getInstance().getProcessingInfo(this.node);
            info.setStatus(DevPatch.DevPatchStatus.FAILED);
            throw new ToolException("patch.card.showinfo.conerror");
        }
    }

    private void initRetryResult(ProcessingInfo info) {
        ArrayList<ExecuteResult> existsResult = new ArrayList<ExecuteResult>(info.getResults());
        info.clear();
        for (ExecuteResult result : existsResult) {
            info.addResult(result);
            if (!this.isRetryItemResult(result)) continue;
            result.setProcess(30);
            break;
        }
    }

    private boolean isRetryItemResult(ExecuteResult result) {
        return result.getDescription().equals(this.itemId);
    }

    @NotNull
    private ProcessInstanceBuilder initProcessBuilder(PatchEnvCreator env) {
        StartRetryPatchProcess pro = new StartRetryPatchProcess(this.node);
        ProcessInstanceBuilder proIns = new ProcessInstanceBuilder();
        proIns.addProcessListener((IProcessListener)pro);
        proIns.setEnvCreator((IProcessEnvCreator)env);
        return proIns;
    }

    @NotNull
    private PatchEnvCreator initEnv() {
        PatchEnvCreator env = this.buildScriptEnv();
        env.createPkgPathEnv(Objects.requireNonNull(PatchDataContext.getInstance().getPatchInfo(this.node)).getPatchPath());
        return env;
    }

    private void updateUi() {
        PatchDataContext.getInstance().uiCallBack(this.node);
    }

    @Override
    protected void initUserData(PatchInfo pinfo) {
        this.userOpData = PatchDataContext.getInstance().getUserOpDataMap().get(this.node);
    }

    @Override
    protected ProcessInfo buildProcessInfo() {
        ProcessInfo processInfo = this.buildNewProcessInfo();
        processInfo.setNodeItems(this.buildNewItems(processInfo));
        return processInfo;
    }

    @NotNull
    private List<NodeItem> buildNewItems(ProcessInfo processInfo) {
        boolean findRetryItem = false;
        ArrayList<NodeItem> retryItems = new ArrayList<NodeItem>();
        for (NodeItem nodeItem : processInfo.getNodeItems()) {
            if (ResourceUtil.getString((String)nodeItem.getDescription()).equals(this.itemId)) {
                retryItems.add(this.builNodeItem(nodeItem));
                findRetryItem = true;
                continue;
            }
            if (!findRetryItem) continue;
            retryItems.add(nodeItem);
        }
        return retryItems;
    }

    private NodeItem builNodeItem(NodeItem nodeItem) {
        NodeItem retryItem = new NodeItem();
        BeanUtil.copyProperties((Object)nodeItem, (Object)retryItem, (String[])new String[0]);
        retryItem.setRetry(true);
        retryItem.setScriptFilePath(this.buildRetryScript(retryItem));
        return retryItem;
    }

    private ProcessInfo buildNewProcessInfo() {
        ProcessInfo processInfo = super.buildProcessInfo();
        ProcessInfo newInfo = new ProcessInfo();
        newInfo.setId(processInfo.getId());
        newInfo.setDescription(processInfo.getDescription());
        newInfo.setEnvParamNames(processInfo.getEnvParamNames());
        newInfo.setScriptPath(processInfo.getScriptPath());
        newInfo.setNodeItems(new ArrayList(processInfo.getNodeItems()));
        return newInfo;
    }

    @Override
    @NotNull
    protected PatchEnvCreator buildScriptEnv() {
        HashMap<String, Object> retryParam = new HashMap<String, Object>();
        retryParam.put("zone_ids", this.retryZones);
        return new A800RetryPatchEnvCreator(this.node, retryParam);
    }

    private String buildRetryScript(NodeItem item) {
        try {
            File file = new File(item.getScriptFilePath());
            return new File(file.getParent(), "retry_" + file.getName()).getCanonicalPath();
        }
        catch (FileNotFoundException fnf) {
            log.warn("build retry path for : {} failed", (Object)item.getId());
        }
        catch (IOException e) {
            log.warn("build retry path for : {} failed", (Object)item.getId(), (Object)e);
        }
        return item.getScriptFilePath();
    }
}

