/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.logic;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.tool.bizpack.BizPackage;
import com.huawei.ism.tool.bizpack.BizPackageParser;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.ui.main.dialog.ImportDetailDialog;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class BizPackageSupport {
    private String configPath = this.getPkgPath();

    public boolean importBizPackage(File bizpackage) throws ToolException {
        if (null == bizpackage) {
            return false;
        }
        if (!bizpackage.exists()) {
            return false;
        }
        String path = bizpackage.getName();
        String pkgName = path.substring(0, path.indexOf(".zip"));
        String tmpPath = ApplicationContext.getInstance().getTmpPath() + pkgName;
        File tmpFile = new File(tmpPath);
        if (!tmpFile.exists() && !tmpFile.mkdirs()) {
            throw new ToolException("mkdirs tmp file fialed.", false);
        }
        try {
            ZipUtils.decompressFile((File)bizpackage, (String)tmpPath);
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("decompress file error.", (Throwable)e);
            this.deletePackageFiles(tmpPath);
            throw new ToolException("press file fialed.", false, (Throwable)e);
        }
        BizPackageParser bkp = new BizPackageParser();
        BizPackage pkg = bkp.parseBizPackage(tmpPath);
        if (pkg == null) {
            this.deletePackageFiles(tmpPath);
            throw new ToolException("parse pkg fialed.", false);
        }
        ImportDetailDialog dialog = new ImportDetailDialog(pkg, (Window)PatchDataContext.getInstance().getWizDialog());
        dialog.setVisible(true);
        if (!dialog.clickOk()) {
            this.deletePackageFiles(tmpPath);
            return false;
        }
        String checkPatch = this.configPath + File.separator + pkgName;
        File oldFile = new File(checkPatch);
        if (oldFile.exists()) {
            this.deletePackageFiles(checkPatch);
        }
        FileUtils.copyDir((String)tmpPath, (String)checkPatch);
        this.deletePackageFiles(tmpPath);
        dialog.dispose();
        return true;
    }

    private void deletePackageFiles(String checkPatch) {
        File file = new File(checkPatch);
        if (!file.exists()) {
            return;
        }
        FileUtils.deleteFile((File)file);
    }

    public void loadBizPackages() {
        BizPackageParser bkp = new BizPackageParser();
        List pkgList = bkp.parseBizPackages(this.getPkgPath());
        PatchDataContext.getInstance().setBizPackages(pkgList);
    }

    private String getPkgPath() {
        return ApplicationContext.getInstance().getWorkPath() + File.separator + "packages" + File.separator + "patch" + File.separator + "products";
    }
}

