/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.logic;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.entity.PatchInfo;
import com.huawei.ism.tool.devicepatch.utils.DevicePatchUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.excel.POIUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DevPatchExcelWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DevPatchExcelWriter.class);
    private HSSFWorkbook workBook = null;
    private Sheet deploySheet = null;
    private static final String NEED_OPEN_TLV_PATH = "packages" + File.separator + "patch" + File.separator + "products" + File.separator + "neededOpenTlvChannel.xml";
    private Font font = null;
    private HSSFCellStyle titleStyle = null;
    private HSSFCellStyle contentStyle = null;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exportDevPatchInfo(String path) throws ToolException {
        FileOutputStream fos = null;
        try {
            File excelFile = new File(path);
            if (excelFile.exists() && !excelFile.delete()) {
                throw new ToolException("delete old file failed.", false);
            }
            File file = excelFile.getParentFile();
            if (!file.exists() && !file.mkdirs()) {
                throw new ToolException("mkdirs files failed.", false);
            }
            if (!excelFile.createNewFile()) {
                throw new ToolException("create file error.", false);
            }
            fos = new FileOutputStream(new File(path));
            this.workBook = new HSSFWorkbook();
            this.initFontAndStyle();
            this.deploySheet = this.workBook.createSheet("Patch Info");
            this.createPatchInfo();
            this.workBook.write((OutputStream)fos);
        }
        catch (IOException ioe) {
            try {
                LOGGER.error("export devpatchinfo error.", (Throwable)ioe);
                throw new ToolException("export devpatchinfo error,FileNotFoundException.", false, (Throwable)ioe);
                catch (Exception e) {
                    LOGGER.error("export devpatchinfo error.", (Throwable)e);
                    throw new ToolException("export devpatchinfo error.", false, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, (Closeable)this.workBook);
                StreamUtils.closeStream(fos, null);
                throw throwable;
            }
        }
        StreamUtils.closeResource(null, (Closeable)this.workBook);
        StreamUtils.closeStream((OutputStream)fos, null);
    }

    private void createPatchInfo() {
        this.deploySheet.setColumnWidth(0, 20);
        this.deploySheet.setColumnWidth(1, 5120);
        this.deploySheet.setColumnWidth(2, 5120);
        this.deploySheet.setColumnWidth(3, 5120);
        this.deploySheet.setColumnWidth(4, 5120);
        this.deploySheet.setColumnWidth(5, 7680);
        int column = 0;
        POIUtils.setCellValue(this.deploySheet, 0, column++, ResourceUtil.getString((String)"patch.main.table.model"), this.titleStyle);
        POIUtils.setCellValue(this.deploySheet, 0, column++, ResourceUtil.getString((String)"patch.card.step1.table.version"), this.titleStyle);
        POIUtils.setCellValue(this.deploySheet, 0, column++, ResourceUtil.getString((String)"patch.main.table.ip"), this.titleStyle);
        POIUtils.setCellValue(this.deploySheet, 0, column++, ResourceUtil.getString((String)"patch.main.table.name"), this.titleStyle);
        POIUtils.setCellValue(this.deploySheet, 0, column++, ResourceUtil.getString((String)"patch.card.step2.table.pkgversion"), this.titleStyle);
        POIUtils.setCellValue(this.deploySheet, 0, column++, ResourceUtil.getString((String)"patch.card.step2.table.detail"), this.titleStyle);
        int row = 1;
        List<DevPatch> patchList = PatchDataContext.getInstance().getTmpDevPatchsBranch();
        for (DevPatch patch : patchList) {
            for (int i = 0; i < patch.getDevNode().size(); ++i) {
                this.createPatchData(row++, i, patch);
            }
        }
    }

    private void createPatchData(int row, int i, DevPatch patch) {
        int column = 0;
        DevNode devNode = patch.getDevNode().get(i);
        PatchInfo patchInfo = patch.getBatchInfo();
        POIUtils.setCellValue(this.deploySheet, row, column++, DevicePatchUtil.getDisplayModel(devNode), this.contentStyle);
        POIUtils.setCellValue(this.deploySheet, row, column++, devNode.getProductVersion(), this.contentStyle);
        POIUtils.setCellValue(this.deploySheet, row, column++, devNode.getIp(), this.contentStyle);
        String deviceName = StringUtils.isNULLStr((String)devNode.getDeviceName()) ? "--" : devNode.getDeviceName();
        POIUtils.setCellValue(this.deploySheet, row, column++, deviceName, this.contentStyle);
        POIUtils.setCellValue(this.deploySheet, row, column++, patchInfo.getVersion(), this.contentStyle);
        POIUtils.setCellValue(this.deploySheet, row, column++, patchInfo.getDescription(), this.contentStyle);
    }

    private void initFontAndStyle() {
        this.font = this.workBook.createFont();
        this.font.setFontName("Times New Roman");
        this.font.setFontHeightInPoints((short)10);
        this.font.setBold(false);
        this.font.setItalic(false);
        this.titleStyle = this.createTitleStyle();
        this.contentStyle = this.createContentStyle();
    }

    private HSSFCellStyle createTitleStyle() {
        return this.createCellStyle(false);
    }

    private HSSFCellStyle createContentStyle() {
        return this.createCellStyle(true);
    }

    private HSSFCellStyle createCellStyle(boolean wrapText) {
        HSSFCellStyle style = this.workBook.createCellStyle();
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setFillForegroundColor(IndexedColors.GREY_50_PERCENT.index);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setDataFormat(this.workBook.createDataFormat().getFormat("@"));
        style.setFont(this.font);
        style.setWrapText(wrapText);
        return style;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> loadOpenTlvProduct() {
        File file = new File(NEED_OPEN_TLV_PATH);
        ArrayList<String> list = new ArrayList<String>();
        if (!file.exists()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("not found file" + file);
            }
            return list;
        }
        Collection childs = null;
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(file);
            Document doc = XmlUtils.parseDocument((InputStream)fs);
            Element root = doc.getDocumentElement();
            childs = XmlUtils.getChildren((Element)root);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load neededOpenTlvChannel.xml ", (Throwable)e);
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)fs);
        }
        List<String> versions = DevPatchExcelWriter.getAttributeValuesByName(childs);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("need open tls dev from config: " + versions.toString());
        }
        list.addAll(versions);
        return list;
    }

    private static List<String> getAttributeValuesByName(Collection<Element> childs) {
        ArrayList<String> versions = new ArrayList<String>();
        for (Element child : childs) {
            String version = XmlUtils.getAttribute((Element)child, (String)"version");
            versions.add(version);
        }
        return versions;
    }
}

