/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.logic;

import com.google.common.base.Objects;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.IProcessEnvCreator;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.logic.config.ConnectorFactory;
import com.huawei.ism.tool.devicepatch.utils.DevicePatchUtil;
import com.huawei.ism.tool.devicepatch.utils.PatchSceneUtil;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevMap;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.PortUnreachableException;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.NetUtil;
import com.huawei.ism.tool.obase.utils.OSCmdUtils;
import com.huawei.ism.tool.protocol.sftp.SftpTransfer;
import com.huawei.ism.tool.protocol.tlv.ITLVConnection;
import com.huawei.ism.tool.protocol.tlv.TlvConnectionManager;
import com.huawei.ism.tool.pyengine.utils.PyJavaUtils;
import java.awt.Window;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchEnvCreator
implements IProcessEnvCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PatchEnvCreator.class);
    private static final int INT3 = 3;
    private static final int DEFAULT_HTTP_PORT = 8080;
    private DevNode devNode = null;
    private Map<String, Object> env = new HashMap<String, Object>();

    public PatchEnvCreator() {
    }

    public PatchEnvCreator(DevNode devNode) {
        this.devNode = devNode;
    }

    public Map<String, Object> createEnv(List<String> envNames) throws ToolException {
        this.env.put("context", PatchDataContext.getInstance().getContextMap());
        Optional<DevPatch> devPatch = PatchDataContext.getInstance().getDevPatchs().stream().filter(obj -> obj.getDevNode().stream().anyMatch(dev -> dev.getDeviceSerialNumber().equals(this.devNode.getDeviceSerialNumber()))).findAny();
        if (devPatch.isPresent()) {
            this.env.put("pkgVersion", devPatch.get().getBatchInfo().getVersion());
        }
        if (PatchSceneUtil.isA800PatchEval()) {
            this.env.put("isA800Scene", true);
            if (Objects.equal((Object)this.devNode.getPreCheckModel(), (Object)"execute")) {
                this.env.put("zone_ids", this.devNode.getZoneIds());
            }
            this.env.put("preCheckMode", this.devNode.getPreCheckModel());
            this.env.put("zone_id", this.devNode.getUuid());
            this.env.put("zoneDataMap", PatchDataContext.getInstance().getZoneDataMap());
            this.env.put("execute_ip", this.devNode.getExecuteZoneIp());
        }
        this.env.put("befPatchVersion", this.devNode.getHotPatchVersion());
        this.env.put("progressObserver", PatchDataContext.getInstance().getMainDialog());
        HashMap<String, ConnectorFactory> protocs = new HashMap<String, ConnectorFactory>();
        protocs.put("connectorFactory", ConnectorFactory.getInstance());
        this.env.put("protocalContext", protocs);
        this.setBasicData(envNames);
        if (envNames.contains("developer")) {
            String debugPwd = this.devNode.getDeveloperPwd();
            this.env.put("developer", debugPwd);
            debugPwd = "";
        }
        if (envNames.contains("dev")) {
            this.env.put("dev", DevicePatchUtil.transToRequestNode(this.devNode));
        }
        this.env.put("newDev", this.getDevMapForRest(DevicePatchUtil.transToRequestNode(this.devNode)));
        return this.env;
    }

    private void setBasicData(List<String> envNames) throws ToolException {
        if (PatchDataContext.isNeedOpenOrCloseTlv(this.devNode)) {
            PatchDataContext.openTlv(this.devNode);
        }
        if (envNames.contains("tlv")) {
            this.getTlvObject();
        }
        if (envNames.contains("ssh")) {
            this.getSshObject();
        }
        if (envNames.contains("lang")) {
            this.getCurrentLang();
        }
        if (envNames.contains("ftpIp")) {
            this.getLocalIP();
        }
        if (envNames.contains("sftp")) {
            this.getSftpObject();
        }
        if (envNames.contains("logger")) {
            this.getLoggerObject();
        }
    }

    public void clearEnv() {
        Object protocolObject = this.env.get("ssh");
        if (protocolObject != null) {
            SshConnection connection = (SshConnection)protocolObject;
            PatchDataContext.releaseSshConnection(connection);
        }
        if ((protocolObject = this.env.get("tlv")) != null) {
            TlvConnectionManager.releaseConnection((ITLVConnection)((ITLVConnection)protocolObject));
        }
        this.releaseRestConnection();
    }

    public void releaseRestConnection() {
        PyJavaUtils.releaseRestConnection(this.env);
    }

    private void getLoggerObject() {
        this.env.put("logger", ToolLoggerFactory.getLoggerInStandAlone("devPatchLog"));
    }

    private void getTlvObject() throws ToolException {
        try {
            TlvConnectionManager.setGlobalRetryTimes((int)3);
            this.env.put("tlv", TlvConnectionManager.getConnectionByInnerIp((DevNode)this.devNode));
        }
        catch (ToolException e) {
            Optional<String> reachableIp = this.devNode.getIpList().stream().filter(innerIp -> !NetUtil.isPortCannotReach(innerIp, 8080)).findAny();
            if (!reachableIp.isPresent()) {
                PortUnreachableException ex = new PortUnreachableException(e.getErrorId(), false);
                ex.setDes(String.format(Locale.ROOT, ResourceUtil.getString((String)"patch.card.step1.port_unreachable"), 8080));
                throw ex;
            }
            LOGGER.error("init patch env failed.init tlv object fail.");
            throw e;
        }
    }

    private void getSftpObject() throws ToolException {
        SftpTransfer.setGlobalRetryTimes((int)3);
        SftpTransfer sftp = new SftpTransfer(DevicePatchUtil.transToRequestNode(this.devNode), true);
        this.env.put("sftp", sftp);
    }

    public Map<String, Object> createParsePathEnv(String path) {
        this.env.put("parsePath", path);
        return this.env;
    }

    public void putLoadPatchPathSceneInEnv(Window parent) {
        this.env.put("loadPatchPathScene", parent);
    }

    public Map<String, Object> createPkgPathEnv(String path) {
        this.env.put("packagePath", path);
        return this.env;
    }

    private void getLocalIP() throws ToolException {
        String localIP = OSCmdUtils.getLocalAddress(this.devNode.getIp(), 21);
        if (StringUtils.isNULLStr((String)localIP)) {
            LOGGER.error("get local ip failed!!!");
            throw new ToolException("");
        }
        this.env.put("ftpIp", localIP);
    }

    private void getSshObject() throws ToolException {
        if (this.devNode.isIpListAreInnerIp()) {
            LOGGER.error("Use dev inner iplist to connect device.");
            List<String> ips = this.devNode.getIpList();
            ICliConnection con = null;
            ToolException ex = null;
            for (String innerIp : ips) {
                DevNode newDev = new DevNode();
                newDev.setDeviceName(this.devNode.getDeviceName());
                newDev.setDeviceSerialNumber(this.devNode.getDeviceSerialNumber());
                newDev.setDeviceType(this.devNode.getDeviceType());
                newDev.setLoginUser(this.devNode.getLoginUser());
                newDev.setPort(this.devNode.getPort());
                newDev.setProductVersion(this.devNode.getProductVersion());
                newDev.setSocks5Proxy(this.devNode.getSocks5Proxy());
                newDev.setSshForwardList(this.devNode.getSshForwardList());
                newDev.setIp(innerIp);
                try {
                    con = SshConnectionManager.getSshConnection(newDev, null, true, false);
                    break;
                }
                catch (ToolException e) {
                    ex = e;
                    LOGGER.error("Use dev inner ip(" + innerIp + ") to connect device failed.");
                }
            }
            if (null == con) {
                throw ex;
            }
            this.env.put("ssh", con);
        } else {
            LOGGER.error("Use dev ip to connect device.");
            this.env.put("ssh", SshConnectionManager.getSshConnection(DevicePatchUtil.transToRequestNode(this.devNode), null, true, false));
        }
    }

    private void getCurrentLang() {
        Locale locale = ApplicationContext.getInstance().getCurrentLanguage();
        if (Locale.CHINA.equals(locale)) {
            this.env.put("lang", "zh");
        } else {
            this.env.put("lang", "en");
        }
    }

    private Map<String, String> getDevMapForRest(DevNode dev) {
        DevMap<String, String> devMapDict = new DevMap<String, String>();
        devMapDict.put("sn", dev.getDeviceSerialNumber());
        devMapDict.put("name", dev.getDeviceName());
        devMapDict.put("ip", dev.getIp());
        devMapDict.put("user", dev.getLoginUser().getUserName());
        String pwd = dev.getLoginUser().getPassword();
        devMapDict.put("pawd", pwd);
        devMapDict.put("sshPort", String.valueOf(dev.getPort()));
        devMapDict.put("type", dev.getDeviceType().toString());
        devMapDict.put("version", dev.getProductVersion());
        return devMapDict;
    }
}

