/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.logic;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.logic.A800RetryPatchTask;
import com.huawei.ism.tool.devicepatch.logic.A800RollbackPatchTask;
import com.huawei.ism.tool.devicepatch.logic.PatchTask;
import com.huawei.ism.tool.devicepatch.report.PatchEvaluReportBuilder;
import com.huawei.ism.tool.devicepatch.service.enums.OptionType;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchExecutorSupport {
    private static final PatchExecutorSupport INSTANCE = new PatchExecutorSupport();
    private static final Logger LOGGER = LoggerFactory.getLogger(PatchExecutorSupport.class);
    private ExecutorService executor = Executors.newFixedThreadPool(10);

    private PatchExecutorSupport() {
    }

    public static PatchExecutorSupport getInstance() {
        return INSTANCE;
    }

    public void addPatchJob(DevNode devNode, CountDownLatch countDownLatch, OptionType optionType) {
        PatchTask task = OptionType.ROLLBACK.equals((Object)optionType) ? new A800RollbackPatchTask(devNode, countDownLatch) : new PatchTask(devNode, countDownLatch);
        this.executor.execute(task);
    }

    public void addRetryPatchJob(DevNode devNode, List<String> zoneIds, String itemId) {
        A800RetryPatchTask task = new A800RetryPatchTask(devNode, zoneIds, itemId);
        this.executor.execute(task);
    }

    public Future<?> submitPatchJob(DevNode devNode) {
        PatchTask task = new PatchTask(devNode);
        return this.executor.submit(task);
    }

    public void addReportTask(List<DevNode> devNodes, CountDownLatch countDownLatch) {
        this.executor.execute(() -> {
            try {
                countDownLatch.await();
                PatchEvaluReportBuilder reportBuilder = new PatchEvaluReportBuilder();
                boolean reportRet = reportBuilder.buildReport(devNodes);
                if (!reportRet) {
                    LOGGER.warn("build report failed.");
                    DialogUtils.showInfoDialog((JDialog)PatchDataContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"patch.main.dialog.generation.report.task.error"));
                }
            }
            catch (InterruptedException e) {
                LOGGER.warn("build report interrupted.");
                DialogUtils.showInfoDialog((JDialog)PatchDataContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"patch.main.dialog.generation.report.task.error"));
            }
            catch (ToolException te) {
                LOGGER.warn("build report exception.");
                DialogUtils.showInfoDialog((JDialog)PatchDataContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"patch.main.dialog.generation.report.task.error"));
            }
            finally {
                PatchDataContext.getInstance().setRunEvaluing(false);
                PatchDataContext.getInstance().getMainDialog().setButtonStatus(false);
            }
        });
    }
}

