/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.logic;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.BizPackage;
import com.huawei.ism.tool.bizpack.IProcessEnvCreator;
import com.huawei.ism.tool.bizpack.IProcessListener;
import com.huawei.ism.tool.bizpack.ProcessInfo;
import com.huawei.ism.tool.bizpack.ProcessInstance;
import com.huawei.ism.tool.bizpack.ProcessInstanceBuilder;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.entity.ExecuteResult;
import com.huawei.ism.tool.devicepatch.entity.PatchInfo;
import com.huawei.ism.tool.devicepatch.entity.PatchUserOpData;
import com.huawei.ism.tool.devicepatch.entity.ProcessingInfo;
import com.huawei.ism.tool.devicepatch.logic.PatchEnvCreator;
import com.huawei.ism.tool.devicepatch.logic.StartPatchProcess;
import com.huawei.ism.tool.devicepatch.service.PatchService;
import com.huawei.ism.tool.devicepatch.utils.DevicePatchUtil;
import com.huawei.ism.tool.devicepatch.utils.ItemProgressUpdateUtil;
import com.huawei.ism.tool.framework.platform.common.data.UserOpTaskResult;
import com.huawei.ism.tool.framework.pubservice.common.devmanage.ISceneEnvironment;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneXmlData;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.PwdException;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.exception.UserStatusException;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.Products;

public class PatchTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(PatchTask.class);
    protected final com.huawei.ism.tool.obase.entity.DevNode node;
    protected final CountDownLatch countDownLatch;
    protected PatchUserOpData userOpData;

    public PatchTask(com.huawei.ism.tool.obase.entity.DevNode node) {
        this(node, null);
    }

    public PatchTask(com.huawei.ism.tool.obase.entity.DevNode node, CountDownLatch countDownLatch) {
        this.node = node;
        this.countDownLatch = countDownLatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName("node-" + this.node.getIp() + "-patch-thread");
        log.info("Start patch task : {}", (Object)this.node.getDeviceSerialNumber());
        try {
            ProcessingInfo info = PatchDataContext.getInstance().getProcessingInfo(this.node);
            info.setTaskRunning(true);
            PatchInfo pinfo = PatchDataContext.getInstance().getPatchInfo(this.node);
            if (null == pinfo) {
                return;
            }
            this.initUserData(pinfo);
            ExecuteResult result = this.getExecuteResult();
            info.addResult(result);
            info.setStatus(DevPatch.DevPatchStatus.RUNNING);
            PatchDataContext.getInstance().uiCallBack(this.node);
            StartPatchProcess pro = new StartPatchProcess(this.node);
            ProcessInfo proInfo = this.buildProcessInfo();
            PatchEnvCreator env = this.buildScriptEnv();
            env.createPkgPathEnv(pinfo.getPatchPath());
            ProcessInstanceBuilder proIns = new ProcessInstanceBuilder();
            proIns.addProcessListener((IProcessListener)pro);
            proIns.setEnvCreator((IProcessEnvCreator)env);
            ProcessInstance pInstance = this.setInstance(result, proInfo, env, proIns);
            if (this.pInstanceIsNull(env, pInstance)) {
                return;
            }
            pInstance.process();
            List<ExecuteResult> results = PatchDataContext.getInstance().getProcessingInfo(this.node).getResults();
            for (ExecuteResult resultItem : results) {
                if (resultItem.isSuccess()) continue;
                info.setStatus(DevPatch.DevPatchStatus.FAILED);
                break;
            }
            boolean taskResult = info.getStatus() != DevPatch.DevPatchStatus.FAILED;
            this.userOpData.setTaskResult(taskResult ? UserOpTaskResult.SUCCESS : UserOpTaskResult.FAILED);
            log.info("Patch the  {} for {} device : {}", new Object[]{pinfo.getPatchPath(), this.node.getIp(), taskResult});
            this.updatePatchVersion(pinfo, taskResult);
            this.endTask(env);
        }
        catch (Exception e) {
            log.error("execute task error.", (Throwable)e);
        }
        finally {
            if (this.countDownLatch != null) {
                this.countDownLatch.countDown();
            }
            ProcessingInfo info = PatchDataContext.getInstance().getProcessingInfo(this.node);
            info.setTaskRunning(false);
        }
    }

    @NotNull
    protected PatchEnvCreator buildScriptEnv() {
        return new PatchEnvCreator(this.node);
    }

    protected ProcessInfo buildProcessInfo() {
        BizPackage bizPkg = PatchService.getInstance().getBizPackage(this.node);
        if (bizPkg == null) {
            throw new IllegalArgumentException("biz package is null for dev: " + this.node.getIp());
        }
        return bizPkg.getProcessInfoByID(this.upgradePatchBranch(this.node.getMatchType()));
    }

    protected void endTask(PatchEnvCreator env) {
        if (PatchDataContext.isNeedOpenOrCloseTlv(this.node)) {
            PatchDataContext.closeTlv(this.node);
        }
        this.closeConnections(env);
        this.doClean();
        ProcessingInfo info = PatchDataContext.getInstance().getProcessingInfo(this.node);
        if (info.getStatus() == DevPatch.DevPatchStatus.COMPLETED) {
            DevicePatchUtil.cleanTempSubPatchPkg(this.node);
        }
    }

    private boolean pInstanceIsNull(PatchEnvCreator env, ProcessInstance pInstance) {
        if (pInstance == null) {
            this.closeConnections(env);
            this.userOpData.setTaskResult(UserOpTaskResult.FAILED);
            this.doClean();
            return true;
        }
        return false;
    }

    private ExecuteResult getExecuteResult() {
        ExecuteResult result = new ExecuteResult(null);
        result.setDescription(ResourceUtil.getString((String)"patch.main.detail.info.createenv"));
        result.setCheckItem(false);
        result.setDevNode(this.node);
        result.setProcess(30);
        return result;
    }

    protected void updatePatchVersion(PatchInfo pinfo, boolean taskResult) {
        if (!"PATCH_EVALU".equals(this.node.getMatchType())) {
            String curVer = null;
            ItemProgressUpdateUtil.INS.clear(this.node.getIp());
            try {
                curVer = PatchService.getInstance().getPatchVersion(this.node);
            }
            catch (ToolException e) {
                log.error("getter PathVersion error.", (Throwable)e);
            }
            pinfo.setCurrentVer(curVer);
            if (taskResult && curVer != null) {
                this.updateProductVersion(this.node, curVer);
            }
            this.updataDevHotPatchVersion(curVer);
        }
    }

    private void updateProductVersion(com.huawei.ism.tool.obase.entity.DevNode node, String sphVersion) {
        String devVersion = node.getProductVersion();
        log.info("dev version is {}, sph version is {}", (Object)devVersion, (Object)sphVersion);
        int index = devVersion.indexOf("SPH");
        int patchIndex = sphVersion.indexOf("SPH");
        if (index != -1 && patchIndex != -1) {
            devVersion = devVersion.replace(devVersion.substring(index), sphVersion.substring(patchIndex));
            node.setProductVersion(devVersion.trim());
            log.info("new dev version is {}", (Object)devVersion);
        }
    }

    public void updataDevHotPatchVersion(String curVer) {
        if (StringUtils.isNULLStr(curVer) || "--".equals(curVer)) {
            return;
        }
        this.node.setHotPatchVersion(curVer);
        List contextDevs = DefaultNodeProviderImpl.getInstance().getNodeList();
        log.info("now try to refresh device data.");
        List devNodesToRefresh = SceneXmlData.getInstance().loadSceneFromFile();
        for (com.huawei.ism.tool.obase.entity.DevNode dev : contextDevs) {
            if (!dev.getDeviceSerialNumber().equalsIgnoreCase(this.node.getDeviceSerialNumber()) || !dev.getIp().equals(this.node.getIp())) continue;
            String currentHotPatchVer = curVer;
            if (this.node.getProductVersion().contains("Kunpeng")) {
                currentHotPatchVer = currentHotPatchVer + " Kunpeng";
            }
            if (Products.isDigitalVer(this.node.getProductVersion())) {
                currentHotPatchVer = curVer;
            }
            dev.setHotPatchVersion(currentHotPatchVer);
            this.updataDevice(dev);
            log.info("updataDevice hotpatch version is {}", (Object)currentHotPatchVer);
            break;
        }
        if (null == devNodesToRefresh) {
            log.error("the devNodesToRefresh is null.");
            return;
        }
        for (DevNode sceneNode : devNodesToRefresh) {
            if (!sceneNode.getDeviceSerialNumber().equalsIgnoreCase(this.node.getDeviceSerialNumber()) || !sceneNode.getIp().equals(this.node.getIp())) continue;
            log.info("refreshing scene device info..");
            sceneNode.setHotPatchVersion(curVer);
        }
        ISceneEnvironment environmentImpl = SceneEnvironmentImpl.getInstance();
        environmentImpl.refreshDevVersion(devNodesToRefresh);
        log.info("successfully refreshed dev scene data.");
    }

    public void updataDevice(com.huawei.ism.tool.obase.entity.DevNode dev) {
        try {
            DefaultNodeProviderImpl.getInstance().modifyDevice(dev);
            log.info("successfully altered device Manager info.");
        }
        catch (Exception e) {
            log.error("modify device product version error. ", (Throwable)e);
        }
    }

    public ProcessInstance setInstance(ExecuteResult result, ProcessInfo proInfo, PatchEnvCreator env, ProcessInstanceBuilder proIns) {
        ProcessInstance pInstance = null;
        try {
            pInstance = proIns.construct(proInfo);
            pInstance.getExecutor().addJythonClassPath(this.buildClassPath());
        }
        catch (PwdException e2) {
            log.error("ssh pwd error.", (Throwable)e2);
            this.taskFailed(result, e2.getErrorMsg());
        }
        catch (UserStatusException e) {
            log.error("tlv pwd error.", (Throwable)e);
            this.taskFailed(result, e.getDes());
        }
        catch (Exception e1) {
            log.error("ssh connection error.", (Throwable)e1);
            ProcessingInfo info = PatchDataContext.getInstance().getProcessingInfo(this.node);
            info.setStatus(DevPatch.DevPatchStatus.FAILED);
            this.taskFailed(result, ResourceUtil.getString((String)"patch.card.showinfo.conerror"));
        }
        return pInstance;
    }

    @NotNull
    protected List<String> buildClassPath() {
        return Collections.singletonList(String.join((CharSequence)File.separator, ApplicationContext.getInstance().getWorkPath(), "packages", "patch", "products", "StorageCommon"));
    }

    private void taskFailed(ExecuteResult result, String errMsg) {
        result.setDeatail(errMsg);
        result.setSuccess(false);
        result.setProcessing(false);
    }

    private String upgradePatchBranch(String branchId) {
        if ("AUTOMATIC".equals(branchId)) {
            return "hotPatchUpgrade";
        }
        if ("PATCH_EVALU".equals(branchId)) {
            return "patchEvaluate";
        }
        return "hotPatchForceUpgrade";
    }

    protected void closeConnections(PatchEnvCreator env) {
        ExecuteResult result = new ExecuteResult(null);
        result.setDescription(ResourceUtil.getString((String)"patch.main.detail.info.clearenv"));
        result.setCheckItem(false);
        result.setDevNode(this.node);
        result.setProcess(90);
        ProcessingInfo info = PatchDataContext.getInstance().getProcessingInfo(this.node);
        info.addResult(result);
        PatchDataContext.getInstance().uiCallBack(this.node);
        env.clearEnv();
        result.setProcessing(false);
    }

    protected void doClean() {
        ProcessingInfo info = PatchDataContext.getInstance().getProcessingInfo(this.node);
        ExecuteResult result = this.buildLastStep();
        result.setCheckItem(false);
        result.setDevNode(this.node);
        result.setProcess(100);
        result.setProcessing(false);
        info.addResult(result);
        PatchDataContext.getInstance().uiCallBack(this.node);
        Map<com.huawei.ism.tool.obase.entity.DevNode, PatchUserOpData> userOpDataMap = PatchDataContext.getInstance().getUserOpDataMap();
        this.userOpData = userOpDataMap.get(this.node);
        this.userOpData.setTaskEndTime(new Date());
        PatchDataContext.getInstance().addUserOpInfoToList(this.userOpData);
    }

    @NotNull
    protected ExecuteResult buildLastStep() {
        ExecuteResult result = new ExecuteResult(null);
        result.setDescription(ResourceUtil.getString((String)"patch.main.detail.info.end"));
        return result;
    }

    protected void initUserData(PatchInfo pinfo) {
        Map<com.huawei.ism.tool.obase.entity.DevNode, PatchUserOpData> userOpDataMap = PatchDataContext.getInstance().getUserOpDataMap();
        if (userOpDataMap.containsKey(this.node)) {
            this.userOpData = userOpDataMap.get(this.node);
        } else {
            this.userOpData = new PatchUserOpData();
            this.userOpData.setDevNode(EntityUtils.toNewDev(this.node));
            this.userOpData.setPatchVersion(pinfo.getVersion());
            userOpDataMap.put(this.node, this.userOpData);
        }
        this.userOpData.setSysPatchVersion(pinfo.getCurrentVer());
        this.userOpData.setTaskStartTime(new Date());
    }
}

