/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.logic;

import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.IProcessListener;
import com.huawei.ism.tool.bizpack.NodeItem;
import com.huawei.ism.tool.bizpack.NodeResult;
import com.huawei.ism.tool.bizpack.ProcessInstance;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.entity.ExecuteResult;
import com.huawei.ism.tool.devicepatch.entity.PatchUserOpData;
import com.huawei.ism.tool.devicepatch.entity.ProcessingInfo;
import com.huawei.ism.tool.devicepatch.utils.ItemProgressUpdateUtil;
import com.huawei.ism.tool.devicepatch.utils.PatchSceneUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.util.Date;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class StartPatchProcess
implements IProcessListener {
    protected DevNode node;
    protected ExecuteResult result;
    private long startStepTime = 0L;
    private long endStepTime = 0L;

    public StartPatchProcess(DevNode node) {
        this.node = node;
    }

    public void afterFinish(ProcessInstance processInstance) {
    }

    public void preStart(ProcessInstance processInstance) {
    }

    public void stepIn(NodeItem stepItem) {
        this.startStepTime = DateUtil.toBeiJingTimeMillis((Date)new Date());
        ProcessingInfo info = PatchDataContext.getInstance().getProcessingInfo(this.node);
        this.result = new ExecuteResult(null);
        this.result.setDevNode(this.node);
        this.result.setDescription(ResourceUtil.getString((String)stepItem.getDescription()));
        this.result.setItemId(stepItem.getId());
        info.addResult(this.result);
        this.result.setProcess(70);
        ItemProgressUpdateUtil.INS.clear(this.node.getIp());
        PatchDataContext.getInstance().uiCallBack(this.node);
    }

    public void stepOut(NodeResult stepResult) {
        LoggerFactory.getLogger(StartPatchProcess.class).info("StartPatch NodeResult : " + stepResult.isSuccess() + " " + stepResult.getDetail());
        if (!PatchSceneUtil.isPatchEvalu() && !stepResult.isSuccess()) {
            ProcessingInfo info = PatchDataContext.getInstance().getProcessingInfo(this.node);
            info.setStatus(DevPatch.DevPatchStatus.FAILED);
        }
        this.result.setResult(stepResult);
        this.result.setProcessing(false);
        this.endStepTime = DateUtil.toBeiJingTimeMillis((Date)new Date());
        this.setOpDatas(stepResult);
    }

    private void setOpDatas(NodeResult stepResult) {
        Map<DevNode, PatchUserOpData> userOpDataMap = PatchDataContext.getInstance().getUserOpDataMap();
        PatchUserOpData userOpData = userOpDataMap.get(this.node);
        String stepDesc = stepResult.getDescription();
        long totalTime = this.endStepTime - this.startStepTime;
        if (stepDesc.contains("precheck")) {
            userOpData.setPrecheckTime(totalTime);
        } else if (stepDesc.contains("upgrade")) {
            userOpData.setUpgradePatchTime(totalTime);
        } else {
            return;
        }
    }
}

