/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.logic;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.NodeItem;
import com.huawei.ism.tool.bizpack.NodeResult;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.entity.ExecuteResult;
import com.huawei.ism.tool.devicepatch.entity.ProcessingInfo;
import com.huawei.ism.tool.devicepatch.logic.StartPatchProcess;
import com.huawei.ism.tool.devicepatch.ui.main.entity.enums.ZoneRunningStatus;
import com.huawei.ism.tool.devicepatch.utils.ItemProgressUpdateUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartRetryPatchProcess
extends StartPatchProcess {
    private static final Logger log = LoggerFactory.getLogger(StartRetryPatchProcess.class);

    public StartRetryPatchProcess(DevNode node) {
        super(node);
    }

    @Override
    public void stepIn(NodeItem stepItem) {
        if (!stepItem.isRetry()) {
            super.stepIn(stepItem);
            return;
        }
        ProcessingInfo info = PatchDataContext.getInstance().getProcessingInfo(this.node);
        Optional<ExecuteResult> retryItemResult = info.getResults().stream().filter(result -> result.getDescription().equals(ResourceUtil.getString((String)stepItem.getDescription()))).findFirst();
        if (!retryItemResult.isPresent()) {
            super.stepIn(stepItem);
            return;
        }
        this.result = retryItemResult.get();
        this.result.setResult(null);
        this.result.setProcess(0);
        this.result.setProcessing(true);
        info.setTaskRunning(true);
        info.setStatus(DevPatch.DevPatchStatus.RUNNING);
        ItemProgressUpdateUtil.INS.clear(this.node.getIp());
        PatchDataContext.getInstance().uiCallBack(this.node);
    }

    @Override
    public void stepOut(NodeResult stepResult) {
        super.stepOut(stepResult);
        ProcessingInfo info = PatchDataContext.getInstance().getProcessingInfo(this.node);
        info.getResults().stream().filter(result -> result.getDescription().equals(ResourceUtil.getString((String)stepResult.getDescription()))).findFirst().ifPresent(this::failSubResult);
    }

    private void failSubResult(ExecuteResult result) {
        List<ExecuteResult> subResults = result.getSubResults();
        if (CollectionUtil.isEmpty(subResults)) {
            return;
        }
        subResults.stream().filter(sub -> ZoneRunningStatus.UPD_UPGRADING.equals((Object)sub.getStatus())).forEach(sub -> sub.setStatus(ZoneRunningStatus.UPD_UPD_FAIL));
    }
}

