/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.logic.config;

import com.huawei.ism.tool.bizpack.wizardparse.factory.SftpConnector;
import com.huawei.ism.tool.bizpack.wizardparse.factory.SshConnector;
import com.huawei.ism.tool.devicepatch.logic.config.RestConnector;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.protocol.factory.SshForwardConnector;

public class ConnectorFactory {
    private static final ConnectorFactory INSTANCE = new ConnectorFactory();

    private ConnectorFactory() {
    }

    public static ConnectorFactory getInstance() {
        return INSTANCE;
    }

    public RestConnector createRestConnector(String uri, String username, String password, String scope) {
        return new RestConnector(uri, username, password, scope);
    }

    public SftpConnector createSftpConnector(String ip, int port, String username, String password) {
        return new SftpConnector(ip, port, username, password);
    }

    public SftpConnector createSftpConnector(DevNode devNode) {
        return new SftpConnector(devNode);
    }

    public SshConnector createSshConnector(String sshHostname, int port, String username, String password) {
        return new SshConnector(sshHostname, port, username, password);
    }

    public SshForwardConnector createSshForwardConnector(DevNode dev) {
        return new SshForwardConnector(EntityUtils.toNewDev(dev));
    }
}

