/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.remote.service;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.entity.ExecuteResult;
import com.huawei.ism.tool.devicepatch.entity.PatchInfo;
import com.huawei.ism.tool.devicepatch.entity.ProcessingInfo;
import com.huawei.ism.tool.devicepatch.logic.BizPackageSupport;
import com.huawei.ism.tool.devicepatch.logic.DevPatchExcelWriter;
import com.huawei.ism.tool.devicepatch.logic.PatchExecutorSupport;
import com.huawei.ism.tool.devicepatch.remote.entity.TaskInfo;
import com.huawei.ism.tool.devicepatch.remote.service.TaskFileParser;
import com.huawei.ism.tool.devicepatch.service.PatchService;
import com.huawei.ism.tool.devicepatch.utils.ItemProgressUpdateUtil;
import com.huawei.ism.tool.framework.init.FrameworkInitiator;
import com.huawei.ism.tool.framework.pubservice.silentprocess.SilentProcessData;
import com.huawei.ism.tool.framework.pubservice.silentprocess.SilentProcessToFile;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotePatchService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemotePatchService.class);

    public void init() {
        this.initService();
        this.initTask();
    }

    private void initService() {
        FrameworkInitiator.init();
        FileUtils.setLogsPermissions();
        new BizPackageSupport().loadBizPackages();
        PatchDataContext.getInstance().setNeedOpenVersions(DevPatchExcelWriter.loadOpenTlvProduct());
    }

    private void initTask() {
        TaskFileParser.parse(TaskInfo.REMOTE_TASK.getTaskFilePath());
    }

    public void execute() {
        List<Future<?>> tasks = this.startPatch();
        this.waitExecute(tasks);
    }

    private void waitExecute(List<Future<?>> tasks) {
        for (Future<?> task : tasks) {
            try {
                task.get();
            }
            catch (Exception e) {
                LOGGER.error("Task execute error.", (Throwable)e);
            }
        }
        SilentProcessData pro = TaskInfo.REMOTE_TASK.getTotalProgress();
        pro.setProcess("100");
        pro.setStatus("finished");
        Collection<SilentProcessData> devPros = TaskInfo.REMOTE_TASK.getProcessInfoMap().values();
        boolean success = true;
        for (SilentProcessData devPro : devPros) {
            if (!"failed".equals(devPro.getResult())) continue;
            success = false;
        }
        pro.setResult(success ? "success" : "failed");
        SilentProcessToFile.updateProcessData((SilentProcessData)pro, (String)TaskInfo.REMOTE_TASK.getWorkPath());
    }

    public List<Future<?>> startPatch() {
        List<DevPatch> devPatchList = this.buildDevPatch();
        this.checkPatch(devPatchList);
        PatchDataContext context = PatchDataContext.getInstance();
        List<DevPatch> devPatchs = context.getDevPatchs();
        ArrayList tasks = new ArrayList();
        for (DevPatch devPatch : devPatchs) {
            DevNode node = null;
            try {
                node = devPatch.getDevNode().get(0);
                this.setPatchVersion(node, devPatch.getBatchInfo());
                ProcessingInfo info = PatchDataContext.getInstance().getProcessingInfo(node);
                info.clear();
                ExecuteResult result = new ExecuteResult(null);
                result.setDescription(ResourceUtil.getString((String)"patch.main.detail.info.start"));
                result.setDevNode(node);
                result.setProcess(10);
                info.setStatus(DevPatch.DevPatchStatus.WAITING);
                info.addResult(result);
                ItemProgressUpdateUtil.INS.clear(node.getIp());
                PatchDataContext.getInstance().uiCallBack(node);
                Future<?> task = PatchExecutorSupport.getInstance().submitPatchJob(node);
                tasks.add(task);
            }
            catch (Throwable t) {
                LOGGER.error("Execut patch task error. " + node);
            }
        }
        return tasks;
    }

    private void setPatchVersion(DevNode devNode, PatchInfo pInfo) {
        try {
            String curPatchVer = PatchService.getInstance().getPatchVersion(devNode);
            devNode.setHotPatchVersion(curPatchVer);
            pInfo.setCurrentVer(curPatchVer);
        }
        catch (Exception e) {
            LOGGER.error("query patch version exception.", (Throwable)e);
        }
    }

    private void checkPatch(List<DevPatch> devPatchList) {
        PatchDataContext context = PatchDataContext.getInstance();
        for (DevPatch devPatch : devPatchList) {
            DevNode node = devPatch.getDevNode().get(0);
            boolean result = PatchService.getInstance().checkLinkagePatch(devPatch.getBatchInfo().getPatchPath(), devPatch.getBatchInfo(), node);
            LOGGER.info("Parse patch result : {} node \uff1a {}", (Object)result, (Object)node);
            if (!result) continue;
            context.getDevPatchs().add(devPatch);
            context.getProcessingInfo(node).setStatus(DevPatch.DevPatchStatus.ASSOCIATED);
        }
    }

    private List<DevPatch> buildDevPatch() {
        List<DevNode> nodeList = TaskInfo.REMOTE_TASK.getNodeList();
        Map<String, String> mappingInfo = TaskInfo.REMOTE_TASK.getPatchInfo();
        Set<String> deviceSNs = mappingInfo.keySet();
        ArrayList<DevPatch> devPatchList = new ArrayList<DevPatch>();
        for (String sn : deviceSNs) {
            for (DevNode devNode : nodeList) {
                if (!devNode.getDeviceSerialNumber().equals(sn)) continue;
                DevPatch devPatch = new DevPatch();
                PatchInfo info = new PatchInfo("");
                info.setPatchPath(mappingInfo.get(sn));
                devPatch.setBatchInfo(info);
                devPatch.getDevNode().add(devNode);
                devPatchList.add(devPatch);
            }
        }
        return devPatchList;
    }
}

