/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.remote.service;

import com.huawei.common.devmgr.DeviceLocator;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.devicepatch.DevicePatchProvicer4EService;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.remote.entity.TaskInfo;
import com.huawei.ism.tool.devicepatch.remote.utils.ProgressUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.silentprocess.SilentProcessData;
import com.huawei.ism.tool.framework.pubservice.silentprocess.SilentProcessToFile;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.PriKeyInfo;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.NetUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TaskFileParser {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(TaskFileParser.class);
    private static final String WORKPATHEXP = "//workPath";
    private static final String LANGUAGEEXP = "//language";
    private static final String DEVICEEXP = "//device";
    private static final String PARAMEXP = "//param";

    public static void parse(String taskFilePath) {
        File taskFile = new File(FilePathUtils.getSafePath((String)taskFilePath));
        if (!taskFile.exists()) {
            LOGGER.error("Task file : '" + taskFile + "' is not exists! task failed");
            DevicePatchProvicer4EService.exitTask(-1);
        }
        try {
            Document doc = XmlUtils.parseDocument((InputStream)new FileInputStream(taskFile));
            NodeList nodeList = XmlUtils.searchNodeByExp((Document)doc, (String)WORKPATHEXP);
            String workPath = TaskFileParser.getFirstTextContent(nodeList);
            TaskInfo.REMOTE_TASK.setWorkPath(workPath);
            ProgressUtil.initProgress(workPath);
            nodeList = XmlUtils.searchNodeByExp((Document)doc, (String)LANGUAGEEXP);
            String language = TaskFileParser.getFirstTextContent(nodeList);
            ApplicationContext.getInstance().setCurrentLanguage("en".equals(language) ? Locale.ENGLISH : Locale.SIMPLIFIED_CHINESE);
            nodeList = XmlUtils.searchNodeByExp((Document)doc, (String)DEVICEEXP);
            List<DevNode> devNodes = TaskFileParser.parseNodeInfo(nodeList);
            TaskFileParser.devNodeCheck(devNodes);
            nodeList = XmlUtils.searchNodeByExp((Document)doc, (String)PARAMEXP);
            Map<String, String> patchInfoMap = TaskFileParser.parsePatchInfo(nodeList);
            TaskFileParser.patchInfoCheck(patchInfoMap);
            TaskInfo.REMOTE_TASK.setPatchInfo(patchInfoMap);
        }
        catch (Exception e) {
            LOGGER.error("Task file parse error.", (Throwable)e);
            boolean delete = taskFile.delete();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("delete taskFile result : " + delete);
            }
            DevicePatchProvicer4EService.exitTask(-1);
        }
        boolean delete = taskFile.delete();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("delete taskFile result : " + delete);
        }
    }

    private static void patchInfoCheck(Map<String, String> mappingMap) {
        if (null == mappingMap || mappingMap.isEmpty()) {
            LOGGER.error("Patch mapping is empty.");
            ProgressUtil.updateTotalProgress("100", ResourceUtil.getString((String)"patch.remote.parse.err3"), "finished", "failed");
            throw new NullPointerException(ResourceUtil.getString((String)"patch.remote.parse.err3"));
        }
    }

    private static Map<String, String> parsePatchInfo(NodeList nodeList) {
        if (null == nodeList) {
            return null;
        }
        HashMap<String, String> patchInfo = new HashMap<String, String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            String deviceSN = e.getAttribute("key");
            String patchPath = e.getAttribute("value");
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Parse mapping info : " + deviceSN + " patch path : " + patchPath);
            }
            patchInfo.put(deviceSN, patchPath);
        }
        return patchInfo;
    }

    private static void devNodeCheck(List<DevNode> devNodes) {
        if (null == devNodes || devNodes.isEmpty()) {
            ProgressUtil.updateTotalProgress("100", ResourceUtil.getString((String)"patch.remote.parse.err1"), "finished", "failed");
            throw new NullPointerException(ResourceUtil.getString((String)"patch.remote.parse.err1"));
        }
        ArrayList<SilentProcessData> pros = new ArrayList<SilentProcessData>();
        for (DevNode devNode : devNodes) {
            if (!PatchDataContext.getInstance().isSupportDev(devNode)) {
                SilentProcessData pro = TaskInfo.REMOTE_TASK.getProcessData(devNode.getDeviceSerialNumber());
                pro.setDevNode(EntityUtils.toNewDev(devNode));
                pro.setProcess("100");
                pro.setErrMsg(ResourceUtil.getString((String)"patch.remote.parse.err2"));
                pro.setStatus("finished");
                pro.setResult("failed");
                pros.add(pro);
                continue;
            }
            TaskInfo.REMOTE_TASK.getNodeList().add(devNode);
        }
        SilentProcessToFile.updateDeviceData(pros, (String)TaskInfo.REMOTE_TASK.getWorkPath());
    }

    private static List<DevNode> parseNodeInfo(NodeList nodeList) {
        if (null == nodeList) {
            return null;
        }
        ArrayList<DevNode> devList = new ArrayList<DevNode>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element e;
            DevNode devNode;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || null == (devNode = TaskFileParser.buildDevNode(e = (Element)node))) continue;
            DeviceLocator.addOrMdyDev((com.huawei.ism.tool.framework.pubservice.entity.DevNode)EntityUtils.toNewDev(devNode));
            devList.add(devNode);
        }
        return devList;
    }

    private static DevNode buildDevNode(Element element) {
        String innerIps;
        DevNode devNode = new DevNode();
        devNode.setPort(Integer.parseInt(element.getAttribute("port")));
        devNode.setIp(TaskFileParser.resetDevIp(element.getAttribute("devIP"), devNode.getPort()));
        devNode.setProductVersion(element.getAttribute("devVersion"));
        devNode.setDeveloperPwd(AESEncrypt.decrypt((String)element.getAttribute("developerPwd")));
        devNode.setDeviceName(element.getAttribute("deviceName"));
        devNode.setDeviceSerialNumber(element.getAttribute("serialNo"));
        devNode.setDeviceType(DeviceType.valueOf(element.getAttribute("deviceType")));
        String userName = element.getAttribute("username");
        String password = element.getAttribute("password");
        devNode.setSshHostKey(AESEncrypt.decrypt((String)element.getAttribute("sshHostKey")));
        devNode.setVerifySshHostKey(Boolean.valueOf(AESEncrypt.decrypt((String)element.getAttribute("isVerifySshHostKey"))));
        User user = new User(AESEncrypt.decrypt((String)userName), AESEncrypt.decrypt((String)password));
        devNode.setLoginUser(user);
        devNode.setVerifyCertificate(Boolean.parseBoolean(AESEncrypt.decrypt((String)element.getAttribute("isVerifyCert"))));
        String publicKeyPath = element.getAttribute("publicKeyPath");
        if (!StringUtils.isNULLStr((String)publicKeyPath)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Parse publicKeyPath : " + publicKeyPath);
            }
            PriKeyInfo priKey = new PriKeyInfo();
            priKey.setKeyPath(AESEncrypt.decrypt((String)publicKeyPath));
            priKey.setKeyPwd(AESEncrypt.decrypt((String)element.getAttribute("publicKeyPwd")));
            devNode.setPriKey(priKey);
        }
        if (!StringUtils.isNULLStr((String)(innerIps = element.getAttribute("devInnerIP")))) {
            String[] innerIpArr;
            devNode.setIpListAreInnerIp(true);
            for (String innerIp : innerIpArr = innerIps.split(";")) {
                devNode.addIp(innerIp);
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Device " + devNode.getIp() + " set innerIp : " + devNode.getIpList());
            }
        }
        boolean initResult = ProgressUtil.initDevProgress(devNode);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Parse devnode info :" + devNode + " init progress : " + initResult);
        }
        if (StringUtils.isNULLStr((String)password)) {
            ProgressUtil.updateDevFailedMsg(devNode, ResourceUtil.getString((String)"patch.remote.parse.err4"));
            LOGGER.error("device password is empty.");
            return null;
        }
        return devNode;
    }

    private static String resetDevIp(String ipStr, int port) {
        if (StringUtils.isNULLStr((String)ipStr)) {
            return "";
        }
        String[] ips = ipStr.split(";");
        if (ips.length > 1) {
            for (String ip : ips) {
                if (!NetUtil.isPortCanReach(ip, port, 1000)) continue;
                return ip;
            }
        }
        return ipStr;
    }

    private static String getFirstTextContent(NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            return e.getTextContent();
        }
        LOGGER.info("Can not find text content.");
        return "";
    }
}

