/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.remote.utils;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.entity.ExecuteResult;
import com.huawei.ism.tool.devicepatch.entity.ProcessingInfo;
import com.huawei.ism.tool.devicepatch.remote.entity.TaskInfo;
import com.huawei.ism.tool.framework.pubservice.silentprocess.ProcessItem;
import com.huawei.ism.tool.framework.pubservice.silentprocess.SilentProcessData;
import com.huawei.ism.tool.framework.pubservice.silentprocess.SilentProcessToFile;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProgressUtil.class);
    private static final int MIN_PRO = 0;
    private static final int MAX_PRO = 100;

    public static void initProgress(String workPath) {
        File workPathFile = new File(workPath);
        if (!workPathFile.exists() && LOGGER.isInfoEnabled()) {
            LOGGER.info("Make workPath : " + workPath + " result : " + workPathFile.mkdirs());
        }
        SilentProcessData totalProgress = TaskInfo.REMOTE_TASK.getTotalProgress();
        totalProgress.setStatus("running");
        SilentProcessToFile.createProgressData((SilentProcessData)totalProgress, (String)workPath);
    }

    public static void updateTotalProgress(String progress, String errMsg, String status, String result) {
        SilentProcessData pro = TaskInfo.REMOTE_TASK.getTotalProgress();
        pro.setProcess(progress);
        pro.setErrMsg(errMsg);
        pro.setStatus(status);
        pro.setResult(result);
        LOGGER.info(pro.toString());
        SilentProcessToFile.updateProcessData((SilentProcessData)pro, (String)TaskInfo.REMOTE_TASK.getWorkPath());
    }

    public static void updateDevProgress(SilentProcessData pro, String path, String progress, String errMsg, String status, String result) {
        pro.setProcess(progress);
        pro.setErrMsg(errMsg);
        pro.setStatus(status);
        pro.setResult(result);
        LOGGER.info(pro.toString());
        SilentProcessToFile.updateDeviceData((SilentProcessData)pro, (String)path);
        ProgressUtil.updateTotalProgress();
    }

    public static void updateDevFailedMsg(DevNode node, String msg) {
        SilentProcessData pro = TaskInfo.REMOTE_TASK.getProcessData(node.getDeviceSerialNumber());
        ProgressUtil.updateDevFailedMsg(pro, msg);
    }

    public static void updateDevFailedMsg(SilentProcessData pro, String errMsg) {
        pro.setProcess("100");
        pro.setStatus("finished");
        pro.setResult("failed");
        pro.setErrMsg(errMsg);
        LOGGER.info(pro.toString());
        SilentProcessToFile.updateDeviceData((SilentProcessData)pro, (String)TaskInfo.REMOTE_TASK.getWorkPath());
        ProgressUtil.updateTotalProgress();
    }

    public static boolean initDevProgress(DevNode node) {
        SilentProcessData pro = TaskInfo.REMOTE_TASK.getProcessData(node.getDeviceSerialNumber());
        pro.setDevNode(EntityUtils.toNewDev(node));
        pro.setStatus("waiting");
        LOGGER.info(pro.toString());
        return SilentProcessToFile.updateDeviceData((SilentProcessData)pro, (String)TaskInfo.REMOTE_TASK.getWorkPath());
    }

    private static String getReturnData(DevNode node, List<ExecuteResult> results) {
        if (null == results) {
            return "";
        }
        JSONArray resultArray = new JSONArray();
        for (ExecuteResult r : results) {
            ProcessItem pItem = new ProcessItem();
            pItem.setItemName(r.getDescription());
            pItem.setNodeIp(node.getIp());
            if (r.isProcessing()) {
                pItem.setCheckResult("RUNNING");
                pItem.setCheckResultDetail(ResourceUtil.getString((String)"patch.main.table.status.running"));
            } else if (r.isSuccess()) {
                pItem.setCheckResult("SUCCESS");
                pItem.setCheckResultDetail(ResourceUtil.getString((String)"patch.main.table.status.completed"));
            } else {
                pItem.setCheckResult("FAILED");
                pItem.setCheckResultDetail(ResourceUtil.getString((String)"patch.main.table.status.failed"));
            }
            pItem.setExcuteTime(r.getStartDateString());
            pItem.setProgress(String.valueOf(r.getCurProgress()));
            pItem.setDetail(r.getDetail());
            resultArray.put((Object)pItem);
        }
        JSONObject json = new JSONObject();
        json.put("detail", (Object)resultArray);
        return json.toString();
    }

    public static void updateDevProgress(DevNode node) {
        SilentProcessData pro = TaskInfo.REMOTE_TASK.getProcessData(node.getDeviceSerialNumber());
        ProcessingInfo info = PatchDataContext.getInstance().getProcessingInfo(node);
        int totalProgress = info.getTotalProcess();
        if (!ProgressUtil.checkProgress(totalProgress)) {
            LOGGER.error("Illegal progress : " + totalProgress);
            return;
        }
        pro.setProcess(String.valueOf(totalProgress));
        if (DevPatch.DevPatchStatus.FAILED.equals((Object)info.getStatus())) {
            pro.setResult("failed");
            pro.setStatus("finished");
            JSONObject errMsg = TaskInfo.REMOTE_TASK.getAbnormalNodeMap().get(node);
            pro.setErrMsg(null != errMsg ? errMsg.toString() : "");
        } else if (DevPatch.DevPatchStatus.COMPLETED.equals((Object)info.getStatus())) {
            pro.setResult("success");
            pro.setStatus("finished");
        } else if (DevPatch.DevPatchStatus.WAITING.equals((Object)info.getStatus())) {
            pro.setStatus("waiting");
        } else {
            pro.setStatus("running");
        }
        pro.setReturnData(ProgressUtil.getReturnData(node, info.getResults()));
        LOGGER.info("process info:{}", (Object)pro.toString());
        SilentProcessToFile.updateDeviceData((SilentProcessData)pro, (String)TaskInfo.REMOTE_TASK.getWorkPath());
        ProgressUtil.updateTotalProgress();
    }

    public static void updateTotalProgress() {
        try {
            Map<String, SilentProcessData> prosMap = TaskInfo.REMOTE_TASK.getProcessInfoMap();
            Collection<SilentProcessData> pros = prosMap.values();
            if (prosMap.isEmpty()) {
                LOGGER.info("pro map is empty.");
                return;
            }
            int totalProgressCount = 0;
            for (SilentProcessData pro : pros) {
                totalProgressCount += Integer.valueOf(pro.getProcess()).intValue();
            }
            int totalProgress = totalProgressCount / pros.size();
            if (!ProgressUtil.checkProgress(totalProgress)) {
                LOGGER.error("Illegal progress : " + totalProgress);
                return;
            }
            SilentProcessData totalPor = TaskInfo.REMOTE_TASK.getTotalProgress();
            totalPor.setProcess(String.valueOf(totalProgress));
            LOGGER.info(totalPor.toString());
            SilentProcessToFile.updateProcessData((SilentProcessData)totalPor, (String)TaskInfo.REMOTE_TASK.getWorkPath());
        }
        catch (Exception e) {
            LOGGER.error("Update total progress failed.", (Throwable)e);
        }
    }

    private static boolean checkProgress(int progress) {
        return progress >= 0 && progress <= 100;
    }
}

