/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.report;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.entity.ExecuteResult;
import com.huawei.ism.tool.devicepatch.entity.PatchInfo;
import com.huawei.ism.tool.devicepatch.entity.SummaryEntity;
import com.huawei.ism.tool.devicepatch.report.HtmlResUtils;
import com.huawei.ism.tool.devicepatch.report.TemplateFactory;
import com.huawei.ism.tool.devicepatch.report.ZTreeNode;
import com.huawei.ism.tool.devicepatch.utils.DevicePatchUtil;
import com.huawei.ism.tool.devicepatch.utils.PatchSceneUtil;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.IniResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.json.JSONArray;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchEvaluReportBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PatchEvaluReportBuilder.class);
    public static final String REPORT_TEMP = Paths.get(ApplicationContext.getInstance().getTmpPath(), "report").toString();
    private static final String RES_PATH = Paths.get(ApplicationContext.getInstance().getPackagesPath(), "html").toString();
    private static final String REPORT_HEAD_PATH = Paths.get(REPORT_TEMP, "head").toString();
    private static final String REPORT_NODES_PATH = Paths.get(REPORT_TEMP, "nodes").toString();
    private static final String REPORT_NAME = "PatchEvaluReport_%s.zip";

    public boolean buildReport(List<DevNode> devNodes) throws ToolException {
        LOGGER.info("Start build report.");
        this.init();
        this.buildIndex(REPORT_TEMP);
        this.buildCover(REPORT_HEAD_PATH);
        this.buildLeftTree(devNodes, REPORT_HEAD_PATH);
        this.buildSummary(devNodes, REPORT_HEAD_PATH);
        this.buildNodesDetail(devNodes);
        this.compressReport();
        return true;
    }

    private void init() {
        FileUtils.clearDir((String)REPORT_TEMP);
        String resTempPath = Paths.get(REPORT_TEMP, "res").toString();
        FileUtils.copyDir((String)RES_PATH, (String)resTempPath);
        IniResourceUtil.loadPyRes("cbb/res/patch", "resource");
        IniResourceUtil.loadPyRes("cbb/res/upgrade", "resource");
        IniResourceUtil.loadPyRes("cbb/res/upgrade", "resource_dorado");
    }

    private void buildIndex(String targetPath) {
        String fileName = "index.html";
        TemplateFactory.processorFtl(fileName, null, targetPath + File.separator + fileName);
    }

    private void buildCover(String targetPath) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("tool_version", UserOpDataSaveUtil.getToolIniProp((String)"tool.version"));
        data.put("date", UserOpDataSaveUtil.getToolIniProp((String)"date"));
        String toolboxVer = UserOpDataSaveUtil.getToolBoxIniProp((String)"app.version");
        data.put("toolbox_version", toolboxVer == null ? "--" : toolboxVer);
        data.put("release_date", ApplicationContext.getInstance().getReleaseDate());
        data.put("generation_time", StringUtils.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss 'GMT'Z"));
        String fileName = "cover.html";
        TemplateFactory.processorFtl(fileName, data, targetPath + File.separator + fileName);
    }

    private void buildLeftTree(List<DevNode> devNodes, String targetPath) {
        String fileName = "indexTree.html";
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("treeNodes", this.buildIndexTreeStr(devNodes));
        TemplateFactory.processorFtl(fileName, data, targetPath + File.separator + fileName);
    }

    private String buildIndexTreeStr(List<DevNode> devNodes) {
        JSONArray zTreeJsonStr = new JSONArray();
        ZTreeNode coverNode = new ZTreeNode(HtmlResUtils.getString("indexTree.cover")).setUrl("cover.html");
        ZTreeNode summaryNode = new ZTreeNode(HtmlResUtils.getString("indexTree.summary")).setUrl("summary.html");
        ZTreeNode detailNode = new ZTreeNode(HtmlResUtils.getString("indexTree.detail")).setParent(true).setOpen(true);
        devNodes.stream().map(this::buildDevNodeIndex).forEach(detailNode::addChildren);
        zTreeJsonStr.put((Object)coverNode).put((Object)summaryNode).put((Object)detailNode);
        return zTreeJsonStr.toString();
    }

    private ZTreeNode buildDevNodeIndex(DevNode node) {
        String htmlIndex = node.getIp() + "_" + node.getDeviceSerialNumber();
        return new ZTreeNode(HtmlResUtils.getStringWithParam("indexTree.node.detail", htmlIndex)).setUrl(String.format(Locale.ENGLISH, "../nodes/%s/index.html", node.getDeviceSerialNumber()));
    }

    private void buildSummary(List<DevNode> devNodes, String targetPath) {
        String fileName = "summary.html";
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<SummaryEntity> summaryEntities = new ArrayList<SummaryEntity>();
        for (DevNode devNode : devNodes) {
            SummaryEntity summary = new SummaryEntity();
            summary.setDev(devNode);
            summary.setA800Name(DevicePatchUtil.getA800Name(devNode.getDeviceSerialNumber()));
            summary.setPatchStatus(PatchDataContext.getInstance().getProcessingInfo(devNode).getStatus());
            summary.setTargetVersion(this.getPatchTargetVerison(devNode));
            LOGGER.info("current hot patch version:{}", (Object)devNode.getHotPatchVersion());
            summary.setCurrentVerson(devNode.getHotPatchVersion());
            summaryEntities.add(summary);
        }
        data.put("summaryData", summaryEntities);
        data.put("isA800PatchEval", PatchSceneUtil.isA800PatchEval());
        TemplateFactory.processorFtl(fileName, data, targetPath + File.separator + fileName);
    }

    private String getPatchTargetVerison(DevNode devNode) {
        return this.getMatchedDevPatchFromContext(devNode).map(DevPatch::getBatchInfo).map(PatchInfo::getVersion).orElse("");
    }

    @NotNull
    private Optional<DevPatch> getMatchedDevPatchFromContext(DevNode devNode) {
        return PatchDataContext.getInstance().getDevPatchs().stream().filter(devPatch -> devPatch.isSelectDevMatchedDevPatch(devNode)).findAny();
    }

    private void buildNodesDetail(List<DevNode> deployNodes) {
        deployNodes.forEach(node -> this.buildNodeDetail((DevNode)node, Paths.get(REPORT_NODES_PATH, node.getDeviceSerialNumber()).toString()));
    }

    private void buildNodeDetail(DevNode node, String targetPath) {
        String htmlIndex = node.getIp() + "_" + node.getDeviceSerialNumber();
        String fileName = "detailView.html";
        HashMap<String, Object> data = new HashMap<String, Object>();
        List<ExecuteResult> results = PatchDataContext.getInstance().getProcessingInfo(node).getResults();
        data.put("allItems", results);
        data.put("nodeTitle", HtmlResUtils.getStringWithParam("report.detail.title", htmlIndex));
        TemplateFactory.processorFtl(fileName, data, targetPath + File.separator + "index.html");
    }

    private void compressReport() throws ToolException {
        String targetDir;
        String fileName = String.format(Locale.ENGLISH, REPORT_NAME, StringUtils.formatDate(new Date(), "yyyyMMddHHmmss"));
        try {
            targetDir = PatchDataContext.getInstance().getReportDir().getCanonicalPath();
        }
        catch (IOException e) {
            throw new ToolException("Get report dir exception.");
        }
        String targetReportPath = Paths.get(targetDir, fileName).toString();
        ZipUtils.compressFile((String)targetReportPath, (String)REPORT_TEMP);
        FileUtils.setFilePermissions((String)targetReportPath);
    }
}

