/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.service;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.entity.ExecuteResult;
import com.huawei.ism.tool.devicepatch.entity.ProcessingInfo;
import com.huawei.ism.tool.devicepatch.logic.PatchExecutorSupport;
import com.huawei.ism.tool.devicepatch.ui.main.entity.enums.ZoneRunningStatus;
import com.huawei.ism.tool.devicepatch.utils.DevicePatchUtil;
import com.huawei.ism.tool.devicepatch.utils.ItemProgressUpdateUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class A800RetryPatchService {
    private static final Logger log = LoggerFactory.getLogger(A800RetryPatchService.class);

    public void startRetry(DevNode node, @NotNull List<String> zoneIds, @NotNull String itemId) throws ToolException {
        ProcessingInfo info = PatchDataContext.getInstance().getProcessingInfo(node);
        Optional<ExecuteResult> retryItem = info.getResults().stream().filter(result -> itemId.equals(result.getDescription())).findFirst();
        if (!retryItem.isPresent()) {
            log.error("not step cant be retry");
            throw new ToolException(ResourceUtil.getString((String)"not.step.cant.be.retry"), false);
        }
        ExecuteResult result2 = retryItem.get();
        this.initSubResult(zoneIds, result2);
        result2.setProcess(10);
        info.setStatus(DevPatch.DevPatchStatus.WAITING);
        ItemProgressUpdateUtil.INS.clear(node.getIp());
        PatchDataContext.getInstance().uiCallBack(DevicePatchUtil.transToShowNode(node));
        PatchExecutorSupport.getInstance().addRetryPatchJob(node, zoneIds, itemId);
    }

    private void initSubResult(@NotNull List<String> zoneIds, ExecuteResult result) {
        if (CollectionUtil.isEmpty(result.getSubResults())) {
            return;
        }
        result.getSubResults().stream().filter(sub -> zoneIds.contains(sub.getDevNode().getUuid())).forEach(this::initStatus);
    }

    private void initStatus(ExecuteResult result) {
        result.setProcessing(true);
        result.setStatus(ZoneRunningStatus.UPD_UPGRADING);
        result.setProcess(0);
    }
}

