/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.service;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.entity.PatchInfo;
import com.huawei.ism.tool.devicepatch.service.PatchService;
import com.huawei.ism.tool.devicepatch.utils.DevicePatchUtil;
import com.huawei.ism.tool.devicepatch.utils.PatchSceneUtil;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.PwdCLIOverrunException;
import com.huawei.ism.tool.obase.exception.PwdException;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CliResolverUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.exception.UserStatusException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.Products;

public class CheckPatchInfo
implements Callable<List<ArrayList<Object>>> {
    private static final Logger log = LoggerFactory.getLogger(CheckPatchInfo.class);
    private List<DevNode> nodes;

    public CheckPatchInfo(List<DevNode> nodes) {
        this.nodes = nodes;
    }

    @Override
    public List<ArrayList<Object>> call() {
        HashMap<PatchInfo, List<DevNode>> infoMap = new HashMap<PatchInfo, List<DevNode>>();
        HashMap<Object, List<DevNode>> failsNodes = new HashMap<Object, List<DevNode>>();
        String exist = ResourceUtil.getString((String)"patch.card.showinfo.exist");
        ArrayList<ArrayList<Object>> failRet = new ArrayList<ArrayList<Object>>();
        for (DevNode devNode : this.nodes) {
            List<DevNode> devs = PatchDataContext.getInstance().getDevNodes();
            if (devs.contains(devNode)) {
                failsNodes.computeIfAbsent(exist, k -> new ArrayList());
                ((List)failsNodes.get(exist)).add(devNode);
                continue;
            }
            if (!this.versionConsistencyCheck(failRet, devNode).booleanValue() || this.checkSuperAdminUserRole(failRet, devNode)) continue;
            Object result = this.checkBatch(failRet, devNode);
            this.handlePatchInfo(infoMap, failsNodes, devNode, result);
        }
        for (Map.Entry entry : failsNodes.entrySet()) {
            this.addFailRet(failRet, entry);
        }
        ArrayList<DevPatch> dps = new ArrayList<DevPatch>();
        Iterator<Map.Entry<PatchInfo, List<DevNode>>> iterator = infoMap.entrySet().iterator();
        while (iterator.hasNext()) {
            this.addDevPatch(dps, iterator);
        }
        PatchDataContext.getInstance().setTmpDevPatchs(dps);
        if (PatchSceneUtil.isA800HotPatch()) {
            PatchDataContext.getInstance().setTmpDevPatchsBranch(dps);
        }
        return failRet;
    }

    @Nullable
    private Object checkBatch(List<ArrayList<Object>> failRet, DevNode node) {
        Object result = null;
        try {
            result = PatchService.getInstance().checkBatch(node);
        }
        catch (PwdException pwdException) {
            this.addFailRet(failRet, node, pwdException);
        }
        catch (ToolException e) {
            if (e.getCause() instanceof UserStatusException) {
                UserStatusException userStatusException = (UserStatusException)e.getCause();
                this.addFailRet(failRet, node, userStatusException);
            }
            log.error("check patch Info error", (Throwable)e);
        }
        return result;
    }

    private void addFailRet(List<ArrayList<Object>> failRet, DevNode node, UserStatusException userStatusException) {
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add(node.getIp());
        tmp.add(userStatusException.getDes());
        failRet.add(tmp);
    }

    private void addFailRet(List<ArrayList<Object>> failRet, DevNode node, PwdException pwdException) {
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add(node.getIp());
        tmp.add(pwdException.getErrorMsg());
        failRet.add(tmp);
    }

    private void addDevPatch(List<DevPatch> dps, Iterator<Map.Entry<PatchInfo, List<DevNode>>> iter) {
        Map.Entry<PatchInfo, List<DevNode>> entry = iter.next();
        DevPatch dp = new DevPatch();
        dp.setBatchInfo(entry.getKey());
        dp.setDevNode(entry.getValue());
        dps.add(dp);
    }

    private void addFailRet(List<ArrayList<Object>> failRet, Map.Entry<Object, List<DevNode>> entry) {
        for (DevNode dev : entry.getValue()) {
            ArrayList<Object> tmp = new ArrayList<Object>();
            tmp.add(dev.getIp());
            tmp.add(entry.getKey());
            failRet.add(tmp);
        }
    }

    private boolean checkSuperAdminUserRole(List<ArrayList<Object>> failRet, DevNode node) {
        if (!CliResolverUtils.checkSuperAdminUserRole(DevicePatchUtil.transToRequestNode(node))) {
            log.info("the login user is not super admin user.");
            this.getFailedResult(failRet, node, "patch.card.showinfo.conerror");
            return true;
        }
        return false;
    }

    private void handlePatchInfo(Map<PatchInfo, List<DevNode>> infoMap, Map<Object, List<DevNode>> failsNodes, DevNode node, Object patch) {
        if (Objects.isNull(patch)) {
            return;
        }
        if (patch instanceof PatchInfo) {
            PatchInfo info = (PatchInfo)patch;
            log.info("get patchinfo : " + info.getVersion());
            infoMap.computeIfAbsent(info, k -> new ArrayList());
            infoMap.get(info).add(node);
            PatchDataContext.getInstance().removeProcessingInfo(node);
        } else {
            failsNodes.computeIfAbsent(patch, k -> new ArrayList());
            failsNodes.get(patch).add(node);
            log.info("get patchinfo error : {}", patch);
        }
    }

    private void getFailedResult(List<ArrayList<Object>> failRet, DevNode node, String errMsg) {
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add(node.getIp());
        tmp.add(ResourceUtil.getString((String)errMsg));
        failRet.add(tmp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Boolean versionConsistencyCheck(List<ArrayList<Object>> failRet, DevNode dev) {
        ICliConnection con;
        block10: {
            Boolean bl;
            Boolean bl2;
            String cliResult;
            DevNode zoneNode;
            block9: {
                con = null;
                zoneNode = DevicePatchUtil.transToRequestNode(dev);
                con = SshConnectionManager.getSshConnection(zoneNode, null, true, true);
                String queryHyperMetroCmd = "show upgrade package";
                cliResult = con.execCmdWithTimout(queryHyperMetroCmd, 15);
                cliResult = Normalizer.normalize(cliResult, Normalizer.Form.NFKC);
                if (!StringUtils.isNULLStr(cliResult) && cliResult.contains("Software Version") && !cliResult.contains("not exist")) break block9;
                log.info("execute cmd failed.");
                Boolean bl3 = true;
                SshConnectionManager.releaseConnection(con);
                return bl3;
            }
            try {
                String[] resultList = cliResult.split("HotPatch Version");
                String softwareVersionResult = resultList[0].replace("Software Version", "");
                List<Map<String, String>> mapList = CliResolverUtils.resloveCliRetToList(softwareVersionResult);
                String currentVersion = mapList.get(0).get("Current Version");
                String devVersion = zoneNode.getProductVersion();
                if (devVersion.contains("Kunpeng")) {
                    devVersion = devVersion.replace("Kunpeng", "").trim();
                }
                if (Products.isDigitalVer(devVersion) && devVersion.contains("SPH")) {
                    String tmpVersion = devVersion.split("SPH")[0];
                    devVersion = tmpVersion.substring(0, tmpVersion.lastIndexOf("."));
                }
                log.info("mem_Version:{},act_version:{}", (Object)devVersion, (Object)currentVersion);
                if (devVersion.equals(currentVersion)) break block10;
                this.getFailedResult(failRet, dev, "patch.card.showinfo.version.Consistency");
                bl2 = false;
            }
            catch (PwdCLIOverrunException e) {
                log.error("query device version info error!", (Throwable)e);
                this.getFailedResult(failRet, dev, "patch.error.cli.over.run");
                bl = false;
                SshConnectionManager.releaseConnection(con);
                return bl;
            }
            catch (ToolException e2) {
                log.error("query device version info error!", (Throwable)e2);
                this.getFailedResult(failRet, dev, "patch.card.step1.showerror");
                bl = false;
                {
                    catch (Throwable throwable) {
                        SshConnectionManager.releaseConnection(con);
                        throw throwable;
                    }
                }
                SshConnectionManager.releaseConnection(con);
                return bl;
            }
            SshConnectionManager.releaseConnection(con);
            return bl2;
        }
        SshConnectionManager.releaseConnection(con);
        return true;
    }
}

