/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.service;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.BizPackage;
import com.huawei.ism.tool.bizpack.IProcessEnvCreator;
import com.huawei.ism.tool.bizpack.IProcessListener;
import com.huawei.ism.tool.bizpack.ProcessInfo;
import com.huawei.ism.tool.bizpack.ProcessInstance;
import com.huawei.ism.tool.bizpack.ProcessInstanceBuilder;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.entity.ExecuteResult;
import com.huawei.ism.tool.devicepatch.entity.PatchInfo;
import com.huawei.ism.tool.devicepatch.entity.ProcessingInfo;
import com.huawei.ism.tool.devicepatch.logic.BizPackageSupport;
import com.huawei.ism.tool.devicepatch.logic.CheckPatchProcess;
import com.huawei.ism.tool.devicepatch.logic.DevPatchExcelWriter;
import com.huawei.ism.tool.devicepatch.logic.GetPatchVersion;
import com.huawei.ism.tool.devicepatch.logic.PatchEnvCreator;
import com.huawei.ism.tool.devicepatch.logic.PatchExecutorSupport;
import com.huawei.ism.tool.devicepatch.remote.entity.TaskInfo;
import com.huawei.ism.tool.devicepatch.remote.utils.ProgressUtil;
import com.huawei.ism.tool.devicepatch.service.enums.OptionType;
import com.huawei.ism.tool.devicepatch.ui.main.dialog.PatchDetailDialog;
import com.huawei.ism.tool.devicepatch.utils.DevicePatchUtil;
import com.huawei.ism.tool.devicepatch.utils.ItemProgressUpdateUtil;
import com.huawei.ism.tool.devicepatch.utils.PatchSceneUtil;
import com.huawei.ism.tool.framework.pubservice.silentprocess.SilentProcessData;
import com.huawei.ism.tool.framework.pubservice.silentprocess.SilentProcessToFile;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.PortUnreachableException;
import com.huawei.ism.tool.obase.exception.PwdException;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PatchService.class);
    private static final String STORAGE_COMMON_PATH = ApplicationContext.getInstance().getWorkPath() + File.separator + "packages" + File.separator + "patch" + File.separator + "products" + File.separator + "StorageCommon";
    private static final PatchService INSTANCE = new PatchService();
    private static final int TEN_MB = 0xA00000;

    private PatchService() {
    }

    public static PatchService getInstance() {
        return INSTANCE;
    }

    public void startBatch(List<DevNode> devNodes) {
        this.startBatch(devNodes, OptionType.UPGRADE);
    }

    public void startBatch(List<DevNode> devNodes, OptionType type) {
        CountDownLatch countDownLatch = new CountDownLatch(devNodes.size());
        if (PatchSceneUtil.isA800PatchEval()) {
            List<List<DevNode>> batchList = this.getBatchList(devNodes);
            for (List<DevNode> batchDevNodes : batchList) {
                countDownLatch = new CountDownLatch(batchDevNodes.size());
                this.setPreCheckModel(batchDevNodes);
                this.startBatchPatch(devNodes, type, countDownLatch);
            }
            return;
        }
        this.startBatchPatch(devNodes, type, countDownLatch);
    }

    private void startBatchPatch(List<DevNode> devNodes, OptionType type, CountDownLatch countDownLatch) {
        for (DevNode node : devNodes) {
            ProcessingInfo info = PatchDataContext.getInstance().getProcessingInfo(node);
            info.clear();
            ExecuteResult result = new ExecuteResult(null);
            result.setDescription(OptionType.UPGRADE.equals((Object)type) ? ResourceUtil.getString((String)"patch.main.detail.info.start") : ResourceUtil.getString((String)"patch.main.detail.info.rollback"));
            result.setCheckItem(false);
            result.setDevNode(node);
            result.setProcess(10);
            info.setStatus(DevPatch.DevPatchStatus.WAITING);
            info.addResult(result);
            ItemProgressUpdateUtil.INS.clear(node.getIp());
            PatchDataContext.getInstance().uiCallBack(node);
            PatchExecutorSupport.getInstance().addPatchJob(node, countDownLatch, type);
        }
        if (PatchSceneUtil.isPatchEvalu()) {
            PatchDataContext.getInstance().setRunEvaluing(true);
            PatchExecutorSupport.getInstance().addReportTask(devNodes, countDownLatch);
        }
    }

    private List<List<DevNode>> getBatchList(List<DevNode> devNodes) {
        ArrayList<List<DevNode>> batchList = new ArrayList<List<DevNode>>();
        int evalSize = devNodes.size();
        int pageSize = 10;
        int totalPages = (int)Math.ceil((double)evalSize / (double)pageSize);
        for (int page = 0; page < totalPages; ++page) {
            int fromIndex = page * pageSize;
            int toIndex = Math.min(fromIndex + pageSize, evalSize);
            List<DevNode> currentPage = devNodes.subList(fromIndex, toIndex);
            batchList.add(currentPage);
        }
        return batchList;
    }

    private void setPreCheckModel(List<DevNode> devs) {
        DevNode minZoneIdDev = devs.stream().min(Comparator.comparing(DevNode::getUuid)).orElse(devs.get(0));
        for (DevNode devNode : devs) {
            if (Objects.equals(devNode.getIp(), minZoneIdDev.getIp())) {
                devNode.setPreCheckModel("execute");
                List<String> zoneIds = devs.stream().map(DevNode::getUuid).sorted().collect(Collectors.toList());
                devNode.setZoneIds(zoneIds);
                continue;
            }
            devNode.setPreCheckModel("query");
            devNode.setExecuteZoneIp(minZoneIdDev.getIp());
        }
    }

    public void loadBizPackages() {
        new BizPackageSupport().loadBizPackages();
    }

    public boolean importPackage(File pkgFile) throws ToolException {
        if (!pkgFile.exists()) {
            return false;
        }
        if (pkgFile.length() > 0xA00000L) {
            throw new ToolException("pkg size > 10mb. ", false);
        }
        try {
            boolean importSuccess = new BizPackageSupport().importBizPackage(pkgFile);
            if (importSuccess) {
                this.loadBizPackages();
            }
            return importSuccess;
        }
        catch (Exception e) {
            LOGGER.error("parse import package error.", (Throwable)e);
            throw new ToolException("", false);
        }
    }

    public BizPackage getBizPackage(DevNode devNode) {
        return PatchDataContext.getInstance().getBizPackage(devNode);
    }

    public void removeDevNode(List<DevNode> nodes) {
        for (DevNode node : nodes) {
            PatchDataContext.getInstance().removeNodeInfo(node);
        }
    }

    public Object checkBatch(DevNode devNode) throws ToolException {
        List result = new ArrayList();
        CheckPatchProcess pro = new CheckPatchProcess();
        try {
            result = this.queryPatch(devNode, result, pro);
        }
        catch (PwdException pwdException) {
            throw pwdException;
        }
        catch (PortUnreachableException ex) {
            LOGGER.error("try to connect device port fail. ", (Throwable)ex);
            return ex.getDes();
        }
        catch (ToolException toolException) {
            LOGGER.error("In the patch information query equipment,the connection fails. ", (Throwable)toolException);
            return ResourceUtil.getString((String)"patch.card.step1.showerror");
        }
        catch (Exception e) {
            LOGGER.error("build CheckBatch ProicessInstance failed. ", (Throwable)e);
            return ResourceUtil.getString((String)"patch.card.showinfo.conerror");
        }
        String errorMsg = pro.getErrorMsg();
        LOGGER.info("checkBatch errorMsg : {}", (Object)errorMsg);
        if (!StringUtils.isNULLStr((String)errorMsg)) {
            return errorMsg;
        }
        if (!((Boolean)result.get(0)).booleanValue()) {
            PatchInfo ppinfo = new PatchInfo("--");
            String checkAgainResult = this.checkAgain(devNode, ppinfo);
            if (!StringUtils.isNULLStr((String)checkAgainResult)) {
                return checkAgainResult;
            }
            return ppinfo;
        }
        PatchInfo pInfo = new PatchInfo((String)result.get(1));
        pInfo.setDescription((String)result.get(2));
        String checkAgainResult = this.checkAgain(devNode, pInfo);
        if (!StringUtils.isNULLStr((String)checkAgainResult)) {
            return checkAgainResult;
        }
        return pInfo;
    }

    private String checkAgain(DevNode devNode, PatchInfo pInfo) {
        try {
            String curPatchVer = this.getPatchVersion(devNode);
            pInfo.setCurrentVer(curPatchVer);
            devNode.setHotPatchVersion(curPatchVer);
        }
        catch (ToolException toolException) {
            LOGGER.error("When checking the version number of the current patch again,the connection fails. ", (Throwable)toolException);
            return ResourceUtil.getString((String)"patch.card.step1.showerror");
        }
        return null;
    }

    private List queryPatch(DevNode devNode, List result, CheckPatchProcess pro) throws ToolException {
        BizPackage bizPkg = this.getBizPackage(devNode);
        if (bizPkg == null) {
            LOGGER.error("biz package is null for device: {}", (Object)devNode.getIp());
            throw new ToolException("biz package is null");
        }
        ProcessInfo proInfo = bizPkg.getProcessInfoByID("hotPatchCheck");
        PatchEnvCreator env = new PatchEnvCreator(devNode);
        ProcessInstanceBuilder proIns = new ProcessInstanceBuilder();
        proIns.addProcessListener((IProcessListener)pro);
        proIns.setEnvCreator((IProcessEnvCreator)env);
        ProcessInstance pInstance = proIns.construct(proInfo);
        pInstance.getExecutor().addJythonClassPath((List)new ArrayList<String>(){
            {
                this.add(STORAGE_COMMON_PATH);
            }
        });
        pInstance.process();
        env.releaseRestConnection();
        Object ret = pInstance.getProcessResult();
        if (ret != null) {
            LOGGER.info("check patchinfo result : {}", ret);
            return (List)ret;
        }
        return result;
    }

    private String checkPatchBranch(String branchId) {
        if ("AUTOMATIC".equals(branchId)) {
            return "filePathParse";
        }
        return "checkPkgCompatibility";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPathCheckResult(DevNode devNode, String batchPathDir, Window parent) {
        Map patchMap = new HashMap();
        CheckPatchProcess pro = new CheckPatchProcess();
        PatchEnvCreator env = null;
        try {
            BizPackage bizPkg = this.getBizPackage(devNode);
            if (bizPkg == null) {
                LOGGER.error("biz package is null for device: {}", (Object)devNode.getIp());
                String string = ResourceUtil.getString((String)"patch.card.showinfo.conerror");
                return string;
            }
            ProcessInfo proInfo = bizPkg.getProcessInfoByID(this.checkPatchBranch(devNode.getMatchType()));
            env = new PatchEnvCreator(devNode);
            env.createParsePathEnv(batchPathDir);
            env.createPkgPathEnv(batchPathDir);
            env.putLoadPatchPathSceneInEnv(parent);
            ProcessInstanceBuilder proIns = new ProcessInstanceBuilder();
            proIns.addProcessListener((IProcessListener)pro);
            proIns.setEnvCreator((IProcessEnvCreator)env);
            ProcessInstance pInstance = proIns.construct(proInfo);
            pInstance.getExecutor().addJythonClassPath((List)new ArrayList<String>(){
                {
                    this.add(STORAGE_COMMON_PATH);
                }
            });
            pInstance.process();
            Object ret = pInstance.getProcessResult();
            if (null != ret) {
                patchMap = (Map)ret;
                LOGGER.info("getPathCheckResult result : {}", (Object)patchMap.toString());
            }
        }
        catch (Exception e) {
            LOGGER.error("build checkBatchPath ProicessInstance failed. ", (Throwable)e);
            String string = ResourceUtil.getString((String)"patch.card.showinfo.conerror");
            return string;
        }
        finally {
            if (null != env) {
                try {
                    env.clearEnv();
                }
                catch (Exception e) {
                    LOGGER.error("env clear error ", (Throwable)e);
                }
            }
        }
        if (!StringUtils.isNULLStr((String)pro.getErrorMsg())) {
            return pro.getErrorMsg();
        }
        return patchMap;
    }

    public Object getPathCheckResult(DevNode devNode, String batchPathDir) {
        return this.getPathCheckResult(devNode, batchPathDir, PatchDataContext.getInstance().getMainDialog());
    }

    public String checkPatchDirBranch(String patchDir) {
        List<DevPatch> devPatchs = PatchDataContext.getInstance().getTmpDevPatchsBranch();
        for (DevPatch dP : devPatchs) {
            DevNode node = dP.getDevNode().get(0);
            PatchInfo patchInfo = dP.getBatchInfo();
            Object pathCheckResult = this.getPathCheckResult(node, patchDir);
            if (pathCheckResult instanceof String) {
                return (String)pathCheckResult;
            }
            Map result = (Map)pathCheckResult;
            Iterator iter = result.entrySet().iterator();
            String hotPatchVersion = (String)result.get("hotPatchVersion");
            String curPatchVersion = this.getCurPatchVersion((String)result.get("curPatchVersion"));
            LOGGER.info("curPathVersion:{} ,hotPatchVersion:{},ProductVersion:{}", new Object[]{curPatchVersion, hotPatchVersion, node.getProductVersion()});
            if (!DevicePatchUtil.isIgnoreSpcSphMatch() && DevicePatchUtil.checkConsistentVersions(node.getProductVersion(), curPatchVersion, hotPatchVersion)) {
                return ResourceUtil.getString((String)"patch.card.step2.showinfo.failed.version.consistent");
            }
            if (!DevicePatchUtil.isIgnoreSpcSphMatch() && !DevicePatchUtil.isPatchSysVersionMatched(node.getProductVersion(), hotPatchVersion)) {
                return ResourceUtil.getString((String)"patch.card.step2.showinfo.failed.not.match");
            }
            patchInfo.setVersion(hotPatchVersion);
            patchInfo.setCurrentVer(curPatchVersion);
            patchInfo.setPatchPath(patchDir);
        }
        this.clearAndSaveData();
        return null;
    }

    public String checkPatchPath(String patchDir) {
        List<DevPatch> devPatchs = PatchDataContext.getInstance().getTmpDevPatchsBranch();
        boolean allSucc = true;
        for (DevPatch dP : devPatchs) {
            DevNode node = dP.getDevNode().get(0);
            Object o = this.getPathCheckResult(node, patchDir);
            if (o instanceof String) {
                this.clearAndSaveData();
                return (String)o;
            }
            Map result = (Map)o;
            Iterator iter = result.entrySet().iterator();
            String ver = null;
            String path = null;
            boolean checkOk = false;
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                ver = (String)entry.getKey();
                path = (String)entry.getValue();
                PatchInfo info = dP.getBatchInfo();
                if (info.getVersion().equals(ver)) {
                    info.setPatchPath(path);
                    checkOk = true;
                    break;
                }
                checkOk = false;
            }
            if (checkOk) continue;
            allSucc = false;
        }
        this.clearAndSaveData();
        if (!allSucc) {
            return ResourceUtil.getString((String)"patch.card.step2.showinfo.notassociated");
        }
        return null;
    }

    public String checkBatchPath(String batchPathDir, PatchInfo info, DevPatch devPatch, PatchDetailDialog patchDetailDialog) {
        List<DevNode> devNodeList = devPatch.getDevNode();
        for (DevNode devNode : devNodeList) {
            Object pathCheckResult = this.getPathCheckResult(devNode, batchPathDir, patchDetailDialog);
            if (pathCheckResult instanceof String) {
                return (String)pathCheckResult;
            }
            String version = info.getVersion();
            Map result = (Map)pathCheckResult;
            Iterator<Map.Entry<String, String>> iter = result.entrySet().iterator();
            this.setCurrentVersion(info, iter);
            boolean checkOk = this.isCheckOk(devNode, version, result);
            if (!checkOk) {
                return ResourceUtil.getString((String)"patch.dialog.detail.showinfo.patherror");
            }
            LOGGER.info("curPathVersion:{} ,hotPatchVersion:{},ProductVersion:{}", new Object[]{info.getCurrentVer(), info.getVersion(), devNode.getProductVersion()});
            if (!DevicePatchUtil.isIgnoreSpcSphMatch() && DevicePatchUtil.checkConsistentVersions(devNode.getProductVersion(), info.getCurrentVer(), info.getVersion())) {
                return ResourceUtil.getString((String)"patch.card.step2.showinfo.failed.version.consistent");
            }
            if (DevicePatchUtil.isIgnoreSpcSphMatch() || DevicePatchUtil.isPatchSysVersionMatched(devNode.getProductVersion(), info.getVersion())) continue;
            return ResourceUtil.getString((String)"patch.card.step2.showinfo.failed.not.match");
        }
        return ResourceUtil.getString((String)"patch.dialog.detail.showinfo.pathsucc");
    }

    private boolean isCheckOk(DevNode devNode, String version, Map<String, String> result) {
        String ver = "";
        Iterator<Map.Entry<String, String>> iter2 = result.entrySet().iterator();
        if (iter2.hasNext()) {
            Map.Entry<String, String> entry = iter2.next();
            ver = entry.getKey();
            LOGGER.info("map ver : {}  dev ver : {}", (Object)ver, (Object)version);
            if ("AUTOMATIC".equals(devNode.getMatchType()) && version.equals(ver)) {
                return true;
            }
            return true;
        }
        return false;
    }

    private void setCurrentVersion(PatchInfo info, Iterator<Map.Entry<String, String>> iter) {
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            if ("hotPatchVersion".equals(entry.getKey())) {
                info.setVersion(entry.getValue());
                continue;
            }
            if (!"curPatchVersion".equals(entry.getKey())) continue;
            info.setCurrentVer(this.getCurPatchVersion(entry.getValue()));
        }
    }

    public boolean checkLinkagePatch(String patchFullName, PatchInfo info, DevNode devNode) {
        Object o = this.getPathCheckResult(devNode, patchFullName);
        if (o instanceof String) {
            if (TaskInfo.REMOTE_TASK.isRemoteTask()) {
                SilentProcessData pro = TaskInfo.REMOTE_TASK.getProcessData(devNode.getDeviceSerialNumber());
                ProgressUtil.updateDevFailedMsg(pro, o.toString());
                SilentProcessToFile.updateDeviceData((SilentProcessData)pro, (String)TaskInfo.REMOTE_TASK.getWorkPath());
            }
            return false;
        }
        Map result = (Map)o;
        Iterator<Map.Entry<String, String>> iter = result.entrySet().iterator();
        this.setCurrentVersion(info, iter);
        return true;
    }

    public boolean exportDevPatchInfo(String path) {
        try {
            new DevPatchExcelWriter().exportDevPatchInfo(path);
            return true;
        }
        catch (ToolException e) {
            LOGGER.error("exportDevPatchInfo failed. ", (Throwable)e);
            FileUtils.deleteFile((File)new File(path));
            return false;
        }
    }

    public DevPatch.DevPatchStatus getStatus(DevNode node) {
        DevPatch.DevPatchStatus status = DevPatch.DevPatchStatus.ASSOCIATED;
        ProcessingInfo proInfo = PatchDataContext.getInstance().getProcessingInfo(node);
        if (proInfo != null) {
            DevPatch.DevPatchStatus devPatchStatus = status = proInfo.isTaskRunning() ? DevPatch.DevPatchStatus.RUNNING : proInfo.getStatus();
        }
        if ("PATCH_EVALU".equals(node.getMatchType())) {
            return status;
        }
        PatchInfo patchInfo = PatchDataContext.getInstance().getPatchInfo(node);
        if (patchInfo == null) {
            status = DevPatch.DevPatchStatus.NOTASSOCIATED;
        } else if (StringUtils.isNULLStr((String)patchInfo.getPatchPath())) {
            status = DevPatch.DevPatchStatus.NOTASSOCIATED;
        }
        return status;
    }

    public String getPatchVersion(DevNode devNode) throws ToolException {
        GetPatchVersion verPro = new GetPatchVersion(devNode);
        try {
            BizPackage bizPkg = this.getBizPackage(devNode);
            if (bizPkg == null) {
                LOGGER.error("biz package is null for device: {}", (Object)devNode.getIp());
                return "--";
            }
            ProcessInfo proInfo = bizPkg.getProcessInfoByID("getHotpatchVersion");
            PatchEnvCreator env = new PatchEnvCreator(devNode);
            ProcessInstanceBuilder proIns = new ProcessInstanceBuilder();
            proIns.addProcessListener((IProcessListener)verPro);
            proIns.setEnvCreator((IProcessEnvCreator)env);
            ProcessInstance pInstance = proIns.construct(proInfo);
            pInstance.getExecutor().addJythonClassPath((List)new ArrayList<String>(){
                {
                    this.add(STORAGE_COMMON_PATH);
                }
            });
            pInstance.process();
            env.clearEnv();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("check patch current version is : " + verPro.getVersion());
            }
        }
        catch (ToolException toolException) {
            throw toolException;
        }
        catch (Exception e) {
            LOGGER.error("build Check Current Version ProicessInstance failed. ", (Throwable)e);
            return "--";
        }
        return this.getCurPatchVersion(verPro.getVersion());
    }

    private String getCurPatchVersion(String version) {
        LOGGER.info("getPatchVersion success.version:{}", (Object)version);
        if (StringUtils.isNULLStr((String)version) || "None".equals(version)) {
            return "--";
        }
        return version;
    }

    public void clearAndSaveData() {
        for (DevPatch dp : PatchDataContext.getInstance().getTmpDevPatchsBranch()) {
            PatchDataContext.getInstance().setDevPatchs(dp);
            List<DevNode> devs = PatchDataContext.getInstance().getDevNodes();
            for (DevNode dev : dp.getDevNode()) {
                if (devs.contains(dev)) continue;
                devs.add(dev);
                ProcessingInfo info = PatchDataContext.getInstance().getProcessingInfo(dev);
                info.setCurrentVer(dp.getBatchInfo().getCurrentVer());
                if (!"PATCH_EVALU".equals(dev.getMatchType())) continue;
                info.setStatus(DevPatch.DevPatchStatus.NOTEVALU);
            }
        }
        PatchDataContext.getInstance().getTmpDevPatchs().clear();
        PatchDataContext.getInstance().getTmpDevPatchsBranch().clear();
    }

    public void saveBranchId(List<DevPatch> devPatchs, String branchId) {
        for (DevPatch dp : devPatchs) {
            for (DevNode dev : dp.getDevNode()) {
                dev.setMatchType(branchId);
            }
        }
    }
}

