/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.ui.card;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCard;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCardLayout;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.action.support.SubDialogUtils;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.service.CheckPatchInfo;
import com.huawei.ism.tool.devicepatch.ui.card.AddDeviceCardLayout;
import com.huawei.ism.tool.devicepatch.ui.listener.PatchDeviceAddListener;
import com.huawei.ism.tool.devicepatch.ui.main.dialog.SupportDevDialog;
import com.huawei.ism.tool.devicepatch.utils.DevicePatchUtil;
import com.huawei.ism.tool.devicepatch.utils.PatchSceneUtil;
import com.huawei.ism.tool.framework.pubui.PublicUiManage;
import com.huawei.ism.tool.framework.pubui.common.IDeviceManageUI;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import org.slf4j.Logger;

public class AddDeviceCard
extends FlowWizardCard {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(AddDeviceCard.class);
    private static final String GRAY_COLOR = "<font color=#C0C0C0>";
    private AddDeviceCardLayout layout = new AddDeviceCardLayout();
    private boolean hasShowSocksMsg = false;

    public AddDeviceCard() {
        this.addListener();
    }

    public void initData() {
        this.layout.getTable().removeAll();
        List<DevNode> devs = DevicePatchUtil.getAllAddDevNodes();
        boolean isSocks = false;
        StringBuilder devIp = new StringBuilder();
        for (DevNode dev : devs) {
            if (LocalHostUtil.isRunInSvp() && !dev.isIpListAreInnerIp()) {
                ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("This device is not current svp node:" + dev);
                continue;
            }
            LOGGER.info("---------ip:{},productModel:{}", (Object)dev.getIp(), (Object)dev.getProductModel());
            if (!PatchDataContext.getInstance().isSupportDev(dev)) continue;
            if (null != dev.getSocks5Proxy()) {
                devIp.append(dev.getIp());
                devIp.append(' ');
                isSocks = true;
                continue;
            }
            TableRow<DevNode, String> row = this.createDeviceTableRow(dev);
            this.layout.getTable().addRow(new TableRow[]{row});
        }
        List<DevPatch> chooseDevs = PatchDataContext.getInstance().getTmpDevPatchs();
        if (!chooseDevs.isEmpty()) {
            for (DevPatch dp : chooseDevs) {
                for (DevNode dev : dp.getDevNode()) {
                    int rowNum = this.layout.getTable().getRowIndex((Object)(dev.getDeviceSerialNumber() + dev.getDeviceType()));
                    int viewRowNum = this.layout.getDeviceTable().convertRowIndexToView(rowNum);
                    this.layout.getDeviceTable().addRowSelectionInterval(viewRowNum, viewRowNum);
                }
            }
        }
        if (isSocks && !this.hasShowSocksMsg) {
            this.hasShowSocksMsg = true;
            String mes = ResourceUtil.getStringWithParams((String)"patch.main.button.showinfo.device", (Object[])new Object[]{devIp.toString()});
            DialogUtils.showInfoDialog((JDialog)PatchDataContext.getInstance().getWizDialog(), (String)mes);
        }
    }

    private List<DevNode> getSupportDev() {
        ArrayList<DevNode> devNodes = new ArrayList<DevNode>();
        List devs = DefaultNodeProviderImpl.getInstance().getNodeList();
        for (DevNode dev : devs) {
            if (!PatchDataContext.getInstance().isSupportDev(dev)) continue;
            devNodes.add(dev);
        }
        return devNodes;
    }

    private TableRow<DevNode, String> createDeviceTableRow(DevNode dev) {
        String key = dev.getDeviceSerialNumber() + dev.getDeviceType();
        DefaultTableRow row = new DefaultTableRow(this.layout.getTable().getColumnCount(), (Object)dev, (Object)key);
        int count = 0;
        if (PatchSceneUtil.isA800PatchEval()) {
            row.setValueAt(count++, (Object)DevicePatchUtil.getA800Name(dev.getDeviceSerialNumber()));
        }
        row.setValueAt(count++, (Object)DevicePatchUtil.getDisplayModel(dev));
        row.setValueAt(count++, (Object)dev.getProductVersion());
        row.setValueAt(count++, (Object)dev.getIp());
        row.setValueAt(count++, (Object)(StringUtils.isNULLStr((String)dev.getDeviceName()) ? "--" : dev.getDeviceName()));
        row.setValueAt(count++, (Object)dev.getDeviceSerialNumber());
        if (PatchSceneUtil.isScene()) {
            row.setValueAt(count++, (Object)new IsmTableCell.HyperlinkCell(GRAY_COLOR + ResourceUtil.getString((String)"patch.card.step1.table.modify")));
        } else {
            row.setValueAt(count++, (Object)new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"patch.card.step1.table.modify"), (ActionListener)new ModifyAction(dev, (Window)PatchDataContext.getInstance().getWizDialog())));
        }
        return row;
    }

    private void addListener() {
        if (!PatchSceneUtil.isScene()) {
            this.layout.getAddDeviceLabel().addMouseListener(new PatchDeviceAddListener(this));
        }
        this.layout.getShowSupLabel().addMouseListener(new AddMouseListenerAdapter());
    }

    private List<DevNode> getSelectRows() {
        ArrayList<DevNode> devs = new ArrayList<DevNode>();
        List tableRows = this.layout.getDeviceTable().getMarkedRows();
        for (TableRow tr : tableRows) {
            devs.add((DevNode)tr.getUserObject());
        }
        return devs;
    }

    protected FlowWizardCardLayout getLayout() {
        return this.layout;
    }

    protected boolean init() {
        this.layout.setComName();
        this.initData();
        return true;
    }

    public boolean ending() {
        List<DevNode> devs = this.getSelectRows();
        if (devs.isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)PatchDataContext.getInstance().getWizDialog(), (String)ResourceUtil.getString((String)"patch.card.showinfo.seldevs"));
            return false;
        }
        if (PatchSceneUtil.isPatchEvalu() && !DevicePatchUtil.isSameTypeAndVer(devs)) {
            DialogUtils.showInfoDialog((JDialog)PatchDataContext.getInstance().getWizDialog(), (String)ResourceUtil.getString((String)"patch.card.showinfo.addSameDev"));
            return false;
        }
        return this.autoMaticCheck(devs);
    }

    private boolean autoMaticCheck(List<DevNode> devs) {
        List list = AsyncExcutor.execute((Window)PatchDataContext.getInstance().getWizDialog(), (Callable[])new Callable[]{new CheckPatchInfo(devs)});
        List failRet = (List)list.get(0);
        if (!failRet.isEmpty()) {
            SubDialogUtils.showMultiInfoDialog((Window)PatchDataContext.getInstance().getWizDialog(), (String)ResourceUtil.getString((String)"patch.card.step2.showinfo.failed.msg"), (String[])new String[]{ResourceUtil.getString((String)"patch.card.step2.showinfo.failed.ip"), ResourceUtil.getString((String)"patch.card.step2.showinfo.failed.reason")}, (List)failRet);
            try {
                int checkPathResSize = 2;
                for (ArrayList tempArrayLists : failRet) {
                    if (2 != tempArrayLists.size()) continue;
                    ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Select device " + tempArrayLists.get(0).toString() + " for upgrade patch failed." + tempArrayLists.get(1).toString());
                }
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Log records failed.", (Throwable)e);
            }
            if (failRet.size() == devs.size()) {
                return false;
            }
        } else {
            try {
                for (DevNode dev : devs) {
                    ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Select device " + dev.getIp() + " for upgrade patch success.");
                }
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Log records failed.", (Throwable)e);
            }
        }
        return true;
    }

    public boolean flowExiting() {
        return true;
    }

    private static class AddMouseListenerAdapter
    extends MouseAdapter {
        private AddMouseListenerAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SupportDevDialog supDialog = new SupportDevDialog((Window)PatchDataContext.getInstance().getWizDialog());
            supDialog.setVisible(true);
        }
    }

    private class ModifyAction
    extends ToolHyperLinkLabel.ClickAdapter {
        private static final long serialVersionUID = 1L;
        private DevNode node;
        private Window parent;

        public ModifyAction(DevNode node, Window parent) {
            this.node = node;
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IDeviceManageUI idm = (IDeviceManageUI)PublicUiManage.getInstance().getUi(IDeviceManageUI.class);
            idm.showModifyIntegrateDeviceDialogByDevKey(this.parent, false, this.node.getDevKey(), EntityUtils.toNewDevList(AddDeviceCard.this.getSupportDev()));
        }
    }
}

