/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.ui.card;

import com.huawei.ism.tool.base.ui.wizard.FlowWizardCard;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCardLayout;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.ui.card.CheckPatchCardLayout;
import com.huawei.ism.tool.devicepatch.utils.DevicePatchUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;

public class CheckPatchCard
extends FlowWizardCard {
    private CheckPatchCardLayout layout = new CheckPatchCardLayout();

    protected FlowWizardCardLayout getLayout() {
        return this.layout;
    }

    protected boolean init() {
        this.layout.setCompName();
        this.initData();
        return true;
    }

    private void initData() {
        this.layout.getTable().removeAll();
        List<DevPatch> devPatchList = PatchDataContext.getInstance().getTmpDevPatchs();
        for (DevPatch devPatch : devPatchList) {
            for (int i = 0; i < devPatch.getDevNode().size(); ++i) {
                TableRow<DevPatch, String> row = this.createDeviceTableRow(devPatch, i);
                this.layout.getTable().addRow(new TableRow[]{row});
            }
        }
    }

    private TableRow<DevPatch, String> createDeviceTableRow(DevPatch dp, int index) {
        int i = 0;
        DevNode devNode = dp.getDevNode().get(index);
        DevPatch devPatch = new DevPatch();
        devPatch.setBatchInfo(dp.getBatchInfo());
        devPatch.getDevNode().add(devNode);
        String key = devNode.getDeviceSerialNumber() + devNode.getDeviceType();
        DefaultTableRow row = new DefaultTableRow(this.layout.getTable().getColumnCount(), (Object)devPatch, (Object)key);
        row.setValueAt(i++, (Object)DevicePatchUtil.getDisplayModel(devNode));
        row.setValueAt(i++, (Object)devNode.getProductVersion());
        row.setValueAt(i++, (Object)devNode.getIp());
        row.setValueAt(i++, (Object)(StringUtils.isNULLStr((String)devNode.getDeviceName()) ? "--" : devNode.getDeviceName()));
        row.setValueAt(i++, (Object)dp.getBatchInfo().getCurrentVer());
        row.setValueAt(i++, (Object)dp.getBatchInfo().getVersion());
        return row;
    }

    public boolean ending() {
        List<DevPatch> devPatchs = this.getSelectRows();
        if (devPatchs.isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)PatchDataContext.getInstance().getWizDialog(), (String)ResourceUtil.getString((String)"patch.card.showinfo.seldevs"));
            return false;
        }
        return this.selectBarch(devPatchs);
    }

    private List<DevPatch> getSelectRows() {
        ArrayList<DevPatch> patchs = new ArrayList<DevPatch>();
        List tableRows = this.layout.getDevPatchTable().getMarkedRows();
        for (TableRow tr : tableRows) {
            patchs.add((DevPatch)tr.getUserObject());
        }
        return patchs;
    }

    private boolean selectBarch(List<DevPatch> devPatchs) {
        if (this.layout.getAutoRadio().isSelected()) {
            if (!this.checkPatchInfo(devPatchs)) {
                DialogUtils.showInfoDialog((JDialog)PatchDataContext.getInstance().getWizDialog(), (String)ResourceUtil.getString((String)"patch.card.branch2.showmsg"));
                return false;
            }
            this.saveBranchId(devPatchs, "AUTOMATIC");
            this.getContext().saveSingleObject("branch_id", (Object)"AUTOMATIC");
            PatchDataContext.getInstance().setTmpDevPatchsBranch(devPatchs);
            try {
                for (DevPatch devPath : devPatchs) {
                    for (DevNode devNode : devPath.getDevNode()) {
                        ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Select device : " + devNode.getIp() + " install patch mode : AUTOMATIC");
                    }
                }
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Log records failed.", (Throwable)e);
            }
        } else {
            if (!this.checkDeviceInfo(devPatchs)) {
                DialogUtils.showInfoDialog((JDialog)PatchDataContext.getInstance().getWizDialog(), (String)ResourceUtil.getString((String)"patch.card.branch1.showmsg"));
                return false;
            }
            this.saveBranchId(devPatchs, "NON_AUTOMATIC");
            this.getContext().saveSingleObject("branch_id", (Object)"NON_AUTOMATIC");
            PatchDataContext.getInstance().setTmpDevPatchsBranch(devPatchs);
            try {
                for (DevPatch devPath : devPatchs) {
                    for (DevNode devNode : devPath.getDevNode()) {
                        ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Select device : " + devNode.getIp() + " install patch mode : NON_AUTOMATIC");
                    }
                }
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Log records failed.", (Throwable)e);
            }
        }
        return true;
    }

    private void saveBranchId(List<DevPatch> devPatchs, String branchId) {
        for (DevPatch dp : devPatchs) {
            for (DevNode dev : dp.getDevNode()) {
                dev.setMatchType(branchId);
            }
        }
    }

    private boolean checkPatchInfo(List<DevPatch> devPatchs) {
        for (DevPatch dp : devPatchs) {
            String ver = dp.getBatchInfo().getVersion();
            if (!"--".equals(ver)) continue;
            return false;
        }
        return true;
    }

    private boolean checkDeviceInfo(List<DevPatch> devPatchs) {
        String type = devPatchs.get(0).getDevNode().get(0).getDeviceType().toString();
        String ver = devPatchs.get(0).getDevNode().get(0).getProductVersion();
        for (DevPatch devp : devPatchs) {
            DevNode node = devp.getDevNode().get(0);
            String type2 = node.getDeviceType().toString();
            String ver2 = node.getProductVersion();
            if (type.equals(type2) && ver.equals(ver2)) continue;
            return false;
        }
        return true;
    }

    public boolean flowExiting() {
        return true;
    }
}

