/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.ui.card;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCard;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCardLayout;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.service.PatchService;
import com.huawei.ism.tool.devicepatch.ui.card.ChoosePatchCardLayout;
import com.huawei.ism.tool.devicepatch.ui.listener.DetailHyLinkListener;
import com.huawei.ism.tool.devicepatch.ui.main.DevicePatchMainDialog;
import com.huawei.ism.tool.devicepatch.utils.DevicePatchUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.utils.ZipSizeUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JDialog;

public class ChoosePatchCard
extends FlowWizardCard {
    private static final long serialVersionUID = 1L;
    private ChoosePatchCardLayout layout = new ChoosePatchCardLayout();
    private static final int DIALOG_WIDTH = 220;
    private static final long LONG2 = 2L;
    private static final long LONG1024 = 1024L;

    public ChoosePatchCard() {
        this.addListener();
    }

    public void initData() {
        this.layout.getTable().removeAll();
        List<DevPatch> dps = PatchDataContext.getInstance().getTmpDevPatchsBranch();
        for (DevPatch dp : dps) {
            for (int i = 0; i < dp.getDevNode().size(); ++i) {
                TableRow<DevPatch, String> row = this.createDeviceTableRow(dp, i);
                this.layout.getTable().addRow(new TableRow[]{row});
            }
        }
    }

    private void addListener() {
        this.layout.getExportBatchButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChoosePatchCard.this.exportBatch();
            }
        });
        this.layout.getBrowseBatchButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChoosePatchCard.this.selectFile();
            }
        });
    }

    private void exportBatch() {
        if (PatchDataContext.getInstance().getTmpDevPatchsBranch().isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)PatchDataContext.getInstance().getWizDialog(), (String)ResourceUtil.getString((String)"patch.card.step2.showinfo.nodevnodes"));
            return;
        }
        String filePath = ToolFileChooser.getSaveFilePath(ResourceUtil.getString((String)"patch.card.step2.button.export"), "xls", (Window)PatchDataContext.getInstance().getWizDialog(), "DevicePatchDetail", "DevicePatch_export_id001");
        if (StringUtils.isNULLStr((String)filePath)) {
            return;
        }
        List ret = AsyncExcutor.execute((Window)PatchDataContext.getInstance().getWizDialog(), (String)ResourceUtil.getString((String)"patch.card.setpatchinfo.pkg.cheaking"), (int)220, (Callable[])new Callable[]{new ExportDevPatchInfoCallable(filePath)});
        if (((Boolean)ret.get(0)).booleanValue()) {
            DialogUtils.showInfoDialog((JDialog)PatchDataContext.getInstance().getWizDialog(), (String)ResourceUtil.getString((String)"patch.card.step2.showinfo.export.success"));
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("export patch " + filePath + " info success.");
        } else {
            DialogUtils.showInfoDialog((JDialog)PatchDataContext.getInstance().getWizDialog(), (String)ResourceUtil.getString((String)"patch.card.step2.showinfo.export.failed"));
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("export patch " + filePath + " info failed.");
        }
    }

    private void selectFile() {
        File filePath = ToolFileChooser.selectFile((Window)PatchDataContext.getInstance().getWizDialog(), ResourceUtil.getString((String)"patch.card.step2.button.scan"), new String[0], "DevicePatch_select_id_patch_file", "", 1);
        if (null == filePath) {
            return;
        }
        if (!filePath.exists()) {
            DialogUtils.showInfoDialog((JDialog)PatchDataContext.getInstance().getWizDialog(), (String)ResourceUtil.getString((String)"patch.card.step2.showinfo.choose.patchpath"));
            return;
        }
        try {
            this.layout.getBatchPathInput().setText(filePath.getCanonicalPath());
        }
        catch (IOException ioe) {
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("get file path failed");
        }
    }

    private TableRow<DevPatch, String> createDeviceTableRow(DevPatch devPatch, int index) {
        int i = 0;
        DevNode devNode = devPatch.getDevNode().get(index);
        DevPatch dp = new DevPatch();
        dp.setBatchInfo(devPatch.getBatchInfo());
        dp.getDevNode().add(devNode);
        String key = devNode.getDeviceSerialNumber() + devNode.getDeviceType();
        DefaultTableRow tableRow = new DefaultTableRow(this.layout.getTable().getColumnCount(), (Object)dp, (Object)key);
        tableRow.setValueAt(i++, (Object)DevicePatchUtil.getDisplayModel(devNode));
        tableRow.setValueAt(i++, (Object)devNode.getProductVersion());
        tableRow.setValueAt(i++, (Object)devNode.getIp());
        tableRow.setValueAt(i++, (Object)(StringUtils.isNULLStr((String)devNode.getDeviceName()) ? "--" : devNode.getDeviceName()));
        tableRow.setValueAt(i++, (Object)devPatch.getBatchInfo().getCurrentVer());
        tableRow.setValueAt(i++, (Object)devPatch.getBatchInfo().getVersion());
        tableRow.setValueAt(i++, (Object)new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"patch.main.table.detail"), (ActionListener)new DetailHyLinkListener(devPatch, devNode, true)));
        return tableRow;
    }

    protected FlowWizardCardLayout getLayout() {
        return this.layout;
    }

    protected boolean init() {
        this.layout.setCompName();
        this.initData();
        return true;
    }

    public boolean ending() {
        String batchPath = this.layout.getBatchPathInput().getText();
        if (StringUtils.isNULLStr((String)(batchPath = FilePathUtils.getSafePath((String)batchPath)))) {
            DialogUtils.showInfoDialog((JDialog)PatchDataContext.getInstance().getWizDialog(), (String)ResourceUtil.getString((String)"patch.card.step2.showinfo.choose.patchpath"));
            return false;
        }
        String confSize = UserOpDataSaveUtil.getToolIniProp((String)"tool.patchpkg.memory");
        if (StringUtils.isDigit((String)confSize) && new File(batchPath).getFreeSpace() < (long)StringUtils.str2Int((String)confSize) * 1024L * 1024L) {
            DialogUtils.showInfoDialog((JDialog)PatchDataContext.getInstance().getWizDialog(), (String)MessageFormat.format(ResourceUtil.getString((String)"patch.dialog.detail.batchpkg.insufficiency"), confSize));
            return false;
        }
        long fileRealSize = ZipSizeUtils.getRealSize(batchPath);
        if (fileRealSize > 0x80000000L) {
            DialogUtils.showInfoDialog((JDialog)PatchDataContext.getInstance().getWizDialog(), (String)ResourceUtil.getString((String)"patch.dialog.detail.batchpkg.outsize"));
            return false;
        }
        List result = AsyncExcutor.execute((Window)PatchDataContext.getInstance().getWizDialog(), (Callable[])new Callable[]{new ParserPatchFile(batchPath)});
        String msg = (String)result.get(0);
        if (!StringUtils.isNULLStr((String)msg)) {
            DialogUtils.showInfoDialog((JDialog)PatchDataContext.getInstance().getWizDialog(), (String)msg);
        }
        DevicePatchMainDialog mainDialog = PatchDataContext.getInstance().getMainDialog();
        mainDialog.initPatchData();
        return true;
    }

    public boolean flowExiting() {
        return true;
    }

    private static class ParserPatchFile
    implements Callable<String> {
        private String path;

        public ParserPatchFile(String path) {
            this.path = path;
        }

        @Override
        public String call() {
            return PatchService.getInstance().checkPatchPath(this.path);
        }
    }

    static class ExportDevPatchInfoCallable
    implements Callable<Boolean> {
        private String exportPath;

        public ExportDevPatchInfoCallable() {
        }

        public ExportDevPatchInfoCallable(String exportPath) {
            this.exportPath = exportPath;
        }

        public String getExportPath() {
            return this.exportPath;
        }

        public void setExportPath(String exportPath) {
            this.exportPath = exportPath;
        }

        @Override
        public Boolean call() {
            boolean ret = PatchService.getInstance().exportDevPatchInfo(this.exportPath);
            if (!ret) {
                return false;
            }
            FileUtils.setFilePermissions((String)this.exportPath);
            return true;
        }
    }
}

