/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.ui.card;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.flow.ui.IFlowUIState;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCard;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCardLayout;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardState;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.ui.action.support.SubDialogUtils;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.service.CheckPatchInfo;
import com.huawei.ism.tool.devicepatch.service.PatchService;
import com.huawei.ism.tool.devicepatch.ui.card.ChoosePatchCardLayoutNon;
import com.huawei.ism.tool.devicepatch.ui.main.DevicePatchMainDialog;
import com.huawei.ism.tool.devicepatch.utils.DevicePatchUtil;
import com.huawei.ism.tool.devicepatch.utils.PatchSceneUtil;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ZipSizeUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChoosePatchCardNon
extends FlowWizardCard {
    private static final Logger log = LoggerFactory.getLogger(ChoosePatchCardNon.class);
    private static final int DIALOG_WIDTH = 220;
    private static final long LONG2 = 2L;
    private static final long LONG1024 = 1024L;
    private ChoosePatchCardLayoutNon layout = new ChoosePatchCardLayoutNon();

    public ChoosePatchCardNon() {
        this.addListeners();
    }

    protected FlowWizardCardLayout getLayout() {
        return this.layout;
    }

    protected boolean init() {
        this.layout.setCompName();
        return this.initData();
    }

    protected IFlowUIState getInitUIState() {
        if (PatchSceneUtil.isA800HotPatch()) {
            return FlowWizardState.SINGLE_STEP_SUCCESS;
        }
        return null;
    }

    private void addListeners() {
        this.layout.getBrowseBatchButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ChoosePatchCardNon.this.selectPatchPkg();
            }
        });
    }

    private void selectPatchPkg() {
        HashMap<String, String> extParams = new HashMap<String, String>();
        extParams.put("title", ResourceUtil.getString((String)"patch.dialog.detail.selectpatch"));
        extParams.put("PathId", "DevicePatch_select_id_package");
        extParams.put("description", ".tgz");
        File file = ToolFileChooser.selectFile((Window)PatchDataContext.getInstance().getWizDialog(), new String[]{"tgz"}, 0, true, extParams);
        if (file != null) {
            if (!file.exists()) {
                DialogUtils.showInfoDialog((JDialog)PatchDataContext.getInstance().getWizDialog(), (String)ResourceUtil.getString((String)"patch.card.step2.showinfo.choose.patchpath"));
                return;
            }
            try {
                this.layout.getBatchPathInput().setText(file.getCanonicalPath());
            }
            catch (IOException ioe) {
                log.error("get file path failed");
            }
        }
    }

    private boolean initData() {
        this.layout.getTable().removeAll();
        if (PatchSceneUtil.isA800HotPatch()) {
            List<DevNode> allAddDevNodes = DevicePatchUtil.getAllAddDevNodes();
            for (DevNode devNode : allAddDevNodes) {
                this.layout.getTable().addRow(new TableRow[]{this.createDeviceTableRow(devNode)});
            }
            List list = AsyncExcutor.execute((Window)PatchDataContext.getInstance().getWizDialog(), (Callable[])new Callable[]{new CheckPatchInfo(allAddDevNodes)});
            List failRet = (List)list.get(0);
            if (!failRet.isEmpty()) {
                this.handleFailRet(failRet);
                return !SceneUtils.isA800SceneInTool();
            }
            return true;
        }
        List<DevPatch> dps = PatchDataContext.getInstance().getTmpDevPatchsBranch();
        for (DevPatch dp : dps) {
            for (int i = 0; i < dp.getDevNode().size(); ++i) {
                TableRow<DevPatch, String> devRow = this.createDeviceTableRow(dp, i);
                this.layout.getTable().addRow(new TableRow[]{devRow});
            }
        }
        return true;
    }

    private void handleFailRet(List<ArrayList<Object>> failRet) {
        SubDialogUtils.showMultiInfoDialog((Window)PatchDataContext.getInstance().getWizDialog(), (String)ResourceUtil.getString((String)"patch.card.step2.showinfo.failed.msg"), (String[])new String[]{ResourceUtil.getString((String)"patch.card.step2.showinfo.failed.ip"), ResourceUtil.getString((String)"patch.card.step2.showinfo.failed.reason")}, failRet);
    }

    private TableRow<DevPatch, String> createDeviceTableRow(DevPatch devPatch, int index) {
        int count = 0;
        DevNode devNode = devPatch.getDevNode().get(index);
        DevPatch dp = new DevPatch();
        dp.setBatchInfo(devPatch.getBatchInfo());
        dp.getDevNode().add(devNode);
        String key = devNode.getDeviceSerialNumber() + devNode.getDeviceType();
        DefaultTableRow devTableRow = new DefaultTableRow(this.layout.getTable().getColumnCount(), (Object)dp, (Object)key);
        devTableRow.setValueAt(count++, (Object)DevicePatchUtil.getDisplayModel(devNode));
        devTableRow.setValueAt(count++, (Object)devNode.getProductVersion());
        devTableRow.setValueAt(count++, (Object)devNode.getIp());
        devTableRow.setValueAt(count++, (Object)(StringUtils.isNULLStr((String)devNode.getDeviceName()) ? "--" : devNode.getDeviceName()));
        devTableRow.setValueAt(count++, (Object)devPatch.getBatchInfo().getCurrentVer());
        devTableRow.setValueAt(count++, (Object)devPatch.getBatchInfo().getVersion());
        return devTableRow;
    }

    private TableRow<DevPatch, String> createDeviceTableRow(DevNode devNode) {
        int count = 0;
        DevPatch dp = new DevPatch();
        dp.getDevNode().add(devNode);
        String key = devNode.getDeviceSerialNumber() + devNode.getDeviceType();
        DefaultTableRow devTableRow = new DefaultTableRow(this.layout.getTable().getColumnCount(), (Object)dp, (Object)key);
        devTableRow.setValueAt(count++, (Object)DevicePatchUtil.getDisplayModel(devNode));
        devTableRow.setValueAt(count++, (Object)devNode.getProductVersion());
        devTableRow.setValueAt(count++, (Object)devNode.getIp());
        devTableRow.setValueAt(count++, (Object)(StringUtils.isNULLStr((String)devNode.getDeviceName()) ? "--" : devNode.getDeviceName()));
        return devTableRow;
    }

    public boolean ending() {
        String batchPath = this.layout.getBatchPathInput().getText();
        if (this.checkBatchPath(batchPath = FilePathUtils.getSafePath((String)batchPath))) {
            return false;
        }
        String confSize = UserOpDataSaveUtil.getToolIniProp((String)"tool.patchpkg.memory");
        if (this.checkConfSize(batchPath, confSize)) {
            return false;
        }
        long fileRealSize = ZipSizeUtils.getRealSize(batchPath);
        if (this.checkFileRealSize(fileRealSize)) {
            return false;
        }
        List<?> result = this.getResult(batchPath);
        if (CollectionUtil.isEmpty(result)) {
            return true;
        }
        String msg = (String)result.get(0);
        List<String> currenTableNodeIpSet = this.getCurrenTableNodeIpSet();
        if (!StringUtils.isNULLStr((String)msg)) {
            DialogUtils.showInfoDialog((JDialog)PatchDataContext.getInstance().getWizDialog(), (String)msg);
            for (String ip : currenTableNodeIpSet) {
                log.info("Choose patch : {} for device {} failed.", (Object)batchPath, (Object)ip);
            }
            return false;
        }
        DevicePatchMainDialog mainDialog = PatchDataContext.getInstance().getMainDialog();
        mainDialog.initPatchData();
        for (String ip : currenTableNodeIpSet) {
            log.info("Choose patch : " + batchPath + " for device " + ip + " success.");
        }
        return true;
    }

    private List<String> getCurrenTableNodeIpSet() {
        ArrayList<String> currenTableNodeIpSet = new ArrayList<String>();
        try {
            int rowCount = this.layout.getTable().getRowCount();
            if (rowCount != 0) {
                for (int index = 0; index < rowCount; ++index) {
                    TableRow row = this.layout.getTable().getRow(index);
                    currenTableNodeIpSet.add(((DevPatch)row.getUserObject()).getDevNode().get(0).getIp());
                }
            }
        }
        catch (Exception e) {
            log.error("Log records failed.", (Throwable)e);
        }
        return currenTableNodeIpSet;
    }

    private List<?> getResult(String batchPath) {
        return AsyncExcutor.execute((Window)PatchDataContext.getInstance().getWizDialog(), (String)ResourceUtil.getString((String)"patch.card.setpatchinfo.pkg.cheaking"), (int)220, (Callable[])new Callable[]{new ParserPatchPkgFile(batchPath)});
    }

    private boolean checkFileRealSize(long fileRealSize) {
        if (fileRealSize > 0x80000000L) {
            DialogUtils.showInfoDialog((JDialog)PatchDataContext.getInstance().getWizDialog(), (String)ResourceUtil.getString((String)"patch.dialog.detail.batchpkg.outsize"));
            return true;
        }
        return false;
    }

    private boolean checkConfSize(String batchPath, String confSize) {
        if (StringUtils.isDigit((String)confSize) && new File(batchPath).getFreeSpace() < (long)StringUtils.str2Int((String)confSize) * 1024L * 1024L) {
            DialogUtils.showInfoDialog((JDialog)PatchDataContext.getInstance().getWizDialog(), (String)MessageFormat.format(ResourceUtil.getString((String)"patch.dialog.detail.batchpkg.insufficiency"), confSize));
            return true;
        }
        return false;
    }

    private boolean checkBatchPath(String batchPath) {
        if (StringUtils.isNULLStr((String)batchPath)) {
            DialogUtils.showInfoDialog((JDialog)PatchDataContext.getInstance().getWizDialog(), (String)ResourceUtil.getString((String)"patch.card.step2.showinfo.choose.patchpath"));
            return true;
        }
        return false;
    }

    public boolean flowExiting() {
        return true;
    }

    private static class ParserPatchPkgFile
    implements Callable<String> {
        private String path;

        public ParserPatchPkgFile(String path) {
            this.path = path;
        }

        @Override
        public String call() {
            return PatchService.getInstance().checkPatchDirBranch(this.path);
        }
    }
}

