/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.ui.card;

import com.huawei.ism.tool.base.ui.wizard.FlowWizardCard;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCardLayout;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.service.PatchService;
import com.huawei.ism.tool.devicepatch.ui.card.EvaluStrategyCardLayout;
import com.huawei.ism.tool.devicepatch.ui.main.DevicePatchMainDialog;
import com.huawei.ism.tool.devicepatch.utils.DevicePatchUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluStrategyCard
extends FlowWizardCard {
    private static final Logger log = LoggerFactory.getLogger(EvaluStrategyCard.class);
    private EvaluStrategyCardLayout layout;

    private void setLayoutComboxExplainLabel() {
        DevPatch emptyDevPatch;
        List<DevPatch> devPatchList = PatchDataContext.getInstance().getTmpDevPatchs();
        String productModel = this.getProductModel(devPatchList, emptyDevPatch = new DevPatch());
        if (Objects.equals(productModel, "OceanStor A800")) {
            this.layout.setComboxExplainLabel(ResourceUtil.getString((String)"patch.card.strategy.combox.a800.explain"));
            return;
        }
        this.layout.setComboxExplainLabel(ResourceUtil.getString((String)"patch.card.strategy.combox.explainOld"));
    }

    @NotNull
    private String getProductModel(List<DevPatch> devPatchList, DevPatch emptyDevPatch) {
        return devPatchList.stream().findFirst().orElse(emptyDevPatch).getDevNode().stream().findFirst().map(DevNode::getDeviceType).map(Objects::toString).orElse("");
    }

    protected FlowWizardCardLayout getLayout() {
        return this.layout;
    }

    protected boolean init() {
        this.layout = new EvaluStrategyCardLayout();
        this.setLayoutComboxExplainLabel();
        this.layout.initCardLayout();
        this.layout.getTargetVerInput().addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent event) {
                event.setKeyChar(String.valueOf(event.getKeyChar()).toUpperCase(Locale.US).charAt(0));
            }
        });
        return true;
    }

    public boolean ending() {
        String targetPatchVer = this.layout.getTargetVerInput().getText().trim();
        String destRegex = "(^V\\d{3}R\\d{3}C\\d{2}SPH\\d{3}?$|\\d+\\.\\d+\\.\\d*[RC|T]*\\d+\\.SPH?\\d+?$)";
        Pattern pattern = Pattern.compile(destRegex);
        Matcher matcher = pattern.matcher(targetPatchVer);
        if (StringUtils.isNULLStr((String)targetPatchVer) || !matcher.find()) {
            DialogUtils.showInfoDialog((JDialog)PatchDataContext.getInstance().getWizDialog(), (String)ResourceUtil.getString((String)"patch.card.strategy.combox.valid"));
            return false;
        }
        List<DevPatch> devPatchList = PatchDataContext.getInstance().getTmpDevPatchs();
        DevPatch emptyDevPatch = new DevPatch();
        String curPatchVersion = devPatchList.stream().findFirst().orElse(emptyDevPatch).getBatchInfo().getCurrentVer();
        String productVersion = this.getProductVersion(devPatchList, emptyDevPatch);
        log.info("curPathVersion:{} ,hotPatchVersion:{}", (Object)curPatchVersion, (Object)targetPatchVer);
        if (!DevicePatchUtil.isIgnoreSpcSphMatch() && DevicePatchUtil.checkConsistentVersions(productVersion, curPatchVersion, targetPatchVer)) {
            DialogUtils.showInfoDialog((JDialog)PatchDataContext.getInstance().getWizDialog(), (String)ResourceUtil.getString((String)"patch.card.strategy.combox.version.consistent"));
            return false;
        }
        if (!DevicePatchUtil.isIgnoreSpcSphMatch() && !DevicePatchUtil.isPatchMatchSysVer(devPatchList, targetPatchVer)) {
            DialogUtils.showInfoDialog((JDialog)PatchDataContext.getInstance().getWizDialog(), (String)ResourceUtil.getString((String)"patch.card.strategy.combox.not.match"));
            return false;
        }
        PatchDataContext.getInstance().setTmpDevPatchsBranch(devPatchList);
        for (DevPatch devPatch : devPatchList) {
            devPatch.getBatchInfo().setVersion(targetPatchVer);
        }
        PatchService.getInstance().saveBranchId(devPatchList, "PATCH_EVALU");
        PatchService.getInstance().clearAndSaveData();
        DevicePatchMainDialog mainDialog = PatchDataContext.getInstance().getMainDialog();
        mainDialog.initPatchData();
        return true;
    }

    private String getProductVersion(List<DevPatch> devPatchList, DevPatch emptyDevPatch) {
        return devPatchList.stream().findFirst().orElse(emptyDevPatch).getDevNode().stream().findFirst().map(DevNode::getProductVersion).orElse("");
    }

    public boolean flowExiting() {
        return true;
    }
}

