/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.ui.listener;

import com.huawei.ism.tool.base.flow.FlowFactory;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardDialog;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.utils.PatchSceneUtil;
import com.huawei.ism.tool.obase.entity.KeyValue;
import com.huawei.ism.tool.obase.ui.base.ToolAction;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.util.SwingUtil;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceAddListener
extends ToolAction {
    private static final Logger log = LoggerFactory.getLogger(DeviceAddListener.class);
    private static final long serialVersionUID = 1L;
    private static final String DEFINE_XML_PATH = "config/wizard/ElementDefine.xml";
    private static final String FLOW_XML_PATH = "config/wizard/DevicePatchFlow.xml";
    private static final String FLOW_XML_PATH_EVALU = "config/wizard/PatchEvaluFlow.xml";
    private static final String FLOW_XML_A800_PATH = "config/wizard/A800DevicePatchFlow.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        log.info("Click Add Device.");
        Locale loc = ApplicationContext.getInstance().getCurrentLanguage();
        LoggerFactory.getLogger(DeviceAddListener.class).info("Locale lan is : " + loc.toString());
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            return;
        }
        InputStream defXml = cl.getResourceAsStream(DEFINE_XML_PATH);
        InputStream flowXml = null;
        try {
            flowXml = PatchSceneUtil.isPatchEvalu() ? cl.getResourceAsStream(FLOW_XML_PATH_EVALU) : (PatchSceneUtil.isA800HotPatch() ? cl.getResourceAsStream(FLOW_XML_A800_PATH) : cl.getResourceAsStream(FLOW_XML_PATH));
            KeyValue<InputStream, InputStream> flow = new KeyValue<InputStream, InputStream>(defXml, flowXml);
            FlowFactory ff = new FlowFactory(flow.getKey(), flow.getValue(), cl, loc);
            FlowWizardDialog wizard = new FlowWizardDialog((Window)PatchDataContext.getInstance().getMainDialog(), loc, ff, "");
            PatchDataContext.getInstance().setWizDialog(wizard);
            SwingUtil.putScreenCenter((Window)wizard);
            wizard.setVisible(true);
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)defXml);
            StreamUtils.closeStream(null, (InputStream)flowXml);
        }
    }
}

