/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.ui.listener;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.bizpack.BizPackage;
import com.huawei.ism.tool.bizpack.PackProduct;
import com.huawei.ism.tool.devicemanager.service.DefaultNodeTypeQuery;
import com.huawei.ism.tool.devicemanager.service.INodeObserver;
import com.huawei.ism.tool.devicemanager.service.INodeTypeQuery;
import com.huawei.ism.tool.devicemanager.service.ShowSysConstans;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceAddDialog;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.ui.card.AddDeviceCard;
import com.huawei.ism.tool.devicepatch.ui.card.DevNodeObserver;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.SettingType;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

public class PatchDeviceAddListener
extends MouseAdapter
implements INodeSupport {
    private AddDeviceCard card;
    private DefaultNodeTypeQuery nodeTypeQuery;

    public PatchDeviceAddListener(AddDeviceCard addDeviceCard) {
        this.card = addDeviceCard;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        List<DeviceType> supportTypes = this.getSupportTypes();
        DefaultNodeProviderImpl.getInstance().addNodeObservers((INodeObserver)new DevNodeObserver(this.card));
        this.nodeTypeQuery = new DefaultNodeTypeQuery(supportTypes, (INodeSupport)this, ShowSysConstans.getShowSysCmds());
        DeviceAddDialog.InfoTips tips = new DeviceAddDialog.InfoTips("devicemanager.layout.device.add.deviceadddialog.deviceduplicatebyupgrade");
        DeviceAddDialog deviceAddDialog = new DeviceAddDialog((Window)PatchDataContext.getInstance().getWizDialog(), (INodeTypeQuery)this.nodeTypeQuery, tips, new SettingType[]{SettingType.SshForward});
        deviceAddDialog.setVisible(true);
    }

    private List<DeviceType> getSupportTypes() {
        boolean isA800Scene = SceneUtils.isA800SceneInTool();
        ArrayList<DeviceType> supports = new ArrayList<DeviceType>();
        List<BizPackage> bizPackages = PatchDataContext.getInstance().getBizPackages();
        for (BizPackage bp : bizPackages) {
            for (PackProduct pp : bp.getPackProducts()) {
                if (this.filterSupportByScene(pp.getProductName(), isA800Scene)) continue;
                for (String ver : pp.getVersions()) {
                    supports.add(DeviceType.valueOf(pp.getProductName() + " " + ver));
                }
            }
        }
        return supports;
    }

    private boolean filterSupportByScene(String model, boolean isA800Scene) {
        return isA800Scene != ItDeviceType.A800_NODE.getName().equals(model);
    }

    public boolean isNodeSupport(DevNode dev) {
        if (dev.getItDeviceType() == ItDeviceType.DStorage) {
            return false;
        }
        return this.nodeTypeQuery.isDeviceTypeSupport(EntityUtils.toOldDev(dev));
    }
}

