/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.ui.listener;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.entity.ProcessingInfo;
import com.huawei.ism.tool.devicepatch.ui.listener.linkage.PatchLinkageCallable;
import com.huawei.ism.tool.devicepatch.ui.main.DevicePatchMainDialog;
import com.huawei.ism.tool.devicepatch.utils.DevicePatchUtil;
import com.huawei.ism.tool.devicepatch.utils.PatchSceneUtil;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JDialog;

public class PatchWindowListener
extends WindowAdapter {
    private DevicePatchMainDialog parent;

    public PatchWindowListener(DevicePatchMainDialog parent) {
        this.parent = parent;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        try {
            String patchRootPath = ApplicationContext.getInstance().getWorkPath();
            String unzipTempPath = patchRootPath + File.separator + "unzipTempDir";
            ToolLoggerFactory.getLogger(this.getClass()).info("unzipTempPath=" + unzipTempPath);
            FileUtils.deleteAllInFolder(unzipTempPath);
            DevicePatchUtil.cleanAllSubPatchPkg();
        }
        catch (RuntimeException ex) {
            ToolLoggerFactory.getLogger(this.getClass()).error("delete unzipfile exception.");
        }
        List<DevNode> devNodes = PatchDataContext.getInstance().getDevNodes();
        if (!PatchDataContext.getInstance().getUserOpDataList().isEmpty()) {
            ToolLoggerFactory.getLogger(this.getClass()).info("devicepatch:save user option data!");
            UserOpDataSaveUtil.batchSaveUserOpdata(PatchDataContext.getInstance().getUserOpDataList());
        }
        boolean allSucc = true;
        for (DevNode devNode : devNodes) {
            ProcessingInfo pinfo = PatchDataContext.getInstance().getProcessingInfo(devNode);
            if (pinfo == null || !DevPatch.DevPatchStatus.RUNNING.equals((Object)pinfo.getStatus())) continue;
            allSucc = false;
            break;
        }
        if (!allSucc) {
            WarningDialog wdialog = DialogUtils.createWarningDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"patch.main.button.showinfo.exit"));
            if (0 == wdialog.getValue()) {
                if (PatchSceneUtil.needSaveSceneTaskData()) {
                    PatchSceneUtil.finishedSceneTask();
                }
                for (DevNode devNode : devNodes) {
                    if (!PatchDataContext.isNeedOpenOrCloseTlv(devNode)) continue;
                    PatchDataContext.closeTlv(devNode);
                }
                this.parent.dispose();
                PatchDataContext.getInstance().clear();
                PatchDataContext.getInstance().fireToolStopped();
            }
        } else {
            if (PatchSceneUtil.needSaveSceneTaskData()) {
                PatchSceneUtil.finishedSceneTask();
            }
            this.parent.dispose();
            PatchDataContext.getInstance().clear();
            PatchDataContext.getInstance().fireToolStopped();
        }
    }

    @Override
    public void windowOpened(WindowEvent event) {
        AsyncExcutor.execute((Window)this.parent, (Callable[])new Callable[]{new PatchLinkageCallable(this.parent)});
    }
}

