/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.ui.listener;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.entity.ExecuteResult;
import com.huawei.ism.tool.devicepatch.entity.ProcessingInfo;
import com.huawei.ism.tool.devicepatch.service.A800RetryPatchService;
import com.huawei.ism.tool.devicepatch.ui.listener.entity.RetryData;
import com.huawei.ism.tool.devicepatch.ui.listener.service.RetryDataBuildService;
import com.huawei.ism.tool.devicepatch.ui.main.entity.enums.ZoneRunningStatus;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryAction
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(RetryAction.class);
    private final Window parent;
    private final RetryDataBuildService dataBuildService;

    @Override
    public void actionPerformed(ActionEvent e) {
        RetryData retryData = this.dataBuildService.buildRetryData();
        log.info("retry node :{} for zones :{}", (Object)retryData.getRetryNode().getIp(), retryData.getRetryParam());
        if (Objects.isNull(retryData.getRetryNode()) || CollectionUtil.isEmpty(retryData.getRetryParam())) {
            DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"select.node.for.retry"));
            return;
        }
        String ip = this.findNotFailedNode(retryData);
        if (!StringUtils.isNULLStr((String)ip)) {
            DialogUtils.showErrorDialog((Window)this.parent, (String)ResourceUtil.getStringWithParams((String)"select.node.running", (Object[])new Object[]{ip}));
            return;
        }
        if (this.confirmRetry()) {
            this.doRetry(retryData);
        }
    }

    private String findNotFailedNode(RetryData retryData) {
        if (this.isNodeRunning(retryData)) {
            return retryData.getRetryNode().getIp();
        }
        DevNode retryNode = retryData.getRetryNode();
        ProcessingInfo processInfo = PatchDataContext.getInstance().getProcessingInfo(retryNode);
        return processInfo.getResults().stream().filter(result -> !CollectionUtil.isEmpty(result.getSubResults())).filter(result -> result.getDescription().equals(retryData.getItemId())).findFirst().map(result -> this.findCanNotRetryZones(retryData, (ExecuteResult)result)).orElse("");
    }

    private boolean isNodeRunning(RetryData retryData) {
        return PatchDataContext.getInstance().getProcessingInfo(retryData.getRetryNode()).isTaskRunning();
    }

    private String findCanNotRetryZones(RetryData retryData, ExecuteResult result) {
        return result.getSubResults().stream().filter(sub -> retryData.getRetryParam().contains(sub.getDevNode().getUuid())).filter(sub -> !ZoneRunningStatus.UPD_UPD_FAIL.equals((Object)sub.getStatus())).map(ExecuteResult::getDevNode).map(DevNode::getIp).collect(Collectors.joining(","));
    }

    private void doRetry(RetryData retryData) {
        DevNode devNode = retryData.getRetryNode();
        try {
            new A800RetryPatchService().startRetry(devNode, retryData.getRetryParam(), retryData.getItemId());
        }
        catch (ToolException e) {
            DialogUtils.showErrorDialog((Window)this.parent, (String)e.getErrorLocaleDescription());
        }
    }

    private boolean confirmRetry() {
        WarningDialog warningDialog = DialogUtils.showYesNoConfirmDialog((Window)this.parent, (String)ResourceUtil.getString((String)"confirm.retry.info"), (String)ResourceUtil.getString((String)"confirm.retry"));
        log.info("user choose value :{} for retry", (Object)warningDialog.getValue());
        return 0 == warningDialog.getValue();
    }

    public RetryAction(Window parent, RetryDataBuildService dataBuildService) {
        this.parent = parent;
        this.dataBuildService = dataBuildService;
    }
}

