/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.ui.listener.linkage;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.service.PatchService;
import com.huawei.ism.tool.devicepatch.ui.listener.linkage.PatchLinkageParser;
import com.huawei.ism.tool.devicepatch.ui.main.DevicePatchMainDialog;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import org.slf4j.Logger;

public class PatchLinkageCallable
implements Callable<Boolean> {
    private static final Logger LOG = ToolLoggerFactory.getLogger(PatchLinkageCallable.class);
    private DevicePatchMainDialog dialog;

    public PatchLinkageCallable(DevicePatchMainDialog dialog) {
        this.dialog = dialog;
    }

    @Override
    public Boolean call() {
        PatchLinkageParser parser = new PatchLinkageParser();
        List<DevPatch> normalDevPaths = parser.getNormalDevPatchs();
        Map<DevNode, String> abnormalDevNodeMap = parser.getAbnormalDevNodeMap();
        if (!normalDevPaths.isEmpty()) {
            PatchDataContext.getInstance().setNeedLinkage(true);
        }
        Iterator<DevPatch> iterator = normalDevPaths.iterator();
        while (iterator.hasNext()) {
            try {
                DevPatch devPatch = iterator.next();
                boolean pass = PatchService.getInstance().checkLinkagePatch(devPatch.getBatchInfo().getPatchPath(), devPatch.getBatchInfo(), devPatch.getDevNode().get(0));
                if (pass) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("patch linkage check pass, ip=" + devPatch.getDevNode().get(0));
                    }
                    PatchDataContext.getInstance().setDevPatchs(devPatch);
                    continue;
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info("patch linkage check not pass, ip=" + devPatch.getDevNode().get(0));
                }
                iterator.remove();
                abnormalDevNodeMap.put(devPatch.getDevNode().get(0), "patch.script.parse.error");
            }
            catch (RuntimeException e) {
                LOG.error("patch linage check exception.", (Throwable)e);
            }
        }
        this.dialog.initPatchData();
        if (!abnormalDevNodeMap.isEmpty()) {
            Set<Map.Entry<DevNode, String>> entries = abnormalDevNodeMap.entrySet();
            StringBuffer deviceIpSb = new StringBuffer();
            for (Map.Entry<DevNode, String> entry : entries) {
                deviceIpSb.append(entry.getKey().getIp()).append(",");
                LOG.error("patch linkage error.ip=" + entry.getKey().getIp() + "errorMsg=" + entry.getValue());
            }
            String deviceIpStr = deviceIpSb.substring(0, deviceIpSb.lastIndexOf(","));
            String errorMsg = ResourceUtil.getStringWithParams((String)"patch.linkage.parse.error.desc", (Object[])new Object[]{deviceIpStr});
            DialogUtils.showErrorDialog((JDialog)this.dialog, (String)errorMsg);
        }
        return true;
    }
}

