/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.ui.listener.linkage;

import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.entity.PatchInfo;
import com.huawei.ism.tool.devicepatch.entity.PatchUserOpData;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.PriKeyInfo;
import com.huawei.ism.tool.obase.entity.Socks5Proxy;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.Base64EncodeUtils;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.ZipUtils;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PatchLinkageParser {
    private static final Logger log = LoggerFactory.getLogger(PatchLinkageParser.class);
    private static final int INT2 = 2;
    private static final String PATH_ROOT_PATH = ApplicationContext.getInstance().getWorkPath();
    private static final String UNZIP_TEMP_PATH = PATH_ROOT_PATH + File.separator + "unzipTempDir";
    private List<DevPatch> normalDevPatchs = new ArrayList<DevPatch>();
    private Map<DevNode, String> abnormalDevNodeMap = new HashMap<DevNode, String>();

    public PatchLinkageParser() {
        this.init();
    }

    public void init() {
        String paramFilePath = System.getenv("paramFile");
        if (SceneUtils.isSpecialScence((String)SceneUtils.getCurrentSubScene(), (String[])new String[]{"Daily Checks"}) || SceneUtils.isSpecialScence((String)SceneUtils.getCurrentSubScene(), (String[])new String[]{"Expansion Evaluation"}) || SceneUtils.isSpecialScence((String)SceneUtils.getCurrentSubScene(), (String[])new String[]{"FRU Replacement"})) {
            paramFilePath = SceneUtils.getSceneFilePath((String)"devicedatafile");
        }
        log.info("paramFilePath={}", (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)paramFilePath));
        if (StringUtils.isNULLStr(paramFilePath)) {
            log.error("paramFilePath is empty or secretKey is empty!{}", (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)paramFilePath));
            return;
        }
        File paramFile = new File(paramFilePath = FilePathUtils.getSafePath((String)paramFilePath));
        if (!paramFile.exists()) {
            log.info("paramFilePath not exsit!");
            return;
        }
        String content = StreamUtils.readStringFormFile(paramFile);
        if (!SceneUtils.isSpecialScence((String)SceneUtils.getCurrentSubScene(), (String[])new String[]{"Daily Checks"}) && !paramFile.delete()) {
            log.error("read data failed from {}", (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)paramFilePath));
        }
        JSONArray jsonArray = new JSONArray(content);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = (JSONObject)jsonArray.get(i);
            DevPatch devNode = this.toDevPatch(jsonObject);
            PatchUserOpData userOpData = new PatchUserOpData();
            if (null == devNode) continue;
            this.normalDevPatchs.add(devNode);
            try {
                boolean isLinkage = true;
                userOpData.setPatchVersion(jsonObject.getString("suggestPatchVersion"));
                DevNode deviceNode = devNode.getDevNode().get(0);
                userOpData.setDevNode(EntityUtils.toNewDev(deviceNode));
                userOpData.setPatchLinkage(isLinkage);
                PatchDataContext.getInstance().getUserOpDataMap().put(deviceNode, userOpData);
                continue;
            }
            catch (JSONException e) {
                log.error("set UserOpData exception.", (Throwable)e);
                return;
            }
        }
    }

    private DevPatch toDevPatch(JSONObject jsonObject) {
        PatchInfo patchInfo = null;
        DevNode devNode = new DevNode();
        devNode.setIp("");
        try {
            devNode.setIp(jsonObject.getString("devIp"));
            devNode.setDeviceType(DeviceType.valueOf(jsonObject.getString("devType")));
            devNode.setProductVersion(jsonObject.getString("devVersion"));
            devNode.setDeviceName(this.decodeByBase64(jsonObject.getString("devName")));
            devNode.setDeviceSerialNumber(jsonObject.getString("serialNo"));
            devNode.setPort(jsonObject.getInt("port"));
            devNode.setHotPatchVersion(jsonObject.getString("curPatchVersion"));
            String debugPwd = jsonObject.getString("developerPwd");
            devNode.setDeveloperPwd(AESEncrypt.decrypt((String)debugPwd));
            debugPwd = "";
            String pwd = jsonObject.getString("password");
            User user = new User(this.decodeByBase64(jsonObject.getString("username")), AESEncrypt.decrypt((String)pwd));
            devNode.setLoginUser(user);
            pwd = "";
            patchInfo = new PatchInfo(jsonObject.getString("suggestPatchVersion"));
            patchInfo.setCurrentVer(jsonObject.getString("curPatchVersion"));
            String hotPatchPath = this.checkHotPatchPath(jsonObject.getString("hotPatchPath"));
            patchInfo.setPatchPath(hotPatchPath);
            this.handleDevIpsAndSocks(jsonObject, devNode);
            this.handleDevSshForward(jsonObject, devNode);
            this.handlePriKey(jsonObject, devNode);
        }
        catch (JSONException e) {
            log.error("toDevPatch json exception.", (Throwable)e);
            this.abnormalDevNodeMap.put(devNode, "patch.json.parse.error");
            return null;
        }
        catch (IsmException e) {
            log.error("toDevPatch ism exception.", (Throwable)e);
            this.abnormalDevNodeMap.put(devNode, e.getErrorMessage());
            return null;
        }
        catch (RuntimeException e) {
            log.error("toDevPatch runtime exception.", (Throwable)e);
            this.abnormalDevNodeMap.put(devNode, "patch.json.parse.exception");
            return null;
        }
        DevPatch devPatch = new DevPatch();
        devPatch.setBatchInfo(patchInfo);
        ArrayList<DevNode> devNodes = new ArrayList<DevNode>();
        devNodes.add(devNode);
        devPatch.setDevNode(devNodes);
        return devPatch;
    }

    private String checkHotPatchPath(String packageFullName) {
        log.info("enter get hotpatch path.");
        File packageFile = new File(packageFullName);
        if (!packageFile.exists()) {
            log.error("hotpatchpath not exist.path={}", (Object)packageFullName);
            throw new IsmException("patch.linkage.package.notexist");
        }
        String fileType = packageFullName.substring(packageFullName.lastIndexOf(46) + 1);
        String actualPackageFullName = packageFullName;
        if (fileType.equalsIgnoreCase("zip") && "".equals(actualPackageFullName = this.extractTgzFromZip(actualPackageFullName))) {
            throw new IsmException("patch.linkage.package.notsupport");
        }
        return actualPackageFullName;
    }

    private String extractTgzFromZip(String zipPackageFullName) {
        File zipPackageFile = new File(zipPackageFullName);
        String packageName = zipPackageFullName.substring(zipPackageFullName.lastIndexOf(File.separator) + 1, zipPackageFullName.lastIndexOf(46));
        String unzipSubPath = UNZIP_TEMP_PATH + File.separator + packageName;
        if (new File(unzipSubPath).exists()) {
            return this.findTgzFromUnzipPath(unzipSubPath);
        }
        try {
            ZipUtils.decompressFile(zipPackageFile, unzipSubPath);
        }
        catch (IOException e) {
            log.error("zip decompress exception.", (Throwable)e);
            return "";
        }
        return this.findTgzFromUnzipPath(unzipSubPath);
    }

    public String findTgzFromUnzipPath(String unzipPath) {
        String tgzPackageFullName = "";
        int fileTotal = 0;
        boolean existTgz = false;
        boolean existSha256 = false;
        File unzipFile = new File(unzipPath);
        if (unzipFile.exists()) {
            for (File file : unzipFile.listFiles()) {
                ++fileTotal;
                String fileName = file.getName();
                String fileType = fileName.substring(fileName.lastIndexOf(46) + 1);
                if (fileType.equalsIgnoreCase("tgz")) {
                    tgzPackageFullName = unzipPath + File.separator + fileName;
                    existTgz = true;
                }
                if (!fileType.equalsIgnoreCase("sha256")) continue;
                existSha256 = true;
            }
        }
        if (fileTotal == 2 && existTgz && existSha256) {
            return tgzPackageFullName;
        }
        log.error("zip structure not support.");
        return "";
    }

    private void handleDevIpsAndSocks(JSONObject jsonObject, DevNode devNode) {
        JSONArray ipList = jsonObject.getJSONArray("devInnerIps");
        for (int j = 0; j < ipList.length(); ++j) {
            String ip = ipList.getString(j);
            devNode.addIp(ip);
        }
        try {
            if (jsonObject.has("sock5")) {
                JSONObject jsonDevSocks5 = new JSONObject(jsonObject.getString("sock5"));
                Socks5Proxy socks5Proxy = this.toDevNodeSocks5(jsonDevSocks5);
                devNode.setSocks5Proxy(socks5Proxy);
            } else {
                devNode.setSocks5Proxy(null);
            }
        }
        catch (JSONException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("Socks5 does not exist on the device", (Throwable)e);
            devNode.setSocks5Proxy(null);
        }
    }

    private Socks5Proxy toDevNodeSocks5(JSONObject jsonSocks5) throws JSONException {
        Socks5Proxy socks5Proxy = new Socks5Proxy();
        socks5Proxy.setPort(jsonSocks5.getString("port"));
        socks5Proxy.setName(this.decodeByBase64(jsonSocks5.getString("name")));
        socks5Proxy.setServerIp(jsonSocks5.getString("serverIp"));
        socks5Proxy.setUuid(jsonSocks5.getString("uuid"));
        socks5Proxy.setUser(this.decodeByBase64(jsonSocks5.getString("user")));
        String pwd = jsonSocks5.getString("pass");
        socks5Proxy.setPass(AESEncrypt.decrypt((String)pwd));
        socks5Proxy.setAuthentic(jsonSocks5.getBoolean("authentic"));
        pwd = "";
        return socks5Proxy;
    }

    private void handleDevSshForward(JSONObject jsonObject, DevNode devNode) {
        try {
            if (jsonObject.has("sshForward")) {
                JSONArray jsonArraySsh = new JSONArray(jsonObject.getString("sshForward"));
                ArrayList<MultiRouteNode> muList = new ArrayList<MultiRouteNode>();
                for (int k = 0; k < jsonArraySsh.length(); ++k) {
                    JSONObject jsonSsh = jsonArraySsh.getJSONObject(k);
                    String pwd = jsonSsh.getString("pwd");
                    MultiRouteNode multiRouteNode = new MultiRouteNode(jsonSsh.getString("host"), jsonSsh.getInt("port"), this.decodeByBase64(jsonSsh.getString("uname")), AESEncrypt.decrypt((String)pwd));
                    muList.add(multiRouteNode);
                    pwd = null;
                }
                devNode.setSshForwardList(muList);
            } else {
                devNode.setSshForwardList(null);
            }
        }
        catch (JSONException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("SSH does not exist on the device", (Throwable)e);
            devNode.setSshForwardList(null);
        }
    }

    private void handlePriKey(JSONObject jsonObject, DevNode devNode) {
        try {
            if (jsonObject.has("priKey")) {
                JSONObject jsonDevPriKey = new JSONObject(jsonObject.getString("priKey"));
                PriKeyInfo info = new PriKeyInfo();
                info.setKeyName(this.decodeByBase64(jsonDevPriKey.getString("keyname")));
                info.setKeyPath(this.decodeByBase64(jsonDevPriKey.getString("keypath")));
                info.setKeyPwd(AESEncrypt.decrypt((String)jsonDevPriKey.getString("keypwd")));
                devNode.setPriKey(info);
            }
        }
        catch (JSONException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("PriKey does not exist on the device");
        }
    }

    private String decodeByBase64(String content) {
        return Base64EncodeUtils.decode(content);
    }

    public Map<DevNode, String> getAbnormalDevNodeMap() {
        return this.abnormalDevNodeMap;
    }

    public List<DevPatch> getNormalDevPatchs() {
        return this.normalDevPatchs;
    }
}

