/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.ui.main;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.entity.ExecuteResult;
import com.huawei.ism.tool.devicepatch.ui.main.ProgressPanel;
import com.huawei.ism.tool.devicepatch.utils.DevicePatchConstants;
import com.huawei.ism.tool.devicepatch.utils.ItemProgressUpdateUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailListCellRender
extends DefaultListCellRenderer {
    private static final Logger log = LoggerFactory.getLogger(DetailListCellRender.class);
    private static final long serialVersionUID = 100000010L;
    private static final int NUM_8 = 8;
    private static final int NUM_18 = 18;
    private static final int NUM_39 = 39;
    private static final int NUM_100 = 100;
    private static final int NUM_180 = 180;
    private static final int NUM_280 = 280;
    private static final int NUM_520 = 520;
    private static final Color COLOR_BEFORE_CLICK = new Color(4359891);

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Color bg = null;
        boolean isComponentSelected = isSelected;
        JComponent statusLabel = null;
        JList.DropLocation dropLocation = list.getDropLocation();
        if (dropLocation != null && !dropLocation.isInsert() && dropLocation.getIndex() == index) {
            bg = UIManager.getColor("List.dropCellBackground");
            isComponentSelected = true;
        }
        ProgressPanel viewPan = new ProgressPanel();
        if (value instanceof ExecuteResult) {
            ExecuteResult result = (ExecuteResult)value;
            JLabel devNodeLabel = new JLabel();
            devNodeLabel.setPreferredSize(new Dimension(100, devNodeLabel.getPreferredSize().height));
            int dLength = 0;
            if (result.getDevNode() != null) {
                String ip = result.getDevNode().getIp();
                int len = ip.length();
                int n = dLength = 280 * len / 39 - 100 > 180 ? 180 : 280 * len / 39 - 100;
                if (StringUtils.isIpv6Address((String)ip) && dLength > 0) {
                    devNodeLabel.setPreferredSize(new Dimension(dLength + 100, devNodeLabel.getPreferredSize().height));
                }
                devNodeLabel.setText(result.getDevNode().getIp());
            }
            String date = result.getStartDateString();
            JLabel descLabel = new JLabel(result.getDescription());
            Dimension descLabelSize = new Dimension(280 - dLength, 18);
            UiMethod.setComponentSize(descLabelSize, descLabel);
            JComponent dateComp = UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{Box.createHorizontalStrut(5), new JLabel(date)});
            JLabel resultLabel = new JLabel("");
            statusLabel = this.getjComponent(viewPan, result, resultLabel);
            JComponent view = UCD.buildHorizotalBox(null, (Component[])new Component[]{dateComp, devNodeLabel, descLabel, Box.createGlue(), UCD.buildHBoxRight((Component[])new Component[]{statusLabel}), resultLabel, Box.createHorizontalStrut(8)});
            viewPan.setLayout(new BorderLayout());
            viewPan.add((Component)view, "North");
            this.viewPanSetTips(viewPan, result);
        }
        viewPan.setComponentOrientation(list.getComponentOrientation());
        viewPan.setEnabled(list.isEnabled());
        viewPan.setFont(list.getFont());
        this.viewPanSetBackgroundAndForeground(list, isComponentSelected, bg, viewPan);
        return viewPan;
    }

    private void viewPanSetTips(ProgressPanel viewPan, ExecuteResult result) {
        String tips = result.isSuccess() ? result.getDescription() : ResourceUtil.getString((String)"patch.detailListcellrender.fail.tip");
        viewPan.setToolTipText(tips);
    }

    private void viewPanSetBackgroundAndForeground(JList list, boolean isSelected, Color bg, ProgressPanel viewPan) {
        if (isSelected) {
            viewPan.setBackground(bg == null ? list.getSelectionBackground() : bg);
            UiMethod.setBatchComponentProperty("setForeground", new Object[]{Color.WHITE}, viewPan);
        } else {
            viewPan.setBackground(list.getBackground());
            viewPan.setForeground(list.getForeground());
        }
    }

    private JComponent getjComponent(ProgressPanel viewPan, ExecuteResult result, JLabel resultLabel) {
        JComponent statusLabel;
        resultLabel.setForeground(COLOR_BEFORE_CLICK);
        if (!result.isProcessing()) {
            if (result.isSuccess()) {
                resultLabel.setIcon(DevicePatchConstants.SUCCESS_IMAGE);
                resultLabel.setText(DevPatch.DevPatchStatus.COMPLETED.toString());
            } else {
                resultLabel.setIcon(DevicePatchConstants.FAILED_IMAGE);
                resultLabel.setText(DevPatch.DevPatchStatus.FAILED.toString());
            }
            statusLabel = new JLabel("");
        } else {
            resultLabel.setIcon(DevicePatchConstants.PROCESSING_IMAGE);
            resultLabel.setText(DevPatch.DevPatchStatus.RUNNING.toString());
            statusLabel = this.createCheckingView(result, viewPan);
        }
        return statusLabel;
    }

    private JComponent createCheckingView(ExecuteResult evaluItem, ProgressPanel panel) {
        JComponent statusLabel = null;
        DevicePatchConstants.PROCESSING_IMAGE.setImageObserver(PatchDataContext.getInstance().getMainDialog());
        String devIp = evaluItem.getDevNode().getIp();
        int progress = ItemProgressUpdateUtil.INS.getProgress(devIp);
        log.info("create Checking process, evalu item:{},devIp:{},progress:{}", new Object[]{evaluItem.getItemId(), devIp, progress});
        if (progress >= 0 && progress <= 100) {
            String timeLeft = ItemProgressUpdateUtil.INS.getTimeLeft(devIp);
            if (StringUtils.isNULLStr((String)timeLeft)) {
                statusLabel = UCD.buildHorizotalBox(null, (Component[])new Component[]{new JLabel(ResourceUtil.getStringWithParams((String)"evalu.device.item.wait.progress", (Object[])new Object[]{progress})), Box.createHorizontalStrut(12)});
            } else {
                int timeLeftMin = Integer.parseInt(timeLeft) / 60;
                int timeLeftSen = Integer.parseInt(timeLeft) - timeLeftMin * 60;
                statusLabel = UCD.buildHorizotalBox(null, (Component[])new Component[]{new JLabel(ResourceUtil.getStringWithParams((String)"evalu.device.item.wait.progress", (Object[])new Object[]{progress})), Box.createHorizontalStrut(12), new JLabel(ResourceUtil.getStringWithParams((String)"evalu.device.item.wait.progress.timeleft", (Object[])new Object[]{String.valueOf(timeLeftMin), String.valueOf(timeLeftSen)})), Box.createHorizontalStrut(12)});
            }
            panel.setShow(true);
            panel.setProgress(progress);
        } else {
            statusLabel = new JLabel("");
        }
        return statusLabel;
    }
}

