/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.ui.main;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.NodeResult;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.entity.ExecuteResult;
import com.huawei.ism.tool.devicepatch.entity.PatchInfo;
import com.huawei.ism.tool.devicepatch.entity.ProcessingInfo;
import com.huawei.ism.tool.devicepatch.logic.DevPatchExcelWriter;
import com.huawei.ism.tool.devicepatch.service.PatchService;
import com.huawei.ism.tool.devicepatch.service.enums.OptionType;
import com.huawei.ism.tool.devicepatch.ui.listener.DetailHyLinkListener;
import com.huawei.ism.tool.devicepatch.ui.listener.DeviceAddListener;
import com.huawei.ism.tool.devicepatch.ui.listener.PatchWindowListener;
import com.huawei.ism.tool.devicepatch.ui.listener.entity.RetryData;
import com.huawei.ism.tool.devicepatch.ui.listener.service.impl.UiRetryDataBuildService;
import com.huawei.ism.tool.devicepatch.ui.main.DevicePatchMainDialogLayout;
import com.huawei.ism.tool.devicepatch.ui.main.IPatchUiObserver;
import com.huawei.ism.tool.devicepatch.ui.main.PatchStatusCell;
import com.huawei.ism.tool.devicepatch.ui.main.detail.ZoneDetailTableDialog;
import com.huawei.ism.tool.devicepatch.ui.main.dialog.ErrorDetailInfoDialog;
import com.huawei.ism.tool.devicepatch.ui.main.dialog.PatchComfirmDialog;
import com.huawei.ism.tool.devicepatch.ui.main.entity.ProgressParam;
import com.huawei.ism.tool.devicepatch.ui.main.entity.enums.ZoneRunningStatus;
import com.huawei.ism.tool.devicepatch.utils.DevicePatchUtil;
import com.huawei.ism.tool.devicepatch.utils.ItemProgressUpdateUtil;
import com.huawei.ism.tool.devicepatch.utils.PatchSceneUtil;
import com.huawei.ism.tool.devicepatch.utils.SceneDataParser;
import com.huawei.ism.tool.obase.entity.A800Node;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DmeNode;
import com.huawei.ism.tool.obase.filechooser.HibernateContainer;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.ui.dialogs.HelpTitleDialog;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ManualConfigItemMgr;
import com.huawei.ism.tool.obase.utils.OSCmdUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.plaf.armor.ArmorListUI;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ListUI;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.Products;

public class DevicePatchMainDialog
extends HelpTitleDialog
implements IPatchUiObserver {
    private static final Logger log = LoggerFactory.getLogger(DevicePatchMainDialog.class);
    public static final File IGNORE_ITEM_FILE = new File(ApplicationContext.getInstance().getWorkPath(), "ignoreitem.txt");
    public static final String SKIP_UPGRADE_COMPONENTS = "skip.upgrade.components";
    public static final String SET_HOTPATCH_INTERVAL = "set.hotpatch.interval";
    private static final long serialVersionUID = 1L;
    private static final String HELP_NAME = "Patch" + File.separator + "PatchTool";
    private static final String PATCH_EVALU_HELP_NAME = "Patch" + File.separator + "PatchEvalu";
    private static final String A800_PATCH_HELP_NAME = "Patch" + File.separator + "PatchTool_A800";
    private static final String A800_PATCH_EVALU_HELP_NAME = "Patch" + File.separator + "PatchEvalu_A800";
    private static final String SAVEPATH_DEFAULT_ID = "reportDir";
    private static final String PATCH_PROCESS_DETAIL = "patch.flow.detail.";
    private static final List<String> BMC_RISK_VERSION = Arrays.asList("V500R007C60SPC100", "V500R007C60SPC300", "V500R007C70SPC200", "V500R007C71SPC100", "6.0.0", "6.0.1", "6.1.0");
    private static final String PATCH_EVALU = "PatchEvalu";
    private DevicePatchMainDialogLayout layout = null;
    private ZoneDetailTableDialog zoneDetail;

    public DevicePatchMainDialog(Window parent) {
        super(parent, true);
        this.initUI();
        this.addListener();
        ManualConfigItemMgr.getInstance().init(IGNORE_ITEM_FILE);
        this.initNeedOpenVersions();
    }

    private void initNeedOpenVersions() {
        PatchDataContext.getInstance().setNeedOpenVersions(DevPatchExcelWriter.loadOpenTlvProduct());
    }

    public void initPatchData() {
        if (SceneUtils.isUpgradeSubScene()) {
            log.info("begin to init scene data.");
            SceneDataParser.init();
        }
        List<DevPatch> devPatchs = PatchDataContext.getInstance().getDevPatchs();
        this.layout.getTable().removeAll();
        for (DevPatch devp : devPatchs) {
            for (int i = 0; i < devp.getDevNode().size(); ++i) {
                TableRow<DevNode, String> row = this.createDeviceTableRow(devp, i, false);
                this.layout.getTable().addRow(new TableRow[]{row});
                this.initIgnoreItem(devp.getDevNode().get(i));
            }
            if (PatchSceneUtil.isScene()) {
                this.setSceneRowSelected(devp.getDevNode());
                continue;
            }
            if (!PatchDataContext.getInstance().isNeedLinkage()) continue;
            this.setSceneRowSelected(devp.getDevNode());
        }
        this.refreshDetailList();
    }

    private void initIgnoreItem(DevNode dev) {
        ManualConfigItemMgr.getInstance().addItem("global.soft.raid.check.for.system.partitions", "yes", ResourceUtil.getString((String)"patch.eval.ignoreitem.skip.soft.raid.check.tip"));
        ManualConfigItemMgr.getInstance().addItem("power.backend.upgrade.enable", "yes", ResourceUtil.getString((String)"patch.ignoreitem.power.backend.upgrade.enable.tip"));
        ManualConfigItemMgr.getInstance().addItem(dev.getIp(), SKIP_UPGRADE_COMPONENTS, "no", "");
        ManualConfigItemMgr.getInstance().addItem(dev.getIp(), SET_HOTPATCH_INTERVAL, "0", "Set patch upgrade interval, the range is:0.5~300, unit:second");
    }

    private void setSceneRowSelected(List<DevNode> devNodes) {
        for (DevNode devNode : devNodes) {
            if (!PatchSceneUtil.sceneSelectDevNode(devNode)) continue;
            try {
                int rowNum = this.layout.getTable().getRowIndex((Object)(devNode.getDeviceSerialNumber() + devNode.getDeviceType()));
                log.info("setSceneRowSelected:rowNum=" + rowNum);
                this.layout.getDevPatchTable().addRowSelectionInterval(rowNum, rowNum);
            }
            catch (Exception e) {
                log.error("setSceneRowSelected:", (Throwable)e);
            }
        }
    }

    private TableRow<DevNode, String> createDeviceTableRow(DevPatch devPatch, int index, boolean isModify) {
        DevNode devNode = devPatch.getDevNode().get(index);
        String key = devNode.getDeviceSerialNumber() + devNode.getDeviceType();
        DefaultTableRow row = new DefaultTableRow(this.layout.getTable().getColumnCount(), (Object)devNode, (Object)key);
        int pro = 0;
        String currentVer = null;
        ProcessingInfo info = PatchDataContext.getInstance().getProcessingInfo(devNode);
        if (info != null) {
            pro = info.getTotalProcess();
            currentVer = info.getCurrentVer();
        }
        if (StringUtils.isNULLStr(currentVer)) {
            currentVer = devPatch.getBatchInfo().getCurrentVer();
        }
        DevPatch.DevPatchStatus status = PatchService.getInstance().getStatus(devNode);
        if (isModify) {
            status = DevPatch.DevPatchStatus.ASSOCIATED;
            ProcessingInfo proInfo = PatchDataContext.getInstance().getProcessingInfo(devNode);
            proInfo.setStatus(status);
        }
        int i = 0;
        if (PatchSceneUtil.isA800PatchEval()) {
            row.setValueAt(i++, (Object)DevicePatchUtil.getA800Name(devNode.getDeviceSerialNumber()));
        }
        row.setValueAt(i++, (Object)(StringUtils.isNULLStr((String)devNode.getDeviceName()) ? "--" : devNode.getDeviceName()));
        row.setValueAt(i++, (Object)(DevicePatchUtil.getDisplayModel(devNode) + " " + devNode.getProductVersion()));
        row.setValueAt(i++, (Object)devNode.getIp());
        row.setValueAt(i++, (Object)currentVer);
        row.setValueAt(i++, (Object)devPatch.getBatchInfo().getVersion());
        row.setValueAt(i++, (Object)new IsmTableCell.ProgressCell(pro));
        row.setValueAt(i++, (Object)new PatchStatusCell(status));
        if (SceneUtils.isUpgradeSubScene() && status == DevPatch.DevPatchStatus.NOTASSOCIATED) {
            row.setValueAt(i++, (Object)new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"patch.main.no.select.patch.package"), (ActionListener)new DetailHyLinkListener(devPatch, devNode, false)));
        } else {
            row.setValueAt(i++, (Object)new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"patch.main.table.detail.content"), (ActionListener)new DetailHyLinkListener(devPatch, devNode, false)));
        }
        return row;
    }

    private void initUI() {
        this.layout = new DevicePatchMainDialogLayout();
        this.layout.setCompName();
        this.setLayout(new BorderLayout());
        this.add(this.layout);
        this.setTitle(ResourceUtil.getString((String)"patch.enter.title"));
        this.setModal(true);
        this.setResizable(false);
        this.validate();
        this.pack();
        this.setIconImage(ResourceUtil.getImage((String)"DevicePatch.png").getImage());
        this.setDefaultCloseOperation(0);
        SwingUtil.putScreenCenter((Window)this);
    }

    private void addListener() {
        this.addWindowListener(new PatchWindowListener(this));
        this.layout.getAddDeviceButton().addActionListener(new DeviceAddListener());
        this.layout.getConfigButton().addActionListener(new DeviceAddListener());
        this.layout.getDeleteDeviceButton().addActionListener(arg0 -> this.delDevNodes());
        this.layout.getStartPatchButton().addActionListener(arg0 -> this.startBatch(OptionType.UPGRADE));
        this.layout.getRollbackButton().addActionListener(e -> this.startBatch(OptionType.ROLLBACK));
        this.layout.getDevPatchTable().addMouseListener((MouseListener)this.getMouseListener());
        this.layout.getDetailList().addMouseListener(new ListMouseAdapter());
        JButton reportBtn = this.layout.getSetReportDirBtn();
        reportBtn.addActionListener(event -> {
            log.info("Operate: click set report button");
            this.setReportDir();
        });
        JButton openResultBtn = this.layout.getOpenEvaluResult();
        openResultBtn.addActionListener(e -> OSCmdUtils.openFile(PatchDataContext.getInstance().getReportDir()));
        JButton viewReportBtn = this.layout.getViewEvaluReport();
        viewReportBtn.addActionListener(e -> {
            if (PatchDataContext.getInstance().isRunEvaluing()) {
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"patch.main.dialog.not.view.report.tip"));
                return;
            }
            File htmlFile = new File(PatchDataContext.getInstance().getReportHtml());
            if (!htmlFile.exists()) {
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"patch.main.dialog.have.no.report"));
                return;
            }
            OSCmdUtils.openFile(new File(PatchDataContext.getInstance().getReportHtml()));
        });
    }

    @NotNull
    private MouseAdapter getMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                DevicePatchMainDialog.this.refreshDetailList();
            }
        };
    }

    private void startBatch(OptionType optionType) {
        PatchComfirmDialog patchComfirmDialog;
        log.info("start Performing Patching.");
        List rows = this.layout.getDevPatchTable().getMarkedRows();
        ArrayList<DevNode> nodes = new ArrayList<DevNode>();
        if (rows.isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)this, (String)this.getSelectTips());
            return;
        }
        ArrayList<String> notAssociatedNodes = new ArrayList<String>();
        for (TableRow row : rows) {
            DevNode node = (DevNode)row.getUserObject();
            DevPatch.DevPatchStatus status = PatchService.getInstance().getStatus(node);
            if (OptionType.UPGRADE.equals((Object)optionType)) {
                if (status.equals((Object)DevPatch.DevPatchStatus.ASSOCIATED) || status.equals((Object)DevPatch.DevPatchStatus.FAILED) || status.equals((Object)DevPatch.DevPatchStatus.NOTEVALU) || PatchSceneUtil.isPatchEvalu() && status.equals((Object)DevPatch.DevPatchStatus.COMPLETED)) {
                    nodes.add(node);
                } else if (status.equals((Object)DevPatch.DevPatchStatus.NOTASSOCIATED)) {
                    notAssociatedNodes.add(node.getIp());
                }
            }
            if (optionType != OptionType.ROLLBACK || !status.equals((Object)DevPatch.DevPatchStatus.FAILED)) continue;
            nodes.add(node);
        }
        if (!notAssociatedNodes.isEmpty()) {
            String ipStr = org.apache.commons.lang3.StringUtils.join(notAssociatedNodes, (String)",");
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getStringWithParams((String)"patch.main.button.showinfo.notassociate", (Object[])new Object[]{ipStr}));
            return;
        }
        if (nodes.isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"patch.main.button.showinfo.checkselect"));
            return;
        }
        if (!this.checkA800Status(optionType, nodes)) {
            return;
        }
        if (!PatchSceneUtil.isPatchEvalu() && OptionType.UPGRADE.equals((Object)optionType) && !(patchComfirmDialog = new PatchComfirmDialog((JDialog)this, nodes)).isOk()) {
            return;
        }
        PatchService.getInstance().startBatch(nodes, optionType);
    }

    private String getSelectTips() {
        if (PatchSceneUtil.isA800PatchEval() || PatchSceneUtil.isPatchEvalu()) {
            return ResourceUtil.getString((String)"patch.main.button.showinfo.select.eval.nodes");
        }
        return ResourceUtil.getString((String)"patch.main.button.showinfo.selectnodes");
    }

    private boolean checkA800Status(OptionType optionType, List<DevNode> nodes) {
        if (!SceneUtils.isA800SceneInTool()) {
            return true;
        }
        if (OptionType.UPGRADE.equals((Object)optionType)) {
            return this.checkUpgrade(nodes);
        }
        if (OptionType.ROLLBACK.equals((Object)optionType)) {
            return this.checkRollback(nodes);
        }
        return true;
    }

    private boolean checkRollback(List<DevNode> nodes) {
        String canNotRollbackIps = nodes.stream().filter(node -> !this.canRollback((DevNode)node)).map(DevNode::getIp).collect(Collectors.joining(","));
        if (!canNotRollbackIps.isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getStringWithParams((String)"can.not.rollback", (Object[])new Object[]{canNotRollbackIps}));
            return false;
        }
        WarningDialog warningDialog = DialogUtils.showYesNoConfirmDialog((Window)this, (String)ResourceUtil.getString((String)"rollback.confirm.tip"), (String)ResourceUtil.getString((String)"rollback.confirm.info"));
        log.info("user choose value for rollback :{}", (Object)warningDialog.getValue());
        return 0 == warningDialog.getValue();
    }

    private boolean canRollback(DevNode node) {
        if (!PatchDataContext.getInstance().hasNodeExecuted(node)) {
            return false;
        }
        return PatchDataContext.getInstance().getProcessingInfo(node).getResults().stream().filter(this::isUpgradeStep).findFirst().map(result -> !result.isSuccess()).orElse(false);
    }

    private boolean checkUpgrade(List<DevNode> nodes) {
        String executedIps = nodes.stream().filter(PatchDataContext.getInstance()::hasNodeExecuted).filter(this::upgradeExecuted).map(DevNode::getIp).collect(Collectors.joining(","));
        if (executedIps.isEmpty()) {
            return true;
        }
        DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getStringWithParams((String)"upgrade.executed", (Object[])new Object[]{executedIps}));
        return false;
    }

    private boolean upgradeExecuted(DevNode node) {
        ProcessingInfo processingInfo = PatchDataContext.getInstance().getProcessingInfo(node);
        return processingInfo.getResults().stream().anyMatch(this::isUpgradeStep);
    }

    private boolean isUpgradeStep(ExecuteResult result) {
        return ResourceUtil.getString((String)"patch.flow.detail.upgrade").equals(result.getDescription());
    }

    private void delDevNodes() {
        log.info("start delete devNodes.");
        if (this.layout.getDevPatchTable().getMarkedRows().isEmpty()) {
            log.info("No device deleted");
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"patch.main.button.showinfo.remove"));
            return;
        }
        ArrayList<DevNode> nods = new ArrayList<DevNode>();
        List rows = this.layout.getDevPatchTable().getMarkedRows();
        ArrayList<TableRow> rmRows = new ArrayList<TableRow>();
        for (Object row : rows) {
            DevNode node = (DevNode)row.getUserObject();
            DevPatch.DevPatchStatus status = PatchService.getInstance().getStatus(node);
            if (!status.equals((Object)DevPatch.DevPatchStatus.RUNNING)) {
                nods.add(node);
                rmRows.add((TableRow)row);
                continue;
            }
            try {
                log.info("Remove device " + node.getIp() + " failed.  The device is patching.");
            }
            catch (Exception e) {
                log.error("Log records failed.", (Throwable)e);
            }
        }
        if (nods.isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"patch.main.button.showinfo.canotremove"));
            return;
        }
        WarningDialog wd = DialogUtils.showYesNoDialog((Window)this, (String)ResourceUtil.getString((String)"patch.main.button.showinfo.removecheck"));
        if (0 == wd.getValue()) {
            this.layout.getTable().removeRow(rmRows);
            PatchService.getInstance().removeDevNode(nods);
            try {
                for (DevNode node : nods) {
                    log.info("Remove device : " + node.getIp() + " success");
                }
            }
            catch (Exception e) {
                log.error("Log records failed.", (Throwable)e);
            }
        }
        wd.dispose();
        this.refreshDetailList();
        log.info("delete devNodes end.");
    }

    public void modifyPath(DevPatch devPatch) {
        for (int i = 0; i < devPatch.getDevNode().size(); ++i) {
            DevPatch.DevPatchStatus status = PatchService.getInstance().getStatus(devPatch.getDevNode().get(i));
            if (DevPatch.DevPatchStatus.RUNNING.equals((Object)status)) continue;
            TableRow<DevNode, String> row = this.createDeviceTableRow(devPatch, i, true);
            this.layout.getTable().updateRow(new TableRow[]{row});
        }
    }

    public void resultCallBack(DevNode node) {
        this.refreshDetailList();
        this.refreshTable(node);
        this.getBottomDetailList();
    }

    private void refreshDetailList() {
        this.layout.getDetailList().setListData(new ExecuteResult[0]);
        DevNode node = this.getChooseDevNode();
        this.setListDate(node);
    }

    private void setListDate(DevNode node) {
        if (null == node) {
            return;
        }
        List<ExecuteResult> results = PatchDataContext.getInstance().getProcessingInfo(node).getResults();
        if (null != results) {
            this.layout.getDetailList().setListData(results.toArray());
            this.updateDetail(results);
        }
    }

    private void updateDetail(List<ExecuteResult> results) {
        if (this.zoneDetail != null && this.zoneDetail.isVisible()) {
            results.stream().filter(result -> result.getDescription().equals(this.zoneDetail.getCurrentItemId())).findFirst().ifPresent(result -> this.zoneDetail.updateData(result.getSubResults()));
        }
    }

    private DevNode getChooseDevNode() {
        int[] rows = this.layout.getDevPatchTable().getSelectedRows();
        if (rows == null || rows.length == 0 || rows.length > 1) {
            return null;
        }
        int index = this.layout.getDevPatchTable().convertRowIndexToModel(rows[0]);
        TableRow row = this.layout.getTable().getRow(index);
        DevNode devNode = (DevNode)row.getUserObject();
        return devNode;
    }

    private void refreshTable(DevNode node) {
        List rows = this.layout.getTable().getAllRows();
        TableRow changeRow = null;
        for (TableRow row : rows) {
            if (!((DevNode)row.getUserObject()).equals(node)) continue;
            changeRow = row;
            break;
        }
        if (changeRow == null) {
            LoggerFactory.getLogger(DevicePatchMainDialog.class).error("resultCallBack error. devnode : " + node.getIp());
            return;
        }
        ProcessingInfo info = PatchDataContext.getInstance().getProcessingInfo(node);
        int pro = info.getTotalProcess();
        if (pro == 100) {
            info.setLastStatus();
        }
        DevPatch.DevPatchStatus status = info.getStatus();
        PatchInfo pInfo = PatchDataContext.getInstance().getPatchInfo(node);
        if (null != pInfo && DevPatch.DevPatchStatus.COMPLETED.equals((Object)status)) {
            String curPatchVer = node.getHotPatchVersion();
            if (Products.isKunpeng(curPatchVer)) {
                curPatchVer = curPatchVer.replace("Kunpeng", "").trim();
            }
            this.changeCurrentVersion((TableRow<DevNode, String>)changeRow, curPatchVer);
            info.setCurrentVer(curPatchVer);
        }
        this.refreshProcessStatus((TableRow<DevNode, String>)changeRow, pro, status);
        this.layout.getDevPatchTable().repaint();
    }

    private void changeCurrentVersion(TableRow<DevNode, String> changeRow, String curPatchVer) {
        if (PatchSceneUtil.isA800PatchEval()) {
            changeRow.setValueAt(4, (Object)curPatchVer);
        } else {
            changeRow.setValueAt(3, (Object)curPatchVer);
        }
    }

    private void refreshProcessStatus(TableRow<DevNode, String> changeRow, int pro, DevPatch.DevPatchStatus status) {
        if (PatchSceneUtil.isA800PatchEval()) {
            changeRow.setValueAt(6, (Object)new IsmTableCell.ProgressCell(pro));
            changeRow.setValueAt(7, (Object)new PatchStatusCell(status));
        } else {
            changeRow.setValueAt(5, (Object)new IsmTableCell.ProgressCell(pro));
            changeRow.setValueAt(6, (Object)new PatchStatusCell(status));
        }
    }

    private void getBottomDetailList() {
        SwingUtilities.invokeLater(() -> {
            JScrollBar bar = this.layout.getDetailListScrolPane().getVerticalScrollBar();
            bar.setValue(bar.getMaximum());
        });
    }

    private int getListIndex(Point point, JList detailList) {
        int index = -1;
        ListUI obj = detailList.getUI();
        if (obj instanceof ArmorListUI) {
            ArmorListUI ui = (ArmorListUI)detailList.getUI();
            index = ui.locationToRow(point);
        } else {
            index = detailList.getSelectedIndex();
        }
        return index;
    }

    @Override
    public void doHelpActionWork() {
        String helpName = this.getHelpName();
        if (ApplicationContext.getInstance().isWindowsOS()) {
            FileUtils.openHelpFile(helpName, this, ".chm");
            return;
        }
        String workDir = ApplicationContext.getInstance().getWorkPath();
        File helpFilePath = new File(workDir, ApplicationContext.getInstance().getHelpPath());
        File helpFile = FilePathUtils.checkFile((File)new File(helpFilePath, helpName + "_" + ApplicationContext.getInstance().getCurrentLanguage().getLanguage() + ".pdf"));
        OSCmdUtils.openFile(helpFile);
    }

    private String getHelpName() {
        if (SceneUtils.isA800SceneInTool()) {
            return PatchSceneUtil.isPatchEvalu() ? A800_PATCH_EVALU_HELP_NAME : A800_PATCH_HELP_NAME;
        }
        return PatchSceneUtil.isPatchEvalu() ? PATCH_EVALU_HELP_NAME : HELP_NAME;
    }

    public IsmTable getDevPatchs() {
        return this.layout.getDevPatchTable();
    }

    @Override
    public void updateItemProgress(DevNode dev, int progress, String itemId) {
        log.info("update item progress, dev: {} , progress: {} , itemId: {}", new Object[]{dev.getIp(), progress, itemId});
        this.updateItemProgress(dev, progress, "", itemId);
    }

    @Override
    public void updateItemProgress(DevNode dev, int progress, String timeLeft, String itemId) {
        try {
            log.info("update item progress, dev: {} , progress: {} ,timeLeft: {}, itemId: {}", new Object[]{dev.getIp(), progress, timeLeft, itemId});
            if (0 > progress || 100 < progress) {
                return;
            }
            if (this.isCurrentItem(itemId)) {
                return;
            }
            ItemProgressUpdateUtil.INS.setProgress(dev.getIp(), progress, timeLeft);
        }
        catch (Exception e) {
            log.error("update item progress error", (Throwable)e);
        }
    }

    private boolean isCurrentItem(String itemId) {
        int itemSize = this.layout.getDetailList().getModel().getSize();
        ExecuteResult currentItem = (ExecuteResult)this.layout.getDetailList().getModel().getElementAt(itemSize - 1);
        if (currentItem == null) {
            return true;
        }
        return !ResourceUtil.getString((String)(PATCH_PROCESS_DETAIL + itemId)).equals(currentItem.getDescription());
    }

    @Override
    public void updateItemProgress(DevNode dev, List<Map<String, Object>> zoneProgress, String itemId) {
        log.info("start upgrade process for {} with param :{}", (Object)dev.getIp(), zoneProgress);
        Map<String, ProgressParam> zoneParam = zoneProgress.stream().map(this::buildParam).collect(Collectors.toMap(ProgressParam::getZoneId, value -> value, (value1, value2) -> value2));
        if (dev instanceof A800Node) {
            log.info("cache a800 node result :{}", (Object)dev.getIp());
            this.cacheZoneProgressResult(dev, itemId, zoneParam);
            return;
        }
        if (dev instanceof DmeNode) {
            log.info("cache zone node result :{}", (Object)dev.getIp());
            DevNode showNode = DevicePatchUtil.transToShowNode(dev);
            this.cacheZoneProgressResult(showNode, itemId, zoneParam);
            return;
        }
        log.warn("not expected zone node, may execute in other scene, do default option, param :{} , node :{} type: {}", new Object[]{zoneProgress, dev.getIp(), dev.getClass()});
        for (Map<String, Object> map : zoneProgress) {
            ProgressParam nodeParam = this.buildParam(map);
            this.updateItemProgress(dev, nodeParam.getProgress(), nodeParam.getTimeLeft(), itemId);
        }
    }

    private void cacheZoneProgressResult(DevNode showNode, String itemId, Map<String, ProgressParam> zoneParam) {
        if (showNode instanceof A800Node) {
            this.updateItemProgress(showNode, this.calculateTotalProgress((A800Node)showNode, zoneParam), itemId);
            ProcessingInfo processInfo = PatchDataContext.getInstance().getProcessingInfo(showNode);
            List<ExecuteResult> executeResults = this.buildSubResults((A800Node)showNode, zoneParam);
            processInfo.getResults().stream().filter(result -> ResourceUtil.getString((String)(PATCH_PROCESS_DETAIL + itemId)).equals(result.getDescription())).forEach(result -> this.updateResult((ExecuteResult)result, executeResults));
            if (this.zoneDetail != null && this.zoneDetail.isVisible() && !executeResults.isEmpty()) {
                this.zoneDetail.updateData(executeResults);
            }
        }
    }

    private void updateResult(ExecuteResult result, List<ExecuteResult> executeResults) {
        List<ExecuteResult> subResults = result.getSubResults();
        if (CollectionUtil.isEmpty(subResults)) {
            result.setSubResults(executeResults);
            return;
        }
        Map zoneResult = subResults.stream().collect(Collectors.toMap(ExecuteResult::getDevNode, Function.identity()));
        for (ExecuteResult newResult : executeResults) {
            ExecuteResult oldResult = (ExecuteResult)zoneResult.get(newResult.getDevNode());
            if (oldResult != null) {
                this.updateResult(oldResult, newResult);
                continue;
            }
            subResults.add(newResult);
        }
    }

    private void updateResult(ExecuteResult oldResult, ExecuteResult newResult) {
        oldResult.setProcess(newResult.getProcess());
        oldResult.setStatus(newResult.getStatus());
    }

    private int calculateTotalProgress(A800Node showNode, Map<String, ProgressParam> zoneParam) {
        int sum = zoneParam.values().stream().mapToInt(ProgressParam::getProgress).filter(progress -> progress != -1).sum();
        return sum / showNode.getZones().size();
    }

    private List<ExecuteResult> buildSubResults(A800Node showNode, Map<String, ProgressParam> zoneParam) {
        return showNode.getZones().stream().filter(zone -> zoneParam.containsKey(zone.getUuid())).map(zone -> this.buildZoneResult((DmeNode)zone, (ProgressParam)zoneParam.get(zone.getUuid()))).collect(Collectors.toList());
    }

    private ExecuteResult buildZoneResult(DmeNode zone, ProgressParam zoneParam) {
        ExecuteResult result = new ExecuteResult(new NodeResult());
        result.setDevNode(zone);
        result.setProcess(zoneParam.getProgress());
        result.setStatus(zoneParam.getStatus());
        result.setDeatail(zoneParam.getMsg());
        return result;
    }

    private ProgressParam buildParam(Map<String, Object> paramMap) {
        return ProgressParam.builder().progress(Integer.parseInt(String.valueOf(paramMap.get("progress")))).zoneId(paramMap.getOrDefault("zone_id", "").toString()).timeLeft(paramMap.getOrDefault("remain_time", "").toString()).msg(paramMap.getOrDefault("err_msg", "").toString()).status(ZoneRunningStatus.of(Integer.parseInt(String.valueOf(paramMap.get("status"))))).build();
    }

    public void updateCheckItems(DevNode node, List<Object> jsonMsg) {
        log.info("update evaluate items.");
        List<ExecuteResult> results = PatchDataContext.getInstance().getProcessingInfo(node).getResults();
        DevicePatchUtil.addNewCheckItems(node, results, jsonMsg);
        DevNode chooseDevNode = this.getChooseDevNode();
        if (null == chooseDevNode || !chooseDevNode.getDeviceSerialNumber().equals(node.getDeviceSerialNumber()) || null == results) {
            return;
        }
        this.layout.getDetailList().setListData(results.toArray());
    }

    private void setReportDir() {
        try {
            HibernateContainer.getInstance().put(SAVEPATH_DEFAULT_ID, (Object)PatchDataContext.getInstance().getReportDir().getCanonicalPath());
        }
        catch (IOException e) {
            log.warn("set choose default dir failed ", (Throwable)e);
        }
        String[] exts = new String[]{};
        File file = ToolFileChooser.selectFile(this, ResourceUtil.getString((String)"patch.main.dialog.set.dic"), exts, SAVEPATH_DEFAULT_ID, ResourceUtil.getString((String)"patch.main.dialog.file"), 1);
        if (!this.validFile(file)) {
            log.info("set report directory for patch evalu failed. validFile");
            return;
        }
        PatchDataContext.getInstance().setReportDir(file);
        log.info(String.format(Locale.ENGLISH, "Set report directory for patch evalu: %s success", file));
    }

    private boolean validFile(File reportDir) {
        if (null == reportDir) {
            return false;
        }
        try {
            String path = reportDir.getCanonicalPath();
            if (!FileUtils.isNormalPath(path)) {
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"patch.main.dialog.select.File.Illegal"));
                this.setReportDir();
                return false;
            }
        }
        catch (IOException e1) {
            log.error("save collect dir failed!!!", (Throwable)e1);
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"patch.main.dialog.set.dic.error"));
            return false;
        }
        return true;
    }

    public void setButtonStatus(boolean isEvalu) {
        if (isEvalu) {
            this.layout.getStartPatchButton().setEnabled(false);
            return;
        }
        this.layout.getStartPatchButton().setEnabled(true);
    }

    @Override
    public final void dispose() {
        List<DevNode> devNodes = PatchDataContext.getInstance().getDevNodes();
        if (devNodes.stream().anyMatch(this::checkBmcWindow)) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"pathtool.close.windown.tips"));
        }
        super.dispose();
    }

    private boolean checkBmcWindow(DevNode devNode) {
        if (null == devNode) {
            return false;
        }
        if (DevPatch.DevPatchStatus.COMPLETED != PatchDataContext.getInstance().getProcessingInfo(devNode).getStatus() || "PATCH_EVALU".equals(devNode.getMatchType())) {
            return false;
        }
        String productVersion = devNode.getProductVersion();
        if (StringUtils.isNULLStr((String)productVersion)) {
            return false;
        }
        if (Products.isDigitalVer(productVersion = productVersion.replace("Kunpeng", "").trim()) && productVersion.contains("SPH")) {
            String tmpVersion = productVersion.split("SPH")[0];
            productVersion = tmpVersion.substring(0, tmpVersion.lastIndexOf("."));
        }
        return BMC_RISK_VERSION.contains(productVersion);
    }

    public RetryData buildRetryData() {
        RetryData retryData = new RetryData();
        if (this.zoneDetail == null || !this.zoneDetail.isVisible()) {
            return retryData;
        }
        DevNode chooseDevNode = this.getChooseDevNode();
        if (chooseDevNode == null) {
            return retryData;
        }
        retryData.setRetryNode(chooseDevNode);
        retryData.setRetryParam(this.zoneDetail.getSelectNodes());
        retryData.setItemId(this.zoneDetail.getCurrentItemId());
        return retryData;
    }

    private class ListMouseAdapter
    extends MouseAdapter {
        private ListMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent) || mouseEvent.getClickCount() > 1) {
                return;
            }
            DevNode devNode = DevicePatchMainDialog.this.getChooseDevNode();
            int index = DevicePatchMainDialog.this.getListIndex(mouseEvent.getPoint(), DevicePatchMainDialog.this.layout.getDetailList());
            if (-1 == index) {
                return;
            }
            this.showDetail(devNode, index);
        }

        private void showDetail(DevNode devNode, int index) {
            ProcessingInfo processInfo = PatchDataContext.getInstance().getProcessingInfo(devNode);
            List<ExecuteResult> results = processInfo.getResults();
            ExecuteResult rec = results.get(index);
            if (CollectionUtil.isEmpty(rec.getSubResults())) {
                ErrorDetailInfoDialog detailDialog = new ErrorDetailInfoDialog(rec.getDetail(), DevicePatchMainDialog.this);
                detailDialog.setVisible(true);
                return;
            }
            DevicePatchMainDialog.this.zoneDetail = new ZoneDetailTableDialog(new UiRetryDataBuildService(DevicePatchMainDialog.this), DevicePatchMainDialog.this, rec.getDescription());
            DevicePatchMainDialog.this.zoneDetail.setShowData(rec.getSubResults());
            DevicePatchMainDialog.this.zoneDetail.setVisible(true);
        }
    }
}

