/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.ui.main;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicepatch.ui.main.DetailListCellRender;
import com.huawei.ism.tool.devicepatch.utils.PatchSceneUtil;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.table.TableModel;

public class DevicePatchMainDialogLayout
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Dimension DEFAULT_SIZE = new Dimension(950, 280);
    private static final int DIVIDER_LOCATION = 250;
    private JButton startPatchButton = null;
    private JButton addDeviceButton = null;
    private JButton configButton = null;
    private JButton rollbackButton = null;
    private JButton deleteDeviceButton = null;
    private JButton setReportDirBtn;
    private JButton openEvaluResult;
    private JButton viewEvaluReport;
    private IsmTable devPatchTable = null;
    private JList detailList = null;
    private JScrollPane detailListScrolPane = null;
    private String[] tableHeaders = new String[]{ResourceUtil.getString((String)"patch.main.table.name"), ResourceUtil.getString((String)"patch.main.table.modelver"), ResourceUtil.getString((String)"patch.main.table.ip"), ResourceUtil.getString((String)"patch.main.table.patchversion"), ResourceUtil.getString((String)"patch.main.table.pkgversion"), ResourceUtil.getString((String)"patch.main.table.progress"), ResourceUtil.getString((String)"patch.main.table.status"), ResourceUtil.getString((String)"patch.main.table.detail")};
    private String[] tableHeadersForEval = new String[]{ResourceUtil.getString((String)"patch.main.table.name"), ResourceUtil.getString((String)"patch.main.table.modelver"), ResourceUtil.getString((String)"patch.main.table.ip"), ResourceUtil.getString((String)"patch.main.table.patchversion"), ResourceUtil.getString((String)"patch.main.table.targetversion"), ResourceUtil.getString((String)"patch.main.table.progress"), ResourceUtil.getString((String)"patch.main.table.result")};
    private String[] headersForA800 = new String[]{ResourceUtil.getString((String)"patch.main.table.parent.name"), ResourceUtil.getString((String)"patch.main.table.name"), ResourceUtil.getString((String)"patch.main.table.modelver"), ResourceUtil.getString((String)"patch.main.table.ip"), ResourceUtil.getString((String)"patch.main.table.patchversion"), ResourceUtil.getString((String)"patch.main.table.targetversion"), ResourceUtil.getString((String)"patch.main.table.progress"), ResourceUtil.getString((String)"patch.main.table.result")};
    private DefaultTableModel table = null;

    public DevicePatchMainDialogLayout() {
        this.initUIComponent();
        this.layoutComponent();
    }

    private void initUIComponent() {
        this.table = this.initTableModel();
        this.devPatchTable = new IsmTable((TableModel)this.table);
        this.startPatchButton = UiMethod.createButton((String)ResourceUtil.getString((String)"patch.main.button.start"), (char)'S');
        this.addDeviceButton = UiMethod.createButton((String)ResourceUtil.getString((String)"patch.main.button.add"), (char)'A');
        this.configButton = UiMethod.createButton((String)ResourceUtil.getString((String)"patch.main.button.config"), (char)'C');
        this.configButton.setPreferredSize(UiMethod.computeButtonPreferredSize((JButton)this.configButton));
        this.rollbackButton = UiMethod.createButton((String)ResourceUtil.getString((String)"patch.main.table.a800.rollback"), (char)'E');
        this.deleteDeviceButton = UiMethod.createButton((String)ResourceUtil.getString((String)"patch.main.button.remove"), (char)'R');
        this.setReportDirBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"patch.main.button.set.dir"), (char)'D');
        this.openEvaluResult = UiMethod.createButton((String)ResourceUtil.getString((String)"patch.main.button.open.dic"), (char)'O');
        this.openEvaluResult.setToolTipText(ResourceUtil.getString((String)"patch.main.button.view.open.tip"));
        this.viewEvaluReport = UiMethod.createButton((String)ResourceUtil.getString((String)"patch.main.button.see.report"), (char)'V');
        this.viewEvaluReport.setToolTipText(ResourceUtil.getString((String)"patch.main.button.view.report.tip"));
        this.detailList = new JList(new DefaultListModel());
        this.detailList.setCellRenderer(new DetailListCellRender());
        this.detailList.setSelectionMode(0);
        if (PatchSceneUtil.isScene()) {
            this.deleteDeviceButton.setEnabled(false);
        }
        if (PatchSceneUtil.isA800PatchEval()) {
            this.deleteDeviceButton.setEnabled(true);
        }
    }

    private void layoutComponent() {
        JTextArea intro = UiMethod.createJTextArea((String)this.getMainIntroTips());
        JSplitPane splitPane = new JSplitPane(0, true);
        JTextArea introArea = intro;
        introArea.setAlignmentX(0.0f);
        JComponent buttonArea = this.buttonPanel();
        buttonArea.setAlignmentX(0.0f);
        JComponent tableArea = this.tablePanel();
        tableArea.setAlignmentX(0.0f);
        JComponent detailArea = this.detailPanel();
        detailArea.setAlignmentX(0.0f);
        splitPane.setTopComponent(tableArea);
        splitPane.setBottomComponent(detailArea);
        splitPane.setDividerLocation(250);
        splitPane.setBorder(null);
        Box viewReportTtnArea = UCD.buildHBoxRight((Component[])new Component[]{this.openEvaluResult, this.viewEvaluReport});
        viewReportTtnArea.setAlignmentX(0.0f);
        Box mainBox = Box.createVerticalBox();
        if (PatchSceneUtil.isPatchEvalu()) {
            mainBox.add(UCD.buildVerticalBox(null, (Component[])new Component[]{introArea, buttonArea, splitPane, viewReportTtnArea}));
        } else {
            mainBox.add(UCD.buildVerticalBox(null, (Component[])new Component[]{introArea, buttonArea, splitPane}));
        }
        this.setLayout(new BorderLayout());
        this.add(UiMethod.buildFrameSpace((JComponent)mainBox, (int)12));
    }

    private String getMainIntroTips() {
        if (PatchSceneUtil.isA800HotPatch()) {
            return ResourceUtil.getString((String)"patch.main.a800.eval.intro");
        }
        return ResourceUtil.getString((String)"patch.main.intro");
    }

    private DefaultTableModel initTableModel() {
        if (PatchSceneUtil.isStoragePatchEvalu()) {
            return new DefaultTableModel(this.tableHeadersForEval, new int[0]);
        }
        if (PatchSceneUtil.isA800PatchEval()) {
            return new DefaultTableModel(this.headersForA800, new int[0]);
        }
        return new DefaultTableModel(this.tableHeaders, new int[0]);
    }

    private JComponent tablePanel() {
        TableScrollPane tsp = new TableScrollPane(this.devPatchTable, true, true, true);
        tsp.setPreferredSize(DEFAULT_SIZE);
        tsp.setMinimumSize(new Dimension(tsp.getPreferredSize().width, 80));
        return tsp;
    }

    private JComponent detailPanel() {
        this.detailListScrolPane = new JScrollPane(this.detailList);
        this.detailListScrolPane.setPreferredSize(DEFAULT_SIZE);
        return this.detailListScrolPane;
    }

    private JComponent buttonPanel() {
        if (PatchSceneUtil.isStoragePatchEvalu()) {
            return UiMethod.buildCompsLeft((Component[])new Component[]{this.startPatchButton, this.addDeviceButton, this.deleteDeviceButton, this.setReportDirBtn});
        }
        if (PatchSceneUtil.isA800HotPatch()) {
            return UiMethod.buildCompsLeft((Component[])new Component[]{this.startPatchButton, this.configButton, this.rollbackButton});
        }
        return UiMethod.buildCompsLeft((Component[])new Component[]{this.startPatchButton, this.addDeviceButton, this.deleteDeviceButton});
    }

    public JButton getStartPatchButton() {
        return this.startPatchButton;
    }

    public JButton getAddDeviceButton() {
        return this.addDeviceButton;
    }

    public JButton getDeleteDeviceButton() {
        return this.deleteDeviceButton;
    }

    public IsmTable getDevPatchTable() {
        return this.devPatchTable;
    }

    public JList getDetailList() {
        return this.detailList;
    }

    public JScrollPane getDetailListScrolPane() {
        return this.detailListScrolPane;
    }

    public String[] getTableHeaders() {
        return (String[])this.tableHeaders.clone();
    }

    public DefaultTableModel getTable() {
        return this.table;
    }

    public JButton getSetReportDirBtn() {
        return this.setReportDirBtn;
    }

    public JButton getOpenEvaluResult() {
        return this.openEvaluResult;
    }

    public JButton getViewEvaluReport() {
        return this.viewEvaluReport;
    }

    public void setCompName() {
        this.startPatchButton.setName("_Button_startPatchButton");
        this.addDeviceButton.setName("_Button_addDeviceButton");
        this.deleteDeviceButton.setName("_Button_deleteDeviceButton");
        this.setReportDirBtn.setName("_JButton_setReportDirBtn");
        this.devPatchTable.setName("_Table_devPatchTable");
        this.detailList.setName("_List_detailList");
    }

    public JButton getConfigButton() {
        return this.configButton;
    }

    public JButton getRollbackButton() {
        return this.rollbackButton;
    }
}

