/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.ui.main;

import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.utils.DevicePatchConstants;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.IsmTableCellRenderer;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public final class PatchStatusCell
extends IsmTableCell {
    private static final long serialVersionUID = 1L;
    private static final int NUM_17 = 17;
    private DevPatch.DevPatchStatus status = DevPatch.DevPatchStatus.NOTASSOCIATED;
    private IsmTableCellRenderer render = new PatchStatusRender();

    public PatchStatusCell(DevPatch.DevPatchStatus status) {
        this.status = status;
    }

    public DevPatch.DevPatchStatus getStatus() {
        return this.status;
    }

    public TableCellRenderer getRender() {
        return this.render;
    }

    public String toString() {
        return this.status.toString();
    }

    public int compareTo(IsmTableCell cell) {
        if (!(cell instanceof PatchStatusCell)) {
            return -1;
        }
        DevPatch.DevPatchStatus devstatus = this.status;
        DevPatch.DevPatchStatus value = ((PatchStatusCell)cell).getStatus();
        if (devstatus.ordinal() > value.ordinal()) {
            return 1;
        }
        if (devstatus.ordinal() < value.ordinal()) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchStatusCell)) {
            return false;
        }
        DevPatch.DevPatchStatus thatVal = ((PatchStatusCell)((Object)obj)).getStatus();
        return thatVal.equals((Object)this.getStatus());
    }

    public int hashCode() {
        return 17 + this.status.hashCode();
    }

    private static class PatchStatusRender
    extends IsmTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private PatchStatusRender() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JLabel label = (JLabel)comp;
            PatchStatusCell cell = (PatchStatusCell)((Object)value);
            DevPatch.DevPatchStatus status = cell.getStatus();
            if (status.equals((Object)DevPatch.DevPatchStatus.COMPLETED)) {
                label.setIcon(DevicePatchConstants.SUCCESS_IMAGE);
            } else if (status.equals((Object)DevPatch.DevPatchStatus.RUNNING) || status.equals((Object)DevPatch.DevPatchStatus.WAITING)) {
                label.setIcon(DevicePatchConstants.PROCESSING_IMAGE);
            } else if (status.equals((Object)DevPatch.DevPatchStatus.FAILED) || status.equals((Object)DevPatch.DevPatchStatus.NOTASSOCIATED)) {
                label.setIcon(DevicePatchConstants.FAILED_IMAGE);
            }
            label.setText(status.toString());
            return label;
        }
    }
}

