/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.ui.main.detail;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicepatch.entity.ExecuteResult;
import com.huawei.ism.tool.devicepatch.ui.listener.RetryAction;
import com.huawei.ism.tool.devicepatch.ui.listener.service.RetryDataBuildService;
import com.huawei.ism.tool.devicepatch.ui.main.dialog.ErrorDetailInfoDialog;
import com.huawei.ism.tool.devicepatch.ui.main.entity.enums.ZoneRunningStatus;
import com.huawei.ism.tool.devicepatch.utils.DevicePatchConstants;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ToolUCD;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class ZoneDetailTablePanel
extends JPanel {
    private final JButton batchRetry = UiMethod.createButton(ResourceUtil.getString((String)"patch.main.table.zone.retry"));
    private final String[] tableHeaderColumns = new String[]{ResourceUtil.getString((String)"patch.main.table.ip"), ResourceUtil.getString((String)"patch.main.table.name"), ResourceUtil.getString((String)"patch.main.table.model"), ResourceUtil.getString((String)"patch.main.table.progress"), ResourceUtil.getString((String)"patch.main.table.status"), ResourceUtil.getString((String)"patch.card.step1.table.step"), ResourceUtil.getString((String)"detail.zones.option.detail")};
    private final DefaultTableModel deviceTableModel = new DefaultTableModel(this.tableHeaderColumns, new int[0]);
    private final IsmTable dataTable = new IsmTable((TableModel)this.deviceTableModel);
    private final Window showDialog;
    private final RetryDataBuildService retryDataBuildService;

    public ZoneDetailTablePanel(RetryDataBuildService retryDataBuildService, Window showDialog) {
        this.showDialog = showDialog;
        this.retryDataBuildService = retryDataBuildService;
        this.initUi();
    }

    public void setTableData(List<ExecuteResult> results) {
        this.dataTable.removeAll();
        this.deviceTableModel.removeAll();
        ArrayList<TableRow<ExecuteResult, DevNode>> datas = new ArrayList<TableRow<ExecuteResult, DevNode>>();
        for (ExecuteResult result : results) {
            datas.add(this.buildRow(result));
        }
        this.deviceTableModel.addRows(datas);
        this.dataTable.markTableRows(datas.toArray());
    }

    @NotNull
    private TableRow<ExecuteResult, DevNode> buildRow(ExecuteResult result) {
        DefaultTableRow nodeRow = new DefaultTableRow(this.deviceTableModel.getColumnCount(), (Object)result, (Object)result.getDevNode());
        this.setRowValue((TableRow)nodeRow, result);
        return nodeRow;
    }

    public void bindListener() {
        this.batchRetry.addActionListener(new RetryAction(this.showDialog, this.retryDataBuildService));
    }

    private void initUi() {
        this.setLayout(new BorderLayout());
        this.add((Component)UCD.buildVerticalBox(null, (Component[])new Component[]{this.createTopPanel(), this.createMiddlePanel()}), "North");
    }

    private JComponent createTopPanel() {
        return UCD.buildVerticalBox(null, (int)0, (Component[])new Component[]{Box.createHorizontalStrut(12), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(12), UCD.buildHBoxLeft((Component[])new Component[]{this.batchRetry})})});
    }

    private void setRowValue(TableRow nodeRow, ExecuteResult result) {
        DevNode zoneNode = result.getDevNode();
        int index = 0;
        nodeRow.setValueAt(index++, (Object)zoneNode.getIp());
        nodeRow.setValueAt(index++, (Object)zoneNode.getDeviceName());
        nodeRow.setValueAt(index++, (Object)zoneNode.getProductModel());
        nodeRow.setValueAt(index++, (Object)new IsmTableCell.ProgressCell(result.getProcess()));
        nodeRow.setValueAt(index++, (Object)new IsmTableCell.IconCell(ZoneDetailTablePanel.buildStatusIcon(result.getStatus()), result.getStatus().toString()));
        nodeRow.setValueAt(index++, this.isFailed(result.getStatus()) ? new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"patch.main.table.zone.retry"), (ActionListener)new RetryAction(this.showDialog, this.retryDataBuildService)) : "N/A");
        nodeRow.setValueAt(index, (Object)new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"detail.zones.option.detail"), e -> this.showDetail(result)));
    }

    private void showDetail(ExecuteResult result) {
        ErrorDetailInfoDialog detailDialog = new ErrorDetailInfoDialog(result.getDetail(), this.showDialog);
        detailDialog.setVisible(true);
    }

    private boolean isFailed(ZoneRunningStatus status) {
        return ZoneRunningStatus.UPD_UPD_FAIL.equals((Object)status);
    }

    @NotNull
    private static Icon buildStatusIcon(ZoneRunningStatus status) {
        if (ZoneRunningStatus.UPD_UPD_SUCCESS.equals((Object)status)) {
            return DevicePatchConstants.SUCCESS_IMAGE;
        }
        if (ZoneRunningStatus.UPD_UPGRADING.equals((Object)status)) {
            return DevicePatchConstants.PROCESSING_IMAGE;
        }
        if (ZoneRunningStatus.UPD_UPD_FAIL.equals((Object)status)) {
            return DevicePatchConstants.FAILED_IMAGE;
        }
        return DevicePatchConstants.NOT_EVALU_IMAGE;
    }

    private JComponent createDataTableCom() {
        ToolUCD.setStandardFont(this.dataTable.getTableHeader());
        TableScrollPane tableScrollPane = new TableScrollPane(this.dataTable, true, true, true);
        JComponent tableComponent = UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createVerticalStrut(2), tableScrollPane});
        tableComponent.setBorder(new TitledBorder(ResourceUtil.getString((String)"detail.zones.detail")));
        return tableComponent;
    }

    private JComponent createMiddlePanel() {
        return UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(0), this.createDataTableCom()});
    }

    public void updateData(List<ExecuteResult> executeResults) {
        for (TableRow row : this.getDataTable().getAllRows()) {
            Object identifier = row.getIdentifier();
            executeResults.stream().filter(result -> result.getDevNode().equals(identifier)).findFirst().ifPresent(result -> this.setRowValue(row, (ExecuteResult)result));
        }
        this.getDataTable().repaint();
    }

    public IsmTable getDataTable() {
        return this.dataTable;
    }
}

