/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.ui.main.dialog;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.BizPackage;
import com.huawei.ism.tool.bizpack.PackProduct;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.table.TableModel;

public class ImportDetailDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final Dimension DIALOG_SIZE = new Dimension(500, 700);
    private JButton okButton = UiMethod.createButton(ResourceUtil.getString((String)"patch.dialog.import.button.ok"));
    private JButton cancelButton = UiMethod.createButton(ResourceUtil.getString((String)"patch.dialog.import.button.cancel"));
    private JLabel pkgName = new JLabel();
    private JLabel pkgVer = new JLabel();
    private JLabel pkgDate = new JLabel();
    private String[] titles = new String[]{ResourceUtil.getString((String)"patch.main.table.model"), ResourceUtil.getString((String)"patch.card.step1.table.version")};
    private DefaultTableModel tableModel = new DefaultTableModel(this.titles, new int[0]);
    private IsmTable verTable = null;
    private boolean isOK = false;

    public ImportDetailDialog(BizPackage pkg, Window window) {
        super(window);
        this.initUI();
        this.initLinister();
        this.initDate(pkg);
    }

    private void initLinister() {
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ImportDetailDialog.this.isOK = true;
                ImportDetailDialog.this.setVisible(false);
                DialogUtils.showInfoDialog((JDialog)ImportDetailDialog.this, (String)ResourceUtil.getString((String)"patch.card.step1.import.success"));
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportDetailDialog.this.isOK = false;
                ImportDetailDialog.this.setVisible(false);
            }
        });
    }

    private void initDate(BizPackage pkg) {
        this.pkgName.setText(pkg.getName());
        this.pkgVer.setText(pkg.getVersion());
        this.pkgDate.setText(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(pkg.getPublishDate()));
        for (PackProduct pros : pkg.getPackProducts()) {
            TableRow<PackProduct, String> row = this.createDeviceTableRow(pros);
            this.tableModel.addRow(new TableRow[]{row});
        }
    }

    private TableRow<PackProduct, String> createDeviceTableRow(PackProduct pro) {
        StringBuffer sb = new StringBuffer();
        for (String ver : pro.getVersions()) {
            sb.append(ver);
            sb.append(" ; ");
        }
        DefaultTableRow row = new DefaultTableRow(this.tableModel.getColumnCount(), (Object)pro, (Object)pro.getProductName());
        row.setValueAt(0, (Object)pro.getProductName());
        row.setValueAt(1, (Object)sb.toString());
        return row;
    }

    private void initUI() {
        this.setTitle(ResourceUtil.getString((String)"patch.dialog.import.title"));
        this.setModal(true);
        this.setResizable(false);
        this.validate();
        this.pack();
        this.setMinimumSize(DIALOG_SIZE);
        SwingUtil.putScreenCenter((Window)this);
        this.okButton.setName("_Button_okButton");
        this.cancelButton.setName("_Button_cancelButton");
        this.verTable.setName("_Table_verTable");
        JComponent mainCom = UCD.buildVerticalBox(null, (Component[])new Component[]{this.buildInfoPanel(), this.buildTablePanel(), this.bulidButtonPanel()});
        this.setLayout(new BorderLayout());
        this.add(UiMethod.buildFrameSpace(mainCom, 12));
    }

    public JComponent buildInfoPanel() {
        JLabel name = UiMethod.createLabel(ResourceUtil.getString((String)"patch.dialog.import.label.name"));
        JLabel ver = UiMethod.createLabel(ResourceUtil.getString((String)"patch.dialog.import.label.ver"));
        JLabel date = UiMethod.createLabel(ResourceUtil.getString((String)"patch.dialog.import.label.date"));
        JComponent[] left = new JComponent[]{name, ver, date};
        JComponent[] right = new JComponent[]{this.pkgName, this.pkgVer, this.pkgDate};
        return UiMethod.createSquareLayoutPanel(left, right, new int[0]);
    }

    public JComponent buildTablePanel() {
        this.verTable = new IsmTable((TableModel)this.tableModel);
        return new TableScrollPane(this.verTable);
    }

    public JComponent bulidButtonPanel() {
        return UCD.buildHBoxRight((Component[])new Component[]{this.okButton, this.cancelButton});
    }

    public boolean clickOk() {
        return this.isOK;
    }
}

