/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.ui.main.dialog;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.ui.dialogs.PublicDialog;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.InputConfirmPanel;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.table.TableModel;

public class PatchComfirmDialog
extends PublicDialog {
    private static final long serialVersionUID = -2209933409624245159L;
    private ImageIcon qestionImg = ResourceUtil.getImage((String)"danger.png");
    private List<DevNode> devs;
    private String[] patchTableHeader = new String[]{ResourceUtil.getString((String)"patch.maindialog.devicetable.ipaddress"), ResourceUtil.getString((String)"patch.maindialog.devicetable.current.version"), ResourceUtil.getString((String)"patch.maindialog.devicetable.target.version")};
    private DefaultTableModel defaultTableModel = new DefaultTableModel(this.patchTableHeader, new int[]{0, 1, 2});
    private IsmTable deviceTable = new IsmTable((TableModel)this.defaultTableModel);
    private boolean isOKClick = false;
    private JCheckBox checkBox = new JCheckBox(ResourceUtil.getString((String)"patch.comfirm.dlg.confirm"));
    private InputConfirmPanel inputConfirmPanel = new InputConfirmPanel(ResourceUtil.getString((String)"patch.comfirm.dlg.confirm"), "Yes", Collections.singletonList(this.getOkBtn()));

    public PatchComfirmDialog(JDialog parent, List<DevNode> devs) {
        super(parent);
        this.setModal(true);
        this.devs = devs;
        this.setTitle(ResourceUtil.getString((String)"patch.comfirm.dlg.title"));
        this.getOkBtn().setEnabled(false);
        this.setAppButtonVisible(false);
        this.setHelpButtonVisiable(false);
        this.initTableData();
        this.getContentPanel().setLayout(new BorderLayout());
        this.getContentPanel().add(this.craeteUI(), "Center");
        this.getContentPanel().add((Component)this.getConfirmBox(), "South");
        UiMethod.setComponentSize(new Dimension(850, 500), this);
        this.pack();
        this.setResizable(false);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
        SwingUtil.putScreenCenter((Window)this);
        this.initListener();
        this.setCompName();
    }

    private JComponent getConfirmBox() {
        return UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), this.inputConfirmPanel});
    }

    private void initTableData() {
        for (DevNode dev : this.devs) {
            DefaultTableRow row = new DefaultTableRow(3, (Object)dev);
            String currentVersion = dev.getHotPatchVersion();
            String targetVersion = PatchDataContext.getInstance().getPatchInfo(dev).getVersion();
            row.setValueAt(0, (Object)dev.getIp());
            row.setValueAt(1, (Object)currentVersion);
            row.setValueAt(2, (Object)targetVersion);
            this.defaultTableModel.addRow(new TableRow[]{row});
        }
    }

    private void initListener() {
        this.getOkBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PatchComfirmDialog.this.isOKClick = true;
                PatchComfirmDialog.this.dispose();
            }
        });
        this.checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (PatchComfirmDialog.this.checkBox.isSelected()) {
                    PatchComfirmDialog.this.getOkBtn().setEnabled(true);
                } else {
                    PatchComfirmDialog.this.getOkBtn().setEnabled(false);
                }
            }
        });
    }

    private Component craeteUI() {
        JTextArea tipsText = UiMethod.createJTextArea(ResourceUtil.getString((String)"patch.comfirm.dlg.tips"));
        JScrollPane tableJScorll = new JScrollPane((Component)this.deviceTable);
        return UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createVerticalStrut(0), UCD.buildHBoxRight((Component[])new Component[]{Box.createHorizontalStrut(0), new JLabel(this.qestionImg), tipsText, Box.createHorizontalStrut(0)}), UCD.buildHorizotalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(0), tableJScorll, Box.createHorizontalStrut(0)}), Box.createVerticalStrut(0)});
    }

    public boolean isOk() {
        this.setVisible(true);
        return this.isOKClick;
    }

    private void setCompName() {
        this.checkBox.setName("_JCheckBox_checkBox");
    }
}

